/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;

public class SourceProductAnnotationValidationTest
extends TestCase {
    private OperatorSpi wrongTypeOpSpi;
    private OperatorSpi wrongBandsOpSpi;
    private OperatorSpi goodOpSpi;
    private OperatorSpi consumerOpSpi;
    private OperatorSpi optionalConsumerOpSpi;
    private OperatorSpi aliasConsumerOpSpi;

    protected void setUp() throws Exception {
        this.wrongTypeOpSpi = new WrongTypeOperator.Spi();
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        spiRegistry.addOperatorSpi(this.wrongTypeOpSpi);
        this.wrongBandsOpSpi = new WrongBandsOperator.Spi();
        spiRegistry.addOperatorSpi(this.wrongBandsOpSpi);
        this.goodOpSpi = new GoodOperator.Spi();
        spiRegistry.addOperatorSpi(this.goodOpSpi);
        this.consumerOpSpi = new ConsumerOperator.Spi();
        spiRegistry.addOperatorSpi(this.consumerOpSpi);
        this.aliasConsumerOpSpi = new ConsumerWithAliasSourceOperator.Spi();
        spiRegistry.addOperatorSpi(this.aliasConsumerOpSpi);
        this.optionalConsumerOpSpi = new OptionalConsumerOperator.Spi();
        spiRegistry.addOperatorSpi(this.optionalConsumerOpSpi);
    }

    protected void tearDown() {
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        spiRegistry.removeOperatorSpi(this.wrongTypeOpSpi);
        spiRegistry.removeOperatorSpi(this.wrongBandsOpSpi);
        spiRegistry.removeOperatorSpi(this.goodOpSpi);
        spiRegistry.removeOperatorSpi(this.consumerOpSpi);
        spiRegistry.removeOperatorSpi(this.aliasConsumerOpSpi);
        spiRegistry.removeOperatorSpi(this.optionalConsumerOpSpi);
    }

    public void testForWrongType() {
        Graph graph = new Graph("graph");
        Node wrongTypeNode = new Node("WrongType", this.wrongTypeOpSpi.getOperatorAlias());
        Node consumerNode = new Node("Consumer", this.consumerOpSpi.getOperatorAlias());
        consumerNode.addSource(new NodeSource("input1", "WrongType"));
        graph.addNode(wrongTypeNode);
        graph.addNode(consumerNode);
        try {
            new GraphContext(graph);
            SourceProductAnnotationValidationTest.fail((String)"GraphException expected caused by wrong type of source product");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testForWrongBands() {
        Graph graph = new Graph("graph");
        Node wrongBandsNode = new Node("WrongBands", this.wrongBandsOpSpi.getOperatorAlias());
        Node consumerNode = new Node("Consumer", this.consumerOpSpi.getOperatorAlias());
        consumerNode.addSource(new NodeSource("input1", "WrongBands"));
        graph.addNode(wrongBandsNode);
        graph.addNode(consumerNode);
        try {
            new GraphContext(graph);
            SourceProductAnnotationValidationTest.fail((String)"GraphException expected, caused by missing bands");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testOptionalAndWrongProductIsGiven() {
        Graph graph = new Graph("graph");
        Node wrongBandsNode = new Node("WrongBands", this.wrongBandsOpSpi.getOperatorAlias());
        Node consumerNode = new Node("OptionalConsumer", this.optionalConsumerOpSpi.getOperatorAlias());
        consumerNode.addSource(new NodeSource("input1", "WrongBands"));
        graph.addNode(wrongBandsNode);
        graph.addNode(consumerNode);
        try {
            new GraphContext(graph);
            SourceProductAnnotationValidationTest.fail((String)"GraphException expected, caused by missing bands, even if optional");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testOptionalAndWrongProductIsNotGiven() throws GraphException {
        Graph graph = new Graph("graph");
        Node wrongBandsNode = new Node("WrongBands", this.wrongBandsOpSpi.getOperatorAlias());
        Node consumerNode = new Node("OptionalConsumer", this.optionalConsumerOpSpi.getOperatorAlias());
        graph.addNode(wrongBandsNode);
        graph.addNode(consumerNode);
        new GraphContext(graph);
    }

    public void testNotInitialzedInputResultsInException() {
        Graph graph = new Graph("graph");
        Node goodNode = new Node("Good", this.goodOpSpi.getOperatorAlias());
        Node consumerNode = new Node("Consumer", this.consumerOpSpi.getOperatorAlias());
        graph.addNode(goodNode);
        graph.addNode(consumerNode);
        try {
            new GraphContext(graph);
            SourceProductAnnotationValidationTest.fail((String)"GraphException expected, because input1 is not initialized");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testSourceProductWithAlias() throws GraphException {
        Graph graph = new Graph("graph");
        Node goodNode = new Node("Good", this.goodOpSpi.getOperatorAlias());
        Node consumerNode = new Node("AliasConsumer", this.aliasConsumerOpSpi.getOperatorAlias());
        consumerNode.addSource(new NodeSource("alias", "Good"));
        graph.addNode(goodNode);
        graph.addNode(consumerNode);
        GraphContext graphContext = new GraphContext(graph);
        NodeContext consumerNodeContext = graphContext.getNodeContext(consumerNode);
        SourceProductAnnotationValidationTest.assertSame((Object)((ConsumerWithAliasSourceOperator)consumerNodeContext.getOperator()).input1, (Object)consumerNodeContext.getSourceProduct("alias"));
    }

    @OperatorMetadata(alias="ConsumerWithAliasSourceOperator")
    public static class ConsumerWithAliasSourceOperator
    extends Operator {
        @SourceProduct(alias="alias")
        Product input1;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 1, 1);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(ConsumerWithAliasSourceOperator.class);
            }
        }
    }

    @OperatorMetadata(alias="OptionalConsumerOperator")
    public static class OptionalConsumerOperator
    extends Operator {
        @SourceProduct(optional=true, type="Optional", bands={"c", "d"})
        Product input1;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 1, 1);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(OptionalConsumerOperator.class);
            }
        }
    }

    @OperatorMetadata(alias="ConsumerOperator")
    public static class ConsumerOperator
    extends Operator {
        @SourceProduct(type="GoodType", bands={"a", "b"})
        Product input1;
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("output", "outputType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(ConsumerOperator.class);
            }
        }
    }

    @OperatorMetadata(alias="GoodOperator")
    public static class GoodOperator
    extends Operator {
        @TargetProduct
        private Product targetProduct;

        public void initialize() throws OperatorException {
            this.targetProduct = new Product("Good", "GoodType", 1, 1);
            this.targetProduct.addBand("a", 10);
            this.targetProduct.addBand("b", 10);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(GoodOperator.class);
            }
        }
    }

    @OperatorMetadata(alias="WrongBandsOperator")
    public static class WrongBandsOperator
    extends Operator {
        @TargetProduct
        private Product targetProduct;

        public void initialize() throws OperatorException {
            this.targetProduct = new Product("WrongBands", "GoodType", 1, 1);
            this.targetProduct.addBand("x", 10);
            this.targetProduct.addBand("y", 10);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(WrongBandsOperator.class);
            }
        }
    }

    @OperatorMetadata(alias="WrongTypeOperator")
    public static class WrongTypeOperator
    extends Operator {
        @TargetProduct
        Product output;

        public void initialize() throws OperatorException {
            this.output = new Product("Wrong", "WrongType", 12, 12);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(WrongTypeOperator.class);
            }
        }
    }
}

