/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileScheduler;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.GPFFacadeTest;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadDoWriteTest {
    private ReadOp.Spi readSpi = new ReadOp.Spi();
    private DoOp.Spi doSpi = new DoOp.Spi();
    private WriteOp.Spi writeSpi = new WriteOp.Spi();
    private File outputFile;
    private File inputFile;
    private int oldParallelism;

    @Before
    public void setUp() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.readSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.doSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.writeSpi);
        URI inputURI = GPFFacadeTest.class.getResource("test-product.dim").toURI();
        this.inputFile = new File(inputURI);
        this.outputFile = GlobalTestConfig.getBeamTestDataOutputFile((String)"ReadDoWriteTest/writtenProduct.dim");
        this.outputFile.getParentFile().mkdirs();
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        this.oldParallelism = tileScheduler.getParallelism();
        tileScheduler.setParallelism(Runtime.getRuntime().availableProcessors());
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.readSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.doSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.writeSpi);
        File parentFile = this.outputFile.getParentFile();
        FileUtils.deleteTree((File)parentFile);
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        tileScheduler.setParallelism(this.oldParallelism);
    }

    @Test
    public void testWrite() throws Exception {
        String graphOpXml = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node0\">\n    <operator>Read</operator>\n    <parameters>\n       <file>" + this.inputFile.getAbsolutePath() + "</file>\n" + "    </parameters>\n" + "  </node>\n" + "  <node id=\"node1\">\n" + "    <operator>Do</operator>\n" + "    <sources>\n" + "      <source refid=\"node0\"/>\n" + "    </sources>\n" + "  </node>\n" + "  <node id=\"node2\">\n" + "    <operator>Write</operator>\n" + "    <sources>\n" + "      <source refid=\"node1\"/>\n" + "    </sources>\n" + "    <parameters>\n" + "       <file>" + this.outputFile.getAbsolutePath() + "</file>\n" + "       <deleteOutputOnFailure>false</deleteOutputOnFailure>\n" + "    </parameters>\n" + "  </node>\n" + "</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        GraphProcessor processor = new GraphProcessor();
        processor.executeGraph(graph, ProgressMonitor.NULL);
        Product productOnDisk = ProductIO.readProduct((File)this.outputFile);
        Assert.assertNotNull((Object)productOnDisk);
        Assert.assertEquals((Object)"writtenProduct", (Object)productOnDisk.getName());
        Assert.assertEquals((long)4L, (long)productOnDisk.getNumBands());
        Assert.assertEquals((Object)"OperatorBand", (Object)productOnDisk.getBandAt(0).getName());
        Assert.assertEquals((Object)"ConstantBand", (Object)productOnDisk.getBandAt(1).getName());
        Assert.assertEquals((Object)"VirtualBand", (Object)productOnDisk.getBandAt(2).getName());
        Assert.assertEquals((Object)"forrest_abundance", (Object)productOnDisk.getBandAt(3).getName());
        Band operatorBand = productOnDisk.getBandAt(0);
        operatorBand.loadRasterData();
        Assert.assertEquals((long)42L, (long)operatorBand.getPixelInt(0, 0));
        Band constBand = productOnDisk.getBandAt(1);
        constBand.loadRasterData();
        Assert.assertEquals((double)66.6f, (double)constBand.getPixelFloat(0, 0), (double)1.0E-6);
        Band virtualBand = productOnDisk.getBandAt(2);
        virtualBand.loadRasterData();
        Assert.assertEquals((double)108.6f, (double)virtualBand.getPixelFloat(0, 0), (double)1.0E-6);
        Band transferedBand = productOnDisk.getBandAt(3);
        transferedBand.loadRasterData();
        Assert.assertEquals((double)0.567, (double)transferedBand.getPixelFloat(0, 0), (double)0.01);
        productOnDisk.dispose();
    }

    @OperatorMetadata(alias="Do")
    public static class DoOp
    extends Operator {
        @SourceProduct(alias="source")
        private Product sourceProduct;
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            int width = this.sourceProduct.getSceneRasterWidth();
            int height = this.sourceProduct.getSceneRasterHeight();
            RenderedOp constImage = ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Float[]{Float.valueOf(66.6f)}, null);
            this.targetProduct = new Product("name", "desc", width, height);
            this.targetProduct.addBand("OperatorBand", 10);
            this.targetProduct.addBand("ConstantBand", 30).setSourceImage((RenderedImage)constImage);
            this.targetProduct.addBand((Band)new VirtualBand("VirtualBand", 30, width, height, "OperatorBand + ConstantBand"));
            ProductUtils.copyBand((String)this.sourceProduct.getBandAt(0).getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            if (!band.getName().equals("OperatorBand")) {
                throw new OperatorException("operator called for wrong band: " + band.getName());
            }
            for (Tile.Pos pos : targetTile) {
                targetTile.setSample(pos.x, pos.y, 42);
            }
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(DoOp.class);
            }
        }
    }
}

