/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import junit.framework.TestCase;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.Node;

public class GraphTest
extends TestCase {
    public void testEmptyChain() {
        Graph graph = new Graph("chain1");
        GraphTest.assertEquals((String)"chain1", (String)graph.getId());
        GraphTest.assertNotNull((Object)graph.getNodes());
    }

    public void testOneNodeChain() {
        Graph graph = new Graph("chain1");
        Node node = new Node("node1", "org.esa.snap.core.gpf.TestOps$Op1Spi");
        try {
            graph.addNode(node);
        }
        catch (IllegalArgumentException e) {
            GraphTest.fail((String)e.getMessage());
        }
        GraphTest.assertEquals((String)"chain1", (String)graph.getId());
        GraphTest.assertNotNull((Object)graph.getNodes());
        GraphTest.assertEquals((Object)node, (Object)graph.getNode("node1"));
    }

    public void testRemoveNode() {
        Graph graph = new Graph("chain1");
        Node node = new Node("node1", "org.esa.snap.core.gpf.TestOps$Op1Spi");
        try {
            graph.addNode(node);
        }
        catch (IllegalArgumentException e) {
            GraphTest.fail((String)e.getMessage());
        }
        boolean result = graph.removeNode("node1");
        GraphTest.assertEquals((String)"chain1", (String)graph.getId());
        GraphTest.assertNotNull((Object)graph.getNodes());
        GraphTest.assertTrue((boolean)result);
        GraphTest.assertNull((Object)graph.getNode("node1"));
    }

    public void testAddExistingNode() {
        Graph graph = new Graph("chain1");
        Node node1 = new Node("node1", "org.esa.snap.core.gpf.TestOps$Op1Spi");
        Node node2 = new Node("node1", "org.esa.snap.core.gpf.TestOps$Op2Spi");
        try {
            graph.addNode(node1);
            graph.addNode(node2);
            GraphTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testApplicationData() throws Exception {
        Graph graph = new Graph("chain1");
        GraphTest.assertNull((Object)graph.getApplicationData("foo"));
        XppDom xpp3Dom1 = new XppDom("");
        XppDom font = new XppDom("font");
        font.setValue("big");
        xpp3Dom1.addChild(font);
        graph.setAppData("foo", xpp3Dom1);
        GraphTest.assertSame((Object)xpp3Dom1, (Object)graph.getApplicationData("foo"));
        XppDom xpp3Dom2 = new XppDom("");
        XppDom font2 = new XppDom("font");
        font2.setValue("small");
        xpp3Dom2.addChild(font2);
        graph.setAppData("foo", xpp3Dom2);
        GraphTest.assertSame((Object)xpp3Dom2, (Object)graph.getApplicationData("foo"));
    }
}

