/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphOp;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Method GraphOp#setOperatorParameters(...) needs to be implemented.")
public class GraphOpTest {
    private final TestOps.Op1.Spi operatorSpi1 = new TestOps.Op1.Spi();
    private final TestOps.Op2.Spi operatorSpi2 = new TestOps.Op2.Spi();
    private OperatorSpi graphOpSpiOneNode;
    private OperatorSpi graphOpSpiTwoNodes;
    private OperatorSpi usesOtherGraphSpi;

    private static OperatorSpi createOp2GraphSpi() throws GraphException {
        String graphOpXml = "<graph id=\"Op2Graph\">\n  <version>1.0</version>\n  <header>\n    <target refid=\"node2\" />\n    <source name=\"toa\" description=\"AATSR L1b TOA\"/>\n    <parameter name=\"THR\" defaultValue=\"42.0\" type=\"double\"/>\n  </header>\n  <node id=\"node2\">\n    <operator>Op2</operator>\n    <sources>\n      <input refid=\"toa\"/>\n    </sources>\n    <parameters>\n       <threshold refid=\"THR\"/>\n    </parameters>\n  </node>\n</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        return new GraphOp.Spi(graph){};
    }

    private static OperatorSpi createSourcelessOp1Op2GraphSpi() throws GraphException {
        String graphOpXml = "<graph id=\"SourcelessOp1Op2Graph\">\n  <version>1.0</version>\n  <header>\n    <target refid=\"node2\" />\n    <parameter name=\"THR\" defaultValue=\"42.0\" type=\"double\"/>\n  </header>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n  </node>\n  <node id=\"node2\">\n    <operator>Op2</operator>\n    <sources>\n      <input refid=\"node1\"/>\n    </sources>\n    <parameters>\n       <threshold refid=\"THR\"/>\n    </parameters>\n  </node>\n</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        return new GraphOp.Spi(graph){};
    }

    private static OperatorSpi createUsesOtherGraphSpi() throws GraphException {
        String graphOpXml = "<graph id=\"UsesOtherGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>SourcelessOp1Op2Graph</operator>\n    <parameters>\n       <THR>33</THR>\n    </parameters>\n  </node>\n</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        return new GraphOp.Spi(graph){};
    }

    @Before
    protected void setUp() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi1);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi2);
        this.graphOpSpiOneNode = GraphOpTest.createOp2GraphSpi();
        this.graphOpSpiTwoNodes = GraphOpTest.createSourcelessOp1Op2GraphSpi();
        this.usesOtherGraphSpi = GraphOpTest.createUsesOtherGraphSpi();
        Assert.assertTrue((boolean)GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(this.graphOpSpiOneNode));
        Assert.assertTrue((boolean)GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(this.graphOpSpiTwoNodes));
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(this.usesOtherGraphSpi);
    }

    @After
    protected void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi1);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi2);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi(this.graphOpSpiOneNode);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi(this.graphOpSpiTwoNodes);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi(this.usesOtherGraphSpi);
    }

    @Test
    public void testParameterValuesAreUsedFromHeader() throws Exception {
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>(1);
        Product testProduct = new Product("p", "t", 1, 1);
        testProduct.addBand("Op1A", 10);
        sourceProducts.put("toa", testProduct);
        Product targetProduct = GPF.createProduct((String)"Op2Graph", new HashMap(), sourceProducts);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((Object)"Op2Name", (Object)targetProduct.getName());
        OperatorProductReader operatorProductReader = (OperatorProductReader)targetProduct.getProductReader();
        Operator operator = operatorProductReader.getOperatorContext().getOperator();
        TestOps.Op2 op2 = (TestOps.Op2)operator;
        Assert.assertEquals((double)24.0, (double)op2.threshold, (double)1.0E-5);
    }

    @Test
    public void testOneNodeDirectCall() throws Exception {
        HashMap<String, Double> parameters = new HashMap<String, Double>(1);
        parameters.put("THR", 65.0);
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>(1);
        Product testProduct = new Product("p", "t", 1, 1);
        testProduct.addBand("Op1A", 10);
        sourceProducts.put("toa", testProduct);
        Product targetProduct = GPF.createProduct((String)"Op2Graph", parameters, sourceProducts);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((Object)"Op2Name", (Object)targetProduct.getName());
        OperatorProductReader operatorProductReader = (OperatorProductReader)targetProduct.getProductReader();
        Operator operator = operatorProductReader.getOperatorContext().getOperator();
        TestOps.Op2 op2 = (TestOps.Op2)operator;
        Assert.assertEquals((double)65.0, (double)op2.threshold, (double)1.0E-5);
    }

    @Test
    public void testTwoNodesDirectCall() throws Exception {
        HashMap<String, Double> parameters = new HashMap<String, Double>(1);
        parameters.put("THR", 66.0);
        Product targetProduct = GPF.createProduct((String)"SourcelessOp1Op2Graph", parameters, (Map)Collections.EMPTY_MAP);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((Object)"Op2Name", (Object)targetProduct.getName());
        OperatorProductReader operatorProductReader = (OperatorProductReader)targetProduct.getProductReader();
        Operator operator = operatorProductReader.getOperatorContext().getOperator();
        TestOps.Op2 op2 = (TestOps.Op2)operator;
        Assert.assertEquals((double)66.0, (double)op2.threshold, (double)1.0E-5);
    }

    @Test
    public void testUsesOtherGraph() throws Exception {
        HashMap<String, Double> parameters = new HashMap<String, Double>(1);
        parameters.put("THR", 67.0);
        Product targetProduct = GPF.createProduct((String)"UsesOtherGraph", parameters, (Map)Collections.EMPTY_MAP);
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((Object)"Op2Name", (Object)targetProduct.getName());
        OperatorProductReader operatorProductReader = (OperatorProductReader)targetProduct.getProductReader();
        Operator operator = operatorProductReader.getOperatorContext().getOperator();
        TestOps.Op2 op2 = (TestOps.Op2)operator;
        Assert.assertEquals((double)67.0, (double)op2.threshold, (double)1.0E-5);
    }
}

