/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.HeaderParameter;
import org.esa.snap.core.gpf.graph.HeaderSource;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GraphIOTest {
    private TestOps.Op1.Spi operatorSpi1 = new TestOps.Op1.Spi();
    private TestOps.Op2.Spi operatorSpi2 = new TestOps.Op2.Spi();
    private TestOps.Op3.Spi operatorSpi3 = new TestOps.Op3.Spi();
    private TestOps.Op4.Spi operatorSpi4 = new TestOps.Op4.Spi();

    @Before
    public void setUp() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi1);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi2);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi3);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.operatorSpi4);
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi1);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi2);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi3);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.operatorSpi4);
    }

    @Test
    public void testEmptyChain() throws Exception {
        Graph chain1 = new Graph("myEmptyChain");
        Graph chain2 = this.doIO(chain1);
        Node[] nodes = chain2.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)0, (int)nodes.length);
        Assert.assertEquals((String)chain1.getId(), (String)chain2.getId());
    }

    @Test
    public void testOneNodeChain() throws Exception {
        Graph graph1 = new Graph("myOneNodeGraph");
        Node node1 = new Node("node1", "Op1");
        graph1.addNode(node1);
        Graph chain2 = this.doIO(graph1);
        Node[] nodes = chain2.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)1, (int)nodes.length);
        TestCase.assertNotNull((Object)nodes[0]);
        Assert.assertEquals((String)graph1.getId(), (String)chain2.getId());
        Node node1Copy = chain2.getNode("node1");
        TestCase.assertSame((Object)nodes[0], (Object)node1Copy);
        Assert.assertEquals((String)"Op1", (String)node1Copy.getOperatorName());
    }

    @Test
    public void testWriteToXML() throws Exception {
        Graph graph1 = new Graph("myOneNodeGraph");
        Node node1 = new Node("node1", "Op1");
        graph1.addNode(node1);
        StringWriter writer = new StringWriter();
        GraphIO.write((Graph)graph1, (Writer)writer);
        String actualXML = writer.toString();
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources/>\n  </node>\n</graph>";
        Assert.assertEquals((String)expectedXML, (String)actualXML);
    }

    @Test
    public void testWriteToXMLWithApplicationData() throws Exception {
        Graph graph1 = new Graph("myOneNodeGraph");
        Node node1 = new Node("node1", "Op1");
        graph1.addNode(node1);
        XppDom xpp3Dom = new XppDom("");
        XppDom font = new XppDom("font");
        font.setValue("big");
        xpp3Dom.addChild(font);
        graph1.setAppData("foo", xpp3Dom);
        XppDom xpp3Dom2 = new XppDom("");
        XppDom colour = new XppDom("colour");
        colour.setValue("red");
        xpp3Dom2.addChild(colour);
        graph1.setAppData("baz", xpp3Dom2);
        StringWriter writer = new StringWriter();
        GraphIO.write((Graph)graph1, (Writer)writer);
        String actualXML = writer.toString();
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources/>\n  </node>\n  <applicationData id=\"foo\">\n    <font>big</font>\n  </applicationData>\n  <applicationData id=\"baz\">\n    <colour>red</colour>\n  </applicationData>\n</graph>";
        Assert.assertEquals((String)expectedXML, (String)actualXML);
    }

    @Test
    public void testReadXMLWithoutVersion() throws Exception {
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources/>\n  </node>\n</graph>";
        StringReader reader = new StringReader(expectedXML);
        GraphException caught = null;
        try {
            GraphIO.read((Reader)reader);
            TestCase.fail((String)"version should be checked");
        }
        catch (GraphException e) {
            caught = e;
        }
        TestCase.assertNotNull((Object)((Object)caught));
        Assert.assertEquals(GraphException.class, ((Object)((Object)caught)).getClass());
    }

    @Test
    public void testReadFromXML() throws Exception {
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources/>\n  </node>\n</graph>";
        StringReader reader = new StringReader(expectedXML);
        Graph graph = GraphIO.read((Reader)reader);
        Node[] nodes = graph.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)1, (int)nodes.length);
        TestCase.assertNotNull((Object)nodes[0]);
        Assert.assertEquals((String)"myOneNodeGraph", (String)graph.getId());
        Node node1 = graph.getNode("node1");
        TestCase.assertNotNull((Object)node1);
        Assert.assertEquals((String)"Op1", (String)node1.getOperatorName());
    }

    @Test
    public void testReadFromXMLWithAppData() throws Exception {
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources/>\n  </node>\n <applicationData id=\"foo\">\n    <font>Big</font>\n    <colour>red</colour>\n </applicationData>\n <applicationData id=\"bar\">\n    <textmode>true</textmode>\n </applicationData>\n</graph>";
        StringReader reader = new StringReader(expectedXML);
        Graph graph = GraphIO.read((Reader)reader);
        XppDom fooData = graph.getApplicationData("foo");
        TestCase.assertNotNull((Object)fooData);
        Assert.assertEquals((int)2, (int)fooData.getChildCount());
        Assert.assertEquals((String)"Big", (String)fooData.getChild("font").getValue());
        Assert.assertEquals((String)"red", (String)fooData.getChild("colour").getValue());
        XppDom barData = graph.getApplicationData("bar");
        TestCase.assertNotNull((Object)barData);
        Assert.assertEquals((int)1, (int)barData.getChildCount());
        Assert.assertEquals((String)"true", (String)barData.getChild("textmode").getValue());
    }

    @Test
    public void testReadFromXMLWithHeader() throws Exception {
        String expectedXML = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <header>\n    <target refid=\"node1\" />\n    <source name=\"input1\" optional=\"true\" description=\"AATSR L1b TOA\"/>\n    <source name=\"input2\" description=\"CHRIS/proba\">C:\\data\\x.dim</source>\n    <parameter name=\"ignore\" defaultValue=\"true\" type=\"boolean\"/>\n    <parameter name=\"regex\" description=\"a regular expression\" type=\"String\"/>\n    <parameter name=\"threshold\" type=\"double\" interval=\"(0,1]\"/>\n    <parameter name=\"ernie\" type=\"int\" valueSet=\"2,4,6,8\"/>\n  </header>\n  <node id=\"node1\">\n    <operator>Op1</operator>\n    <sources>\n      <toa refid=\"input1\"/>\n      <chris refid=\"input2\"/>\n    </sources>\n    <parameters>\n       <ignoreSign refid=\"ignore\"/>\n       <expression refid=\"regex\"/>\n    </parameters>\n  </node>\n</graph>";
        StringReader reader = new StringReader(expectedXML);
        Graph graph = GraphIO.read((Reader)reader);
        Header header = graph.getHeader();
        TestCase.assertNotNull((Object)header);
        Assert.assertEquals((String)"node1", (String)header.getTarget().getNodeId());
        List sources = header.getSources();
        TestCase.assertNotNull((Object)sources);
        Assert.assertEquals((int)2, (int)sources.size());
        Assert.assertEquals((String)"input1", (String)((HeaderSource)sources.get(0)).getName());
        Assert.assertEquals((boolean)true, (boolean)((HeaderSource)sources.get(0)).isOptional());
        Assert.assertEquals((String)"AATSR L1b TOA", (String)((HeaderSource)sources.get(0)).getDescription());
        Assert.assertEquals((String)"input2", (String)((HeaderSource)sources.get(1)).getName());
        Assert.assertEquals((boolean)false, (boolean)((HeaderSource)sources.get(1)).isOptional());
        Assert.assertEquals((String)"C:\\data\\x.dim", (String)((HeaderSource)sources.get(1)).getLocation());
        List parameters = header.getParameters();
        TestCase.assertNotNull((Object)parameters);
        Assert.assertEquals((int)4, (int)parameters.size());
        Assert.assertEquals((String)"ignore", (String)((HeaderParameter)parameters.get(0)).getName());
        Assert.assertEquals((String)"true", (String)((HeaderParameter)parameters.get(0)).getDefaultValue());
        Assert.assertEquals((String)"boolean", (String)((HeaderParameter)parameters.get(0)).getType());
        Assert.assertEquals((String)"regex", (String)((HeaderParameter)parameters.get(1)).getName());
        Assert.assertEquals((String)"a regular expression", (String)((HeaderParameter)parameters.get(1)).getDescription());
        Assert.assertEquals((String)"String", (String)((HeaderParameter)parameters.get(1)).getType());
        Assert.assertEquals((String)"threshold", (String)((HeaderParameter)parameters.get(2)).getName());
        Assert.assertEquals((String)"(0,1]", (String)((HeaderParameter)parameters.get(2)).getInterval());
        Assert.assertEquals((String)"double", (String)((HeaderParameter)parameters.get(2)).getType());
        Assert.assertEquals((String)"ernie", (String)((HeaderParameter)parameters.get(3)).getName());
        String[] expected = new String[]{"2", "4", "6", "8"};
        Assert.assertEquals((int)expected.length, (int)((HeaderParameter)parameters.get(3)).getValueSet().length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)expected[i], (String)((HeaderParameter)parameters.get(3)).getValueSet()[i]);
        }
        Assert.assertEquals((String)"int", (String)((HeaderParameter)parameters.get(3)).getType());
        Node[] nodes = graph.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)1, (int)nodes.length);
        TestCase.assertNotNull((Object)nodes[0]);
        Assert.assertEquals((String)"myOneNodeGraph", (String)graph.getId());
        Node node1 = graph.getNode("node1");
        TestCase.assertNotNull((Object)node1);
        Assert.assertEquals((String)"Op1", (String)node1.getOperatorName());
    }

    @Test
    public void testTwoNodeChain() throws Exception {
        Graph graph1 = new Graph("myTwoNodeGraph");
        Node node1 = new Node("node1", "Op1");
        Node node2 = new Node("node2", "Op2");
        node2.addSource(new NodeSource("key1", "node1"));
        graph1.addNode(node1);
        graph1.addNode(node2);
        Graph graph2 = this.doIO(graph1);
        Assert.assertEquals((String)graph1.getId(), (String)graph2.getId());
        Node[] nodes = graph2.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)2, (int)nodes.length);
        TestCase.assertNotNull((Object)nodes[0]);
        TestCase.assertNotNull((Object)nodes[1]);
        Node node1Copy = graph2.getNode("node1");
        Node node2Copy = graph2.getNode("node2");
        TestCase.assertSame((Object)nodes[0], (Object)node1Copy);
        TestCase.assertSame((Object)nodes[1], (Object)node2Copy);
        NodeSource[] sources1 = node1Copy.getSources();
        TestCase.assertNotNull((Object)sources1);
        Assert.assertEquals((int)0, (int)sources1.length);
        NodeSource[] sources2 = node2Copy.getSources();
        TestCase.assertNotNull((Object)sources2);
        Assert.assertEquals((int)1, (int)sources2.length);
        NodeSource source2 = node2Copy.getSource(0);
        TestCase.assertSame((Object)sources2[0], (Object)source2);
        Assert.assertEquals((String)"Op1", (String)node1Copy.getOperatorName());
        Assert.assertEquals((String)"Op2", (String)node2Copy.getOperatorName());
        Assert.assertEquals((String)"node1", (String)source2.getSourceNodeId());
    }

    @Test
    public void testReadXml() throws Exception {
        String xml = "<graph id=\"foo\">\n<version>1.0</version>\n  <node id=\"grunt\">\n    <operator>Op1</operator>\n  </node>\n  <node id=\"baz\">\n    <operator>Op2</operator>\n    <sources>\n      <input refid=\"grunt\"/>\n    </sources>\n    <parameters>\n       <threshold>0.86</threshold>\n    </parameters>\n  </node>\n  <node id=\"bar\">\n    <operator>Op3</operator>\n    <sources>\n      <input1 refid=\"grunt\"/>\n      <input2 refid=\"baz\"/>\n    </sources>\n    <parameters>\n       <ignoreSign>true</ignoreSign>\n       <expression>A+B</expression>\n    </parameters>\n  </node>\n</graph>";
        Graph graph = GraphIO.read((Reader)new StringReader(xml));
        Assert.assertEquals((String)"foo", (String)graph.getId());
        Node[] nodes = graph.getNodes();
        TestCase.assertNotNull((Object)nodes);
        Assert.assertEquals((int)3, (int)nodes.length);
        TestCase.assertNotNull((Object)nodes[0]);
        TestCase.assertNotNull((Object)nodes[1]);
        Node node1 = graph.getNode("grunt");
        Node node2 = graph.getNode("baz");
        Node node3 = graph.getNode("bar");
        TestCase.assertSame((Object)nodes[0], (Object)node1);
        TestCase.assertSame((Object)nodes[1], (Object)node2);
        TestCase.assertSame((Object)nodes[2], (Object)node3);
        Assert.assertEquals((String)"Op1", (String)node1.getOperatorName());
        Assert.assertEquals((String)"Op2", (String)node2.getOperatorName());
        Assert.assertEquals((String)"Op3", (String)node3.getOperatorName());
        NodeSource[] sources1 = node1.getSources();
        TestCase.assertNotNull((Object)sources1);
        Assert.assertEquals((int)0, (int)sources1.length);
        NodeSource[] sources2 = node2.getSources();
        TestCase.assertNotNull((Object)sources2);
        Assert.assertEquals((int)1, (int)sources2.length);
        Assert.assertEquals((String)"grunt", (String)sources2[0].getSourceNodeId());
        NodeSource[] sources3 = node3.getSources();
        TestCase.assertNotNull((Object)sources3);
        Assert.assertEquals((int)2, (int)sources3.length);
        Assert.assertEquals((String)"grunt", (String)sources3[0].getSourceNodeId());
        Assert.assertEquals((String)"baz", (String)sources3[1].getSourceNodeId());
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = null;
        try {
            graphContext = new GraphContext(graph);
        }
        catch (GraphException e) {
            TestCase.fail((String)e.getMessage());
        }
        NodeContext nodeContext2 = graphContext.getNodeContext(node2);
        TestOps.Op2 op2 = (TestOps.Op2)nodeContext2.getOperator();
        Assert.assertEquals((double)0.86, (double)op2.threshold, (double)1.0E-10);
        NodeContext nodeContext3 = graphContext.getNodeContext(node3);
        TestOps.Op3 op3 = (TestOps.Op3)nodeContext3.getOperator();
        Assert.assertEquals((boolean)true, (boolean)op3.ignoreSign);
        Assert.assertEquals((String)"A+B", (String)op3.expression);
    }

    private Graph doIO(Graph chain1) throws Exception {
        StringWriter writer = new StringWriter();
        GraphIO.write((Graph)chain1, (Writer)writer);
        String xml = writer.toString();
        StringReader reader = new StringReader(xml);
        return GraphIO.read((Reader)reader);
    }

    @Test
    public void testGraphWithReference() throws Exception {
        String xml = "<graph id=\"foo\">\n<version>1.0</version>\n  <node id=\"bert\">\n    <operator>Op4</operator>\n  </node>\n  <node id=\"baz\">\n    <operator>Op2</operator>\n    <sources>\n      <input refid=\"bert\"/>\n    </sources>\n    <parameters>\n       <threshold refid=\"bert.pi\"/>\n    </parameters>\n  </node>\n</graph>";
        Graph graph = GraphIO.read((Reader)new StringReader(xml));
        Node bertNode = graph.getNode("bert");
        Assert.assertEquals((String)"Op4", (String)bertNode.getOperatorName());
        Node bazNode = graph.getNode("baz");
        Assert.assertEquals((String)"Op2", (String)bazNode.getOperatorName());
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = null;
        try {
            graphContext = new GraphContext(graph);
        }
        catch (GraphException e) {
            TestCase.fail((String)e.getMessage());
        }
        NodeContext bertNodeContext = graphContext.getNodeContext(bertNode);
        TestOps.Op4 op4 = (TestOps.Op4)bertNodeContext.getOperator();
        Object targetProperty = op4.getTargetProperty("pi");
        TestCase.assertNotNull((Object)targetProperty);
        Assert.assertEquals((double)3.142, (double)((Double)targetProperty), (double)0.0);
        NodeContext bazNodeContext = graphContext.getNodeContext(bazNode);
        TestOps.Op2 op2 = (TestOps.Op2)bazNodeContext.getOperator();
        Assert.assertEquals((double)3.142, (double)op2.threshold, (double)0.0);
    }

    @Test
    public void testGraphWithReferenceWithoutSourceProduct() throws Exception {
        String xml = "<graph id=\"foo\">\n<version>1.0</version>\n  <node id=\"grunt\">\n    <operator>Op1</operator>\n  </node>\n  <node id=\"bert\">\n    <operator>Op4</operator>\n  </node>\n  <node id=\"baz\">\n    <operator>Op2</operator>\n    <sources>\n      <input refid=\"grunt\"/>\n    </sources>\n    <parameters>\n       <threshold refid=\"bert.pi\"/>\n    </parameters>\n  </node>\n</graph>";
        Graph graph = GraphIO.read((Reader)new StringReader(xml));
        Node gruntNode = graph.getNode("grunt");
        Assert.assertEquals((String)"Op1", (String)gruntNode.getOperatorName());
        Node bazNode = graph.getNode("baz");
        Assert.assertEquals((String)"Op2", (String)bazNode.getOperatorName());
        Node bertNode = graph.getNode("bert");
        Assert.assertEquals((String)"Op4", (String)bertNode.getOperatorName());
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = null;
        try {
            graphContext = new GraphContext(graph);
        }
        catch (GraphException e) {
            TestCase.fail((String)e.getMessage());
        }
        NodeContext bertNodeContext = graphContext.getNodeContext(bertNode);
        TestOps.Op4 op4 = (TestOps.Op4)bertNodeContext.getOperator();
        Object targetProperty = op4.getTargetProperty("pi");
        TestCase.assertNotNull((Object)targetProperty);
        Assert.assertEquals((double)3.142, (double)((Double)targetProperty), (double)0.0);
        NodeContext bazNodeContext = graphContext.getNodeContext(bazNode);
        TestOps.Op2 op2 = (TestOps.Op2)bazNodeContext.getOperator();
        Assert.assertEquals((double)3.142, (double)op2.threshold, (double)0.0);
    }

    @Test
    public void testAddSourceProductsVariable() {
        HashMap<String, String> sourceProductNamesMap = new HashMap<String, String>();
        sourceProductNamesMap.put("sourceProduct", "no1");
        sourceProductNamesMap.put("sourceProduct1", "no2");
        sourceProductNamesMap.put("sourceProduct2", "no3");
        sourceProductNamesMap.put("sourceProduct3", "no4");
        HashMap<String, String> sourceProductNamesMap2 = new HashMap<String, String>();
        sourceProductNamesMap2.put("sourceProduct1", "no2");
        sourceProductNamesMap2.put("sourceProduct", "no1");
        sourceProductNamesMap2.put("sourceProduct3", "no4");
        sourceProductNamesMap2.put("sourceProduct1", "no2");
        sourceProductNamesMap2.put("sourceProduct2", "no3");
        sourceProductNamesMap2.put("sourceProduct.2", "no3");
        sourceProductNamesMap2.put("sourceProduct3", "no4");
        sourceProductNamesMap2.put("sourceProduct.3", "no4");
        GraphIO.addSourceProductsVariable(sourceProductNamesMap);
        GraphIO.addSourceProductsVariable(sourceProductNamesMap2);
        Assert.assertEquals((boolean)true, (boolean)sourceProductNamesMap.containsKey("sourceProducts"));
        Assert.assertEquals((boolean)true, (boolean)sourceProductNamesMap2.containsKey("sourceProducts"));
        Assert.assertEquals((String)"no2,no3,no4", (String)((String)sourceProductNamesMap.get("sourceProducts")));
        Assert.assertEquals((String)"no2,no3,no4", (String)((String)sourceProductNamesMap2.get("sourceProducts")));
    }
}

