/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.TestOps;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.util.jai.VerbousTileCache;

public class GraphContextTest
extends TestCase {
    private OperatorSpi spi1;
    private OperatorSpi spi2;
    private OperatorSpi spi3;
    private TileCache jaiTileCache;
    private TileCache testTileCache;

    protected void setUp() throws Exception {
        this.jaiTileCache = JAI.getDefaultInstance().getTileCache();
        this.testTileCache = new VerbousTileCache(this.jaiTileCache);
        JAI.getDefaultInstance().setTileCache(this.testTileCache);
        this.testTileCache.flush();
        TestOps.clearCalls();
        this.spi1 = new TestOps.Op1.Spi();
        this.spi2 = new TestOps.Op2.Spi();
        this.spi3 = new TestOps.Op3.Spi();
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.addOperatorSpi(this.spi1);
        registry.addOperatorSpi(this.spi2);
        registry.addOperatorSpi(this.spi3);
    }

    protected void tearDown() throws Exception {
        this.testTileCache.flush();
        JAI.getDefaultInstance().setTileCache(this.jaiTileCache);
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        spiRegistry.removeOperatorSpi(this.spi1);
        spiRegistry.removeOperatorSpi(this.spi2);
        spiRegistry.removeOperatorSpi(this.spi3);
    }

    public void testEmptyChain() {
        Graph graph = new Graph("test-graph");
        try {
            new GraphContext(graph);
            GraphContextTest.fail((String)"GraphException expected due to empty graph");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testSourceToNodeResolving() throws GraphException {
        Graph graph = new Graph("chain1");
        Node node1 = new Node("node1", "org.esa.snap.core.gpf.TestOps$Op1$Spi");
        Node node2 = new Node("node2", "org.esa.snap.core.gpf.TestOps$Op2$Spi");
        node2.addSource(new NodeSource("input", "node1"));
        Node node3 = new Node("node3", "org.esa.snap.core.gpf.TestOps$Op3$Spi");
        node3.addSource(new NodeSource("input1", "node1"));
        node3.addSource(new NodeSource("input2", "node2"));
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        GraphContext graphContext = new GraphContext(graph);
        GraphContextTest.assertEquals((Object)node2.getSource(0).getSourceNode(), (Object)node1);
        GraphContextTest.assertEquals((Object)node3.getSource(0).getSourceNode(), (Object)node1);
        GraphContextTest.assertEquals((Object)node3.getSource(1).getSourceNode(), (Object)node2);
        GraphContextTest.assertFalse((boolean)graphContext.getNodeContext(node1).isOutput());
        GraphContextTest.assertFalse((boolean)graphContext.getNodeContext(node2).isOutput());
        GraphContextTest.assertTrue((boolean)graphContext.getNodeContext(node3).isOutput());
    }

    public void testSpiCreation() throws GraphException {
        Graph graph = new Graph("chain1");
        Node node1 = new Node("node1", "Op1");
        graph.addNode(node1);
        GraphContext graphContext = new GraphContext(graph);
        NodeContext nodeContext = graphContext.getNodeContext(node1);
        GraphContextTest.assertEquals((String)"Op1", (String)graph.getNode("node1").getOperatorName());
        GraphContextTest.assertEquals((String)"org.esa.snap.core.gpf.TestOps$Op1", (String)nodeContext.getOperator().getClass().getName());
    }

    public void testTargetProductCreation() throws GraphException {
        Graph graph = new Graph("chain1");
        Node node1 = new Node("node1", "Op1");
        graph.addNode(node1);
        GraphContext graphContext = new GraphContext(graph);
        Product[] outputProducts = graphContext.getOutputProducts();
        GraphContextTest.assertNotNull((Object)outputProducts);
        GraphContextTest.assertEquals((int)1, (int)outputProducts.length);
        GraphContextTest.assertNotNull((Object)outputProducts[0]);
    }

    public void testAnnotationsProcessed() throws Exception {
        Graph graph = new Graph("graph");
        Node node1 = new Node("node1", "Op1");
        Node node2 = new Node("node2", "Op2");
        Node node3 = new Node("node3", "Op3");
        node2.addSource(new NodeSource("input", "node1"));
        node3.addSource(new NodeSource("input1", "node1"));
        node3.addSource(new NodeSource("input2", "node2"));
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        GraphContext graphContext = new GraphContext(graph);
        NodeContext nodeContext2 = graphContext.getNodeContext(node2);
        NodeContext nodeContext3 = graphContext.getNodeContext(node3);
        TestOps.Op2 op2 = (TestOps.Op2)nodeContext2.getOperator();
        TestOps.Op3 op3 = (TestOps.Op3)nodeContext3.getOperator();
        GraphContextTest.assertNotNull((Object)op2.input);
        GraphContextTest.assertSame((Object)nodeContext2.getSourceProduct("input"), (Object)op2.input);
        GraphContextTest.assertNotNull((Object)op3.input1);
        GraphContextTest.assertNotNull((Object)op3.input2);
        GraphContextTest.assertSame((Object)nodeContext3.getSourceProduct("input1"), (Object)op3.input1);
        GraphContextTest.assertSame((Object)nodeContext3.getSourceProduct("input2"), (Object)op3.input2);
        GraphContextTest.assertNotNull((Object)op3.inputs);
        GraphContextTest.assertEquals((int)0, (int)op3.inputs.length);
        GraphContextTest.assertEquals((boolean)false, (boolean)op3.ignoreSign);
        GraphContextTest.assertEquals((String)"NN", (String)op3.interpolMethod);
        GraphContextTest.assertEquals((Object)1.5, (Object)op3.factor);
    }

    public void testMissingNode() {
        Graph graph = new Graph("graph");
        Node node1 = new Node("node1", "Op1");
        Node node2 = new Node("node2", "Op2");
        Node node3 = new Node("node3", "Op3");
        node2.addSource(new NodeSource("input", "node1"));
        node3.addSource(new NodeSource("input1", "node1"));
        node3.addSource(new NodeSource("input2", "node2"));
        try {
            graph.addNode(node1);
            graph.addNode(node3);
            new GraphContext(graph);
            GraphContextTest.fail((String)"GraphException expected.");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testMissingSpi() {
        Graph graph = new Graph("graph");
        Node node1 = new Node("node1", "Opa");
        Node node2 = new Node("node2", "Op2");
        Node node3 = new Node("node3", "Op3");
        node2.addSource(new NodeSource("input", "node1"));
        node3.addSource(new NodeSource("input1", "node1"));
        node3.addSource(new NodeSource("input2", "node2"));
        try {
            graph.addNode(node1);
            graph.addNode(node3);
            new GraphContext(graph);
            GraphContextTest.fail((String)"GraphException expected.");
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }
}

