/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.JAI;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;

public class GraphCallSequenceTest
extends TestCase {
    private static List<String> callRecordList = Collections.synchronizedList(new ArrayList());
    private N1Spi n1Spi;
    private N2Spi n2Spi;
    private N3Spi n3Spi;
    private N4Spi n4Spi;
    private N5Spi n5Spi;
    private N6Spi n6Spi;

    protected void setUp() throws Exception {
        this.n1Spi = new N1Spi();
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.addOperatorSpi((OperatorSpi)this.n1Spi);
        this.n2Spi = new N2Spi();
        registry.addOperatorSpi((OperatorSpi)this.n2Spi);
        this.n3Spi = new N3Spi();
        registry.addOperatorSpi((OperatorSpi)this.n3Spi);
        this.n4Spi = new N4Spi();
        registry.addOperatorSpi((OperatorSpi)this.n4Spi);
        this.n5Spi = new N5Spi();
        registry.addOperatorSpi((OperatorSpi)this.n5Spi);
        this.n6Spi = new N6Spi();
        registry.addOperatorSpi((OperatorSpi)this.n6Spi);
        callRecordList.clear();
        JAI.getDefaultInstance().getTileCache().flush();
    }

    protected void tearDown() throws Exception {
        JAI.getDefaultInstance().getTileCache().flush();
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n1Spi);
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n2Spi);
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n3Spi);
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n4Spi);
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n5Spi);
        spiRegistry.removeOperatorSpi((OperatorSpi)this.n6Spi);
        callRecordList.clear();
    }

    public void testTwoNodeTraversion() throws GraphException {
        Node node1 = new Node("N1", "N1");
        Node node2 = new Node("N2", "N2");
        node2.addSource(new NodeSource("input", "N1"));
        Graph graph = new Graph("test-graph");
        graph.addNode(node1);
        graph.addNode(node2);
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = new GraphContext(graph);
        Product[] targetProducts = processor.executeGraph(graphContext, ProgressMonitor.NULL);
        GraphCallSequenceTest.assertNotNull((Object)targetProducts);
        GraphCallSequenceTest.assertEquals((int)1, (int)targetProducts.length);
        GraphCallSequenceTest.assertNotNull((Object)targetProducts[0]);
        GraphCallSequenceTest.assertEquals((String)"N2", (String)targetProducts[0].getName());
        graphContext.dispose();
        String[] expectedRecordStrings = new String[]{"N1:Operator.initialize", "N1:Product.construct", "N2:Operator.initialize", "N2:Product.construct", "N2:Operator.computeBand", "N1:Operator.computeBand", "N2:Product.dispose", "N2:Operator.dispose", "N1:Product.dispose", "N1:Operator.dispose"};
        GraphCallSequenceTest.assertEquals((int)expectedRecordStrings.length, (int)callRecordList.size());
        for (int i = 0; i < expectedRecordStrings.length; ++i) {
            GraphCallSequenceTest.assertEquals((String)expectedRecordStrings[i], (String)callRecordList.get(i));
        }
    }

    public void testThreeNodeTraversion() throws GraphException {
        Node node1 = new Node("N1", "N1");
        Node node2 = new Node("N2", "N2");
        Node node3 = new Node("N3", "N3");
        node2.addSource(new NodeSource("input", "N1"));
        node3.addSource(new NodeSource("input", "N2"));
        Graph graph = new Graph("test-graph");
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = new GraphContext(graph);
        Product[] targetProducts = processor.executeGraph(graphContext, ProgressMonitor.NULL);
        GraphCallSequenceTest.assertNotNull((Object)targetProducts);
        GraphCallSequenceTest.assertEquals((int)1, (int)targetProducts.length);
        GraphCallSequenceTest.assertNotNull((Object)targetProducts[0]);
        GraphCallSequenceTest.assertEquals((String)"N3", (String)targetProducts[0].getName());
        graphContext.dispose();
        String[] expectedRecordStrings = new String[]{"N1:Operator.initialize", "N1:Product.construct", "N2:Operator.initialize", "N2:Product.construct", "N3:Operator.initialize", "N3:Product.construct", "N3:Operator.computeBand", "N2:Operator.computeBand", "N1:Operator.computeBand", "N3:Product.dispose", "N3:Operator.dispose", "N2:Product.dispose", "N2:Operator.dispose", "N1:Product.dispose", "N1:Operator.dispose"};
        GraphCallSequenceTest.assertEquals((int)expectedRecordStrings.length, (int)callRecordList.size());
        for (int i = 0; i < expectedRecordStrings.length; ++i) {
            GraphCallSequenceTest.assertEquals((String)expectedRecordStrings[i], (String)callRecordList.get(i));
        }
    }

    public void testSingleSources3Ouputs() throws GraphException {
        String[] expectedRecords;
        Node node1 = new Node("N1", "N1");
        Node node2 = new Node("N2", "N2");
        Node node3 = new Node("N3", "N3");
        Node node4 = new Node("N4", "N4");
        Node node5 = new Node("N5", "N5");
        node2.addSource(new NodeSource("input", "N1"));
        node3.addSource(new NodeSource("input", "N1"));
        node4.addSource(new NodeSource("input", "N2"));
        node5.addSource(new NodeSource("input", "N2"));
        Graph graph = new Graph("test-graph");
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        graph.addNode(node4);
        graph.addNode(node5);
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = new GraphContext(graph);
        Product[] outputProducts = processor.executeGraph(graphContext, ProgressMonitor.NULL);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts);
        GraphCallSequenceTest.assertEquals((int)3, (int)outputProducts.length);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts[0]);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts[1]);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts[2]);
        GraphCallSequenceTest.assertEquals((String)"N3", (String)outputProducts[0].getName());
        GraphCallSequenceTest.assertEquals((String)"N4", (String)outputProducts[1].getName());
        GraphCallSequenceTest.assertEquals((String)"N5", (String)outputProducts[2].getName());
        graphContext.dispose();
        for (String expectedRecord : expectedRecords = new String[]{"N1:Operator.initialize", "N1:Product.construct", "N3:Operator.initialize", "N3:Product.construct", "N2:Operator.initialize", "N2:Product.construct", "N4:Operator.initialize", "N4:Product.construct", "N5:Operator.initialize", "N5:Product.construct", "N3:Operator.computeBand", "N1:Operator.computeBand", "N4:Operator.computeBand", "N2:Operator.computeBand", "N5:Operator.computeBand", "N5:Operator.dispose", "N5:Product.dispose", "N4:Operator.dispose", "N4:Product.dispose", "N2:Operator.dispose", "N2:Product.dispose", "N3:Operator.dispose", "N3:Product.dispose", "N1:Operator.dispose", "N1:Product.dispose"}) {
            boolean contains = callRecordList.contains(expectedRecord);
            GraphCallSequenceTest.assertTrue((String)("Graph must call " + expectedRecord), (boolean)contains);
        }
    }

    public void test2Sources1Ouput() throws GraphException {
        String[] expectedRecords;
        Node node1 = new Node("N1", "N1");
        Node node2 = new Node("N2", "N2");
        Node node3 = new Node("N3", "N3");
        Node node4 = new Node("N4", "N4");
        Node node6 = new Node("N6", "N6");
        node2.addSource(new NodeSource("input", "N1"));
        node3.addSource(new NodeSource("input", "N1"));
        node4.addSource(new NodeSource("input", "N2"));
        node6.addSource(new NodeSource("input1", "N2"));
        node6.addSource(new NodeSource("input2", "N3"));
        Graph graph = new Graph("test-graph");
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        graph.addNode(node4);
        graph.addNode(node6);
        GraphProcessor processor = new GraphProcessor();
        GraphContext graphContext = new GraphContext(graph);
        Product[] outputProducts = processor.executeGraph(graphContext, ProgressMonitor.NULL);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts);
        GraphCallSequenceTest.assertEquals((int)2, (int)outputProducts.length);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts[0]);
        GraphCallSequenceTest.assertNotNull((Object)outputProducts[1]);
        GraphCallSequenceTest.assertEquals((String)"N4", (String)outputProducts[0].getName());
        GraphCallSequenceTest.assertEquals((String)"N6", (String)outputProducts[1].getName());
        graphContext.dispose();
        for (String expectedRecord : expectedRecords = new String[]{"N1:Operator.initialize", "N1:Product.construct", "N2:Operator.initialize", "N2:Product.construct", "N4:Operator.initialize", "N4:Product.construct", "N3:Operator.initialize", "N3:Product.construct", "N6:Operator.initialize", "N6:Product.construct", "N4:Operator.computeBand", "N2:Operator.computeBand", "N1:Operator.computeBand", "N6:Operator.computeBand", "N3:Operator.computeBand", "N6:Operator.dispose", "N6:Product.dispose", "N3:Operator.dispose", "N3:Product.dispose", "N4:Operator.dispose", "N4:Product.dispose", "N2:Operator.dispose", "N2:Product.dispose", "N1:Operator.dispose", "N1:Product.dispose"}) {
            boolean contains = callRecordList.contains(expectedRecord);
            GraphCallSequenceTest.assertTrue((String)("Graph must call " + expectedRecord), (boolean)contains);
        }
    }

    private static String getOpName(RecordingOp recordingOp) {
        return recordingOp.getSpi().getOperatorAlias();
    }

    private static void recordCall(String product, String method) {
        callRecordList.add(product + ":" + method);
    }

    public static class RecordingProduct
    extends Product {
        public RecordingProduct(RecordingOp op) {
            super(op.getSpi().getOperatorAlias(), ((Object)((Object)op)).getClass().getSimpleName(), 1, 1);
            this.addBand("band_0", 30);
            GraphCallSequenceTest.recordCall(this.getName(), "Product.construct");
        }

        public void dispose() {
            GraphCallSequenceTest.recordCall(this.getName(), "Product.dispose");
            super.dispose();
        }
    }

    public static class N6Spi
    extends NSpi {
        public N6Spi() {
            super(DualSourceOp.class, "N6");
        }
    }

    public static class N5Spi
    extends NSpi {
        public N5Spi() {
            super(SingleSourceOp.class, "N5");
        }
    }

    public static class N4Spi
    extends NSpi {
        public N4Spi() {
            super(SingleSourceOp.class, "N4");
        }
    }

    public static class N3Spi
    extends NSpi {
        public N3Spi() {
            super(SingleSourceOp.class, "N3");
        }
    }

    public static class N2Spi
    extends NSpi {
        public N2Spi() {
            super(SingleSourceOp.class, "N2");
        }
    }

    public static class N1Spi
    extends NSpi {
        public N1Spi() {
            super(NoSourceOp.class, "N1");
        }
    }

    public static abstract class NSpi
    extends OperatorSpi {
        protected NSpi(Class<? extends Operator> operatorClass, String name) {
            super(operatorClass, name);
        }
    }

    public static class DualSourceOp
    extends NoSourceOp {
        @SourceProduct(alias="input1")
        private Product sourceProduct1;
        @SourceProduct(alias="input2")
        private Product sourceProduct2;
        @TargetProduct
        private Product targetProduct;

        @Override
        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.computeBand");
            Tile sourceTile1 = this.getSourceTile((RasterDataNode)this.sourceProduct1.getBandAt(0), targetTile.getRectangle());
            Tile sourceTile2 = this.getSourceTile((RasterDataNode)this.sourceProduct2.getBandAt(0), targetTile.getRectangle());
            float[] source1Elems = (float[])sourceTile1.getRawSamples().getElems();
            float[] source2Elems = (float[])sourceTile2.getRawSamples().getElems();
            ProductData rawSampleData = targetTile.getRawSamples();
            float[] targetElems = (float[])rawSampleData.getElems();
            for (int i = 0; i < targetElems.length; ++i) {
                targetElems[i] = 0.1f * (source1Elems[i] + source2Elems[i]);
            }
            rawSampleData.setElems((Object)targetElems);
            targetTile.setRawSamples(rawSampleData);
        }
    }

    public static class SingleSourceOp
    extends NoSourceOp {
        @SourceProduct(alias="input")
        private Product sourceProduct;
        @TargetProduct
        private Product targetProduct;

        @Override
        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.computeBand");
            Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBandAt(0), targetTile.getRectangle());
            float[] sourceElems = (float[])sourceTile.getRawSamples().getElems();
            ProductData rawSampleData = targetTile.getRawSamples();
            float[] targetElems = (float[])rawSampleData.getElems();
            for (int i = 0; i < targetElems.length; ++i) {
                targetElems[i] = 0.1f * sourceElems[i];
            }
            rawSampleData.setElems((Object)targetElems);
            targetTile.setRawSamples(rawSampleData);
        }
    }

    public static class NoSourceOp
    extends RecordingOp {
        @TargetProduct
        private Product targetProduct;

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.computeBand");
            Rectangle r = targetTile.getRectangle();
            float offset = r.y * this.targetProduct.getSceneRasterWidth() + r.x;
            ProductData rawSampleData = targetTile.getRawSamples();
            float[] targetElems = (float[])rawSampleData.getElems();
            for (int i = 0; i < targetElems.length; ++i) {
                targetElems[i] = offset + (float)i;
            }
            rawSampleData.setElems((Object)targetElems);
            targetTile.setRawSamples(rawSampleData);
        }

        @Override
        public void dispose() {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.dispose");
        }
    }

    public static class RecordingOp
    extends Operator {
        public void initialize() throws OperatorException {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.initialize");
            this.setTargetProduct(new RecordingProduct(this));
        }

        public void dispose() {
            GraphCallSequenceTest.recordCall(GraphCallSequenceTest.getOpName(this), "Operator.dispose");
            super.dispose();
        }
    }
}

