/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.experimental;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.experimental.OperatorExecutor2;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class OperatorExecutor2Test {
    @Test
    public void testWithFrameSizeEqualsTileSize() throws Exception {
        SimpleOp op = new SimpleOp();
        Product s = new Product("S", "S", 10, 10);
        s.setPreferredTileSize(10, 1);
        op.setSourceProduct(s);
        Product t = op.getTargetProduct();
        Assert.assertEquals((Object)s.getPreferredTileSize(), (Object)t.getPreferredTileSize());
        Assert.assertEquals((long)9L, (long)t.getNumBands());
        OperatorExecutor2 ex = new OperatorExecutor2(t);
        Assert.assertEquals((Object)t.getPreferredTileSize(), (Object)ex.getFrameSize());
        TracingHandler handler = new TracingHandler();
        Object metrics = ex.execute((OperatorExecutor2.Handler)handler);
        Assert.assertEquals((Object)"#bands=9, x=0, y=0, w=10, h=2\n#bands=9, x=0, y=2, w=10, h=2\n#bands=9, x=0, y=4, w=10, h=2\n#bands=9, x=0, y=6, w=10, h=2\n#bands=9, x=0, y=8, w=10, h=2\n", (Object)handler.trace.toString());
        Assert.assertNotNull((Object)metrics);
    }

    @Test
    public void testWithCustomFrameSize() throws Exception {
        SimpleOp op = new SimpleOp();
        Product s = new Product("S", "S", 10, 10);
        op.setSourceProduct(s);
        Product t = op.getTargetProduct();
        Assert.assertEquals((long)9L, (long)t.getNumBands());
        OperatorExecutor2 ex = new OperatorExecutor2(t);
        ex.setFrameSize(2, 10);
        Assert.assertEquals((Object)new Dimension(2, 10), (Object)ex.getFrameSize());
        TracingHandler handler = new TracingHandler();
        Object metrics = ex.execute((OperatorExecutor2.Handler)handler);
        Assert.assertEquals((Object)"#bands=9, x=0, y=0, w=2, h=10\n#bands=9, x=2, y=0, w=2, h=10\n#bands=9, x=4, y=0, w=2, h=10\n#bands=9, x=6, y=0, w=2, h=10\n#bands=9, x=8, y=0, w=2, h=10\n", (Object)handler.trace.toString());
        Assert.assertNotNull((Object)metrics);
    }

    @Test
    public void testWithCustomFrameSizeNotFittingSceneSize() throws Exception {
        SimpleOp op = new SimpleOp();
        Product s = new Product("S", "S", 10, 10);
        op.setSourceProduct(s);
        Product t = op.getTargetProduct();
        Assert.assertEquals((long)9L, (long)t.getNumBands());
        OperatorExecutor2 ex = new OperatorExecutor2(t);
        ex.setFrameSize(7, 3);
        Assert.assertEquals((Object)new Dimension(7, 3), (Object)ex.getFrameSize());
        TracingHandler handler = new TracingHandler();
        Object metrics = ex.execute((OperatorExecutor2.Handler)handler);
        Assert.assertEquals((Object)"#bands=9, x=0, y=0, w=7, h=3\n#bands=9, x=7, y=0, w=3, h=3\n#bands=9, x=0, y=3, w=7, h=3\n#bands=9, x=7, y=3, w=3, h=3\n#bands=9, x=0, y=6, w=7, h=3\n#bands=9, x=7, y=6, w=3, h=3\n#bands=9, x=0, y=9, w=7, h=1\n#bands=9, x=7, y=9, w=3, h=1\n", (Object)handler.trace.toString());
        Assert.assertNotNull((Object)metrics);
    }

    @Test
    public void testData() throws Exception {
        SimpleOp op = new SimpleOp();
        Product s = new Product("S", "S", 10, 10);
        s.setPreferredTileSize(10, 2);
        op.setSourceProduct(s);
        Product t = op.getTargetProduct();
        OperatorExecutor2 ex = new OperatorExecutor2(t);
        TracingHandler2 handler = new TracingHandler2();
        Object metrics = ex.execute((OperatorExecutor2.Handler)handler);
        Assert.assertEquals((long)5L, (long)handler.trace.size());
        OperatorExecutor2.Frame frame0 = handler.trace.get(0);
        Assert.assertNotNull((Object)frame0.getData(0));
        Assert.assertEquals((float)0.1f, (float)frame0.getData(0).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)0.3f, (float)frame0.getData(3).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)-0.20000002f, (float)frame0.getData(6).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)0.1f, (float)frame0.getData(0).getElemFloatAt(7), (float)0.0f);
        Assert.assertEquals((float)0.3f, (float)frame0.getData(3).getElemFloatAt(7), (float)0.0f);
        Assert.assertEquals((float)-0.20000002f, (float)frame0.getData(6).getElemFloatAt(7), (float)0.0f);
        OperatorExecutor2.Frame frame3 = handler.trace.get(3);
        Assert.assertEquals((float)0.1f, (float)frame3.getData(0).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)0.3f, (float)frame3.getData(3).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)-0.20000002f, (float)frame3.getData(6).getElemFloatAt(0), (float)0.0f);
        Assert.assertEquals((float)0.1f, (float)frame3.getData(0).getElemFloatAt(7), (float)0.0f);
        Assert.assertEquals((float)0.3f, (float)frame3.getData(3).getElemFloatAt(7), (float)0.0f);
        Assert.assertEquals((float)-0.20000002f, (float)frame3.getData(6).getElemFloatAt(7), (float)0.0f);
        Assert.assertNotNull((Object)metrics);
    }

    public static class SimpleOp
    extends PixelOperator {
        protected void configureTargetProduct(ProductConfigurer productConfigurer) {
            super.configureTargetProduct(productConfigurer);
            int w = productConfigurer.getTargetProduct().getSceneRasterWidth();
            int h = productConfigurer.getTargetProduct().getSceneRasterHeight();
            productConfigurer.addBand("a", 30);
            productConfigurer.addBand("b", 30);
            productConfigurer.addBand("c", 30);
            productConfigurer.addBand("x", 30).setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(1.0f * (float)w), (Float)Float.valueOf(1.0f * (float)h), (Number[])new Float[]{Float.valueOf(0.3f)}, null));
            productConfigurer.addBand("y", 30).setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(1.0f * (float)w), (Float)Float.valueOf(1.0f * (float)h), (Number[])new Float[]{Float.valueOf(0.6f)}, null));
            productConfigurer.addBand("z", 30).setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(1.0f * (float)w), (Float)Float.valueOf(1.0f * (float)h), (Number[])new Float[]{Float.valueOf(0.9f)}, null));
            productConfigurer.addBand("u", "a-x");
            productConfigurer.addBand("v", "b-y");
            productConfigurer.addBand("w", "c-z");
        }

        protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) {
        }

        protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) {
            sampleConfigurer.defineSample(0, "a");
            sampleConfigurer.defineSample(1, "b");
            sampleConfigurer.defineSample(2, "c");
        }

        protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
            int n = 10000000;
            float u = 0.0f;
            float v = 0.0f;
            float w = 0.0f;
            for (int i = 0; i < 10000000; ++i) {
                for (int j = 0; j < 10000000; ++j) {
                    for (int k = 0; k < 10000000; ++k) {
                        u = 0.1f * (float)i;
                        v = 0.2f * (float)j;
                        w = 0.4f * (float)k;
                        u /= (float)i;
                        v /= (float)j;
                        w /= (float)k;
                    }
                }
            }
            targetSamples[0].set(u);
            targetSamples[1].set(v);
            targetSamples[2].set(w);
        }
    }

    private static class TracingHandler2
    implements OperatorExecutor2.Handler {
        ArrayList<OperatorExecutor2.Frame> trace = new ArrayList();

        private TracingHandler2() {
        }

        public void frameComputed(OperatorExecutor2.Frame frame) {
            Assert.assertFalse((boolean)this.trace.contains(frame));
            this.trace.add(frame);
        }
    }

    private static class TracingHandler
    implements OperatorExecutor2.Handler {
        StringBuilder trace = new StringBuilder();

        private TracingHandler() {
        }

        public void frameComputed(OperatorExecutor2.Frame frame) {
            this.trace.append(String.format("#bands=%d, x=%d, y=%d, w=%d, h=%d\n", frame.getNumBands(), frame.getRegion().x, frame.getRegion().y, frame.getRegion().width, frame.getRegion().height));
        }
    }
}

