/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.resample.ResamplingOp;
import org.esa.snap.core.gpf.common.resample.ResamplingOp_Old;
import org.esa.snap.core.transform.MathTransform2D;
import org.junit.Assert;
import org.junit.Test;

public class ResamplingOpTest {
    @Test
    public void testAllNodesHaveIdentitySceneTransform() {
        Product product = new Product("name", "tapce", 2, 2);
        product.addBand("band_1", "X + Y");
        Band band2 = product.addBand("band_2", "X + 1 + Y");
        Assert.assertTrue((boolean)ResamplingOp_Old.allNodesHaveIdentitySceneTransform((Product)product));
        band2.setModelToSceneTransform(MathTransform2D.NULL);
        junit.framework.Assert.assertFalse((boolean)ResamplingOp_Old.allNodesHaveIdentitySceneTransform((Product)product));
    }

    @Test
    public void testOnlyReferenceBandIsSet() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)new ResamplingOp.Spi());
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("referenceBandName", "dummy");
        parameterMap.put("targetWidth", 3);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If referenceBandName is set, targetWidth, targetHeight, and targetResolution must not be set", (String)oe.getMessage());
        }
        parameterMap.remove("targetWidth");
        parameterMap.put("targetHeight", 3);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If referenceBandName is set, targetWidth, targetHeight, and targetResolution must not be set", (String)oe.getMessage());
        }
        parameterMap.remove("targetHeight");
        parameterMap.put("targetResolution", 20);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If referenceBandName is set, targetWidth, targetHeight, and targetResolution must not be set", (String)oe.getMessage());
        }
    }

    @Test
    public void testOnlyTargetWidthAndHeightAreSet() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)new ResamplingOp.Spi());
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("targetWidth", 3);
        parameterMap.put("targetHeight", 3);
        parameterMap.put("referenceBandName", "dummy");
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If referenceBandName is set, targetWidth, targetHeight, and targetResolution must not be set", (String)oe.getMessage());
        }
        parameterMap.remove("referenceBandName");
        parameterMap.put("targetResolution", 20);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If targetResolution is set, targetWidth, targetHeight, and referenceBandName must not be set", (String)oe.getMessage());
        }
    }

    @Test
    public void testBothTargetWidthAndHeightAreSet() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)new ResamplingOp.Spi());
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        HashMap<String, Integer> parameterMap = new HashMap<String, Integer>();
        parameterMap.put("targetWidth", 3);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If targetWidth is set, targetHeight must be set, too.", (String)oe.getMessage());
        }
        parameterMap.remove("targetWidth");
        parameterMap.put("targetHeight", 3);
        try {
            GPF.createProduct((String)"Resample", parameterMap, (Product)product);
            junit.framework.Assert.fail((String)"Exception expected");
        }
        catch (OperatorException oe) {
            junit.framework.Assert.assertEquals((String)"If targetHeight is set, targetWidth must be set, too.", (String)oe.getMessage());
        }
    }
}

