/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.ResamplingOp_Old;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.transform.MathTransform2D;
import org.junit.Assert;
import org.junit.Test;

public class ResamplingOpOldTest {
    @Test
    public void testAllNodesHaveIdentitySceneTransform() {
        Product product = new Product("name", "tapce", 2, 2);
        product.addBand("band_1", "X + Y");
        Band band2 = product.addBand("band_2", "X + 1 + Y");
        Assert.assertTrue((boolean)ResamplingOp_Old.allNodesHaveIdentitySceneTransform((Product)product));
        band2.setModelToSceneTransform(MathTransform2D.NULL);
        junit.framework.Assert.assertFalse((boolean)ResamplingOp_Old.allNodesHaveIdentitySceneTransform((Product)product));
    }

    @Test
    public void testAllScalingsAreIntDivisible() {
        Product product = new Product("name", "tapce", 2, 2);
        product.addBand("band_1", "X + Y");
        product.addBand("band_2", "X + 1 + Y");
        Assert.assertTrue((boolean)ResamplingOp_Old.allScalingsAreIntDivisible((Product)product));
        VirtualBandOpImage image = VirtualBandOpImage.builder((String)"X + Y", (Product)product).create();
        AffineTransform nonIntScalableTransform = new AffineTransform(1.5, 0.0, 0.0, 1.5, 0.0, 0.0);
        DefaultMultiLevelModel nonIntScalbleModel = new DefaultMultiLevelModel(nonIntScalableTransform, 3, 3);
        DefaultMultiLevelSource nonInScalableSource = new DefaultMultiLevelSource((RenderedImage)image, (MultiLevelModel)nonIntScalbleModel);
        DefaultMultiLevelImage nonIntScalableImage = new DefaultMultiLevelImage((MultiLevelSource)nonInScalableSource);
        Band band_3 = new Band("band_3", 30, 3, 3);
        band_3.setSourceImage((MultiLevelImage)nonIntScalableImage);
        product.addBand(band_3);
        junit.framework.Assert.assertFalse((boolean)ResamplingOp_Old.allScalingsAreIntDivisible((Product)product));
    }

    @Test
    public void testAllBandsMustBeEitherInterpolatedAggregatedOrLeftAsIs() {
        Product product = new Product("name", "tapce", 2, 2);
        Band band_1 = product.addBand("band_1", "X + Y");
        product.addBand("band_2", "X + 1 + Y");
        Assert.assertTrue((boolean)ResamplingOp_Old.allBandsMustBeEitherInterpolatedAggregatedOrLeftAsIs((Product)product, (RasterDataNode)band_1));
        product.addBand(new Band("band_3", 10, 1, 3));
        junit.framework.Assert.assertFalse((boolean)ResamplingOp_Old.allBandsMustBeEitherInterpolatedAggregatedOrLeftAsIs((Product)product, (RasterDataNode)band_1));
    }
}

