/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.Resample;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ResampleTest_Interpolate {
    private Interpolation interpolation;

    @Before
    public void setUp() {
        this.interpolation = Interpolation.getInstance((int)0);
    }

    @Test
    public void testCreateScaledImage_AffineProvidedForSource_OnlyScale() throws Exception {
        int sourceWidth = 2;
        int sourceHeight = 2;
        int referenceWidth = 4;
        int referenceHeight = 4;
        int sourceScaleX = 2;
        int sourceScaleY = 2;
        boolean sourceTranslateX = false;
        boolean sourceTranslateY = false;
        int levelCount = 2;
        AffineTransform imageToModelTransform = new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, (float)sourceTranslateX, (float)sourceTranslateY);
        Band sourceBand = this.createSourceBand(imageToModelTransform, sourceWidth, sourceHeight);
        Band referenceBand = this.createReferenceBand(referenceWidth, referenceHeight, levelCount, new AffineTransform());
        MultiLevelImage scaledMultiLevelImage = Resample.createInterpolatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Interpolation)this.interpolation);
        TestCase.assertNotNull((Object)scaledMultiLevelImage);
        Assert.assertEquals((int)levelCount, (int)scaledMultiLevelImage.getModel().getLevelCount());
        for (int i = 0; i < levelCount; ++i) {
            RenderedImage image = scaledMultiLevelImage.getImage(i);
            int expectedWidth = referenceWidth / (i + 1);
            int expectedHeight = referenceHeight / (i + 1);
            Assert.assertEquals((int)expectedWidth, (int)image.getWidth());
            Assert.assertEquals((int)expectedHeight, (int)image.getHeight());
            Raster targetData = image.getData();
            Raster sourceData = sourceBand.getSourceImage().getData();
            for (int x = 0; x < expectedWidth; ++x) {
                for (int y = 0; y < expectedHeight; ++y) {
                    Assert.assertEquals((double)sourceData.getSampleDouble(x / (2 - i), y / (2 - i), 0), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                }
            }
        }
    }

    @Test
    public void testCreateScaledImage_AffineProvidedForSource_ScaleAndTransform() throws Exception {
        int sourceWidth = 2;
        int sourceHeight = 2;
        int referenceWidth = 8;
        int referenceHeight = 8;
        int scaleX = 2;
        int scaleY = 2;
        int translateX = 2;
        int translateY = 2;
        int levelCount = 2;
        AffineTransform imageToModelTransform = new AffineTransform(scaleX, 0.0f, 0.0f, scaleY, translateX, translateY);
        Band sourceBand = this.createSourceBand(imageToModelTransform, sourceWidth, sourceHeight);
        Band referenceBand = this.createReferenceBand(referenceWidth, referenceHeight, levelCount, new AffineTransform());
        MultiLevelImage scaledMultiLevelImage = Resample.createInterpolatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Interpolation)this.interpolation);
        TestCase.assertNotNull((Object)scaledMultiLevelImage);
        Assert.assertEquals((int)levelCount, (int)scaledMultiLevelImage.getModel().getLevelCount());
        for (int i = 0; i < levelCount; ++i) {
            RenderedImage image = scaledMultiLevelImage.getImage(i);
            int expectedWidth = referenceWidth / (i + 1);
            int expectedHeight = referenceHeight / (i + 1);
            Assert.assertEquals((int)expectedWidth, (int)image.getWidth());
            Assert.assertEquals((int)expectedHeight, (int)image.getHeight());
            Raster targetData = image.getData();
            Raster sourceData = sourceBand.getSourceImage().getData();
            for (int x = 0; x < expectedWidth; ++x) {
                for (int y = 0; y < expectedHeight; ++y) {
                    if (x < 2 - i || x >= expectedWidth - (2 - i) || y < 2 - i || y >= expectedHeight - (2 - i)) {
                        Assert.assertEquals((double)sourceBand.getNoDataValue(), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                        continue;
                    }
                    Assert.assertEquals((double)sourceData.getSampleDouble((x - (2 - i)) / (2 - i), (y - (2 - i)) / (2 - i), 0), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                }
            }
        }
    }

    @Test
    public void testCreateScaledImage_AffineProvidedForSourceAndReference_OnlyScale() throws Exception {
        int sourceWidth = 4;
        int sourceHeight = 4;
        int referenceWidth = 2;
        int referenceHeight = 2;
        int sourceScaleX = 4;
        int sourceScaleY = 4;
        boolean sourceTranslateX = false;
        boolean sourceTranslateY = false;
        int referenceScaleX = 2;
        int referenceScaleY = 2;
        boolean referenceTranslateX = false;
        boolean referenceTranslateY = false;
        int levelCount = 2;
        AffineTransform sourceImageToModelTransform = new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, (float)sourceTranslateX, (float)sourceTranslateY);
        Band sourceBand = this.createSourceBand(sourceImageToModelTransform, sourceWidth, sourceHeight);
        AffineTransform referenceImageToModelTransform = new AffineTransform(referenceScaleX, 0.0f, 0.0f, referenceScaleY, (float)referenceTranslateX, (float)referenceTranslateY);
        Band referenceBand = this.createReferenceBand(referenceWidth, referenceHeight, levelCount, referenceImageToModelTransform);
        MultiLevelImage scaledMultiLevelImage = Resample.createInterpolatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Interpolation)this.interpolation);
        TestCase.assertNotNull((Object)scaledMultiLevelImage);
        Assert.assertEquals((int)levelCount, (int)scaledMultiLevelImage.getModel().getLevelCount());
        for (int i = 0; i < levelCount; ++i) {
            RenderedImage image = scaledMultiLevelImage.getImage(i);
            int expectedWidth = referenceWidth / (i + 1);
            int expectedHeight = referenceHeight / (i + 1);
            Assert.assertEquals((int)expectedWidth, (int)image.getWidth());
            Assert.assertEquals((int)expectedHeight, (int)image.getHeight());
            Raster targetData = image.getData();
            Raster sourceData = sourceBand.getSourceImage().getData();
            for (int x = 0; x < expectedWidth; ++x) {
                for (int y = 0; y < expectedHeight; ++y) {
                    Assert.assertEquals((double)sourceData.getSampleDouble(x / (2 - i), y / (2 - i), 0), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                }
            }
        }
    }

    @Test
    @Ignore
    public void testCreateScaledImage_AffineProvidedForSourceAndReference_ScaleAndTransform() throws Exception {
        int sourceWidth = 2;
        int sourceHeight = 2;
        int sourceScaleX = 3;
        int sourceScaleY = 3;
        boolean sourceTranslateX = true;
        boolean sourceTranslateY = true;
        int referenceWidth = 3;
        int referenceHeight = 3;
        int referenceScaleX = 2;
        int referenceScaleY = 2;
        boolean referenceTranslateX = true;
        boolean referenceTranslateY = true;
        int referenceLevelCount = 1;
        AffineTransform sourceImageToModelTransform = new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, (float)sourceTranslateX, (float)sourceTranslateY);
        Band sourceBand = this.createSourceBand(sourceImageToModelTransform, sourceWidth, sourceHeight);
        AffineTransform referenceImageToModelTransform = new AffineTransform(referenceScaleX, 0.0f, 0.0f, referenceScaleY, (float)referenceTranslateX, (float)referenceTranslateY);
        Band referenceBand = this.createReferenceBand(referenceWidth, referenceHeight, referenceLevelCount, referenceImageToModelTransform);
        MultiLevelImage scaledMultiLevelImage = Resample.createInterpolatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Interpolation)this.interpolation);
        TestCase.assertNotNull((Object)scaledMultiLevelImage);
        Assert.assertEquals((int)referenceLevelCount, (int)scaledMultiLevelImage.getModel().getLevelCount());
        for (int i = 0; i < referenceLevelCount; ++i) {
            RenderedImage image = scaledMultiLevelImage.getImage(i);
            int expectedWidth = referenceWidth / (i + 1);
            int expectedHeight = referenceHeight / (i + 1);
            Assert.assertEquals((int)expectedWidth, (int)image.getWidth());
            Assert.assertEquals((int)expectedHeight, (int)image.getHeight());
            Raster targetData = image.getData();
            Raster sourceData = sourceBand.getSourceImage().getData();
            for (int x = 0; x < expectedWidth; ++x) {
                for (int y = 0; y < expectedHeight; ++y) {
                    if (x < 0 || x >= expectedWidth - 1 - i || y < 0 || y >= expectedHeight - 1 - i) {
                        Assert.assertEquals((double)sourceBand.getNoDataValue(), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                        continue;
                    }
                    Assert.assertEquals((double)sourceData.getSampleDouble(x * (3 - i) / (2 - i), y * (3 - i) / (2 - i), 0), (double)targetData.getSampleDouble(x, y, 0), (double)1.0E-8);
                }
            }
        }
    }

    private Band createSourceBand(AffineTransform transform, int width, int height) {
        Product sourceProduct = new Product("dummy", "dummy", width, height);
        Band sourceBand = sourceProduct.addBand("sourceBand", "cos(X) + sin(Y)");
        sourceBand.setNoDataValue(-23.0);
        sourceBand.setImageToModelTransform(transform);
        return sourceBand;
    }

    private Band createReferenceBand(final int width, final int height, int levelcount, AffineTransform imageToModelTransform) {
        Band referenceBand = new Band("referenceBand", 10, width, height);
        DefaultMultiLevelModel referenceModel = new DefaultMultiLevelModel(levelcount, imageToModelTransform, width, height);
        referenceBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource((MultiLevelModel)referenceModel){

            protected RenderedImage createImage(int level) {
                return new BufferedImage(width / (1 + level), height / (1 + level), 10);
            }
        }));
        return referenceBand;
    }
}

