/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.jai.GeneralFilterFunction;
import com.bc.ceres.jai.operator.GeneralFilterDescriptor;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import org.esa.snap.core.gpf.common.resample.Resample;
import org.junit.Assert;
import org.junit.Test;

public class ResampleTest_FlagFilterFunctions {
    @Test
    public void testFlagMinFilterFunction() {
        short[] sourceData = new short[]{0, 1, 2, 3, 3, 9, 5, 1, 2, 3, 9, 9, 6, 3, 2, 7, 7, 5, 7, 1, 6, 7, 5, 9, 5};
        short[] expectedData = new short[]{0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 4, 1, 1, 1};
        BufferedImage image = ResampleTest_FlagFilterFunctions.createOneBandedUShortImage(5, 5, sourceData);
        Resample.FlagMinFunction function = new Resample.FlagMinFunction(3, 3, 1, 1, null);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp formattedOp = FormatDescriptor.create((RenderedImage)image, (Integer)5, (RenderingHints)hints);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)formattedOp, (GeneralFilterFunction)function, (RenderingHints)hints);
        op = FormatDescriptor.create((RenderedImage)op, (Integer)1, null);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagMaxFilterFunction() {
        short[] sourceData = new short[]{0, 1, 2, 3, 3, 9, 5, 1, 2, 3, 9, 9, 6, 3, 2, 7, 7, 5, 7, 1, 6, 7, 5, 9, 5};
        short[] expectedData = new short[]{13, 15, 7, 3, 3, 13, 15, 15, 7, 3, 15, 15, 15, 7, 7, 15, 15, 15, 15, 15, 7, 7, 15, 15, 15};
        BufferedImage image = ResampleTest_FlagFilterFunctions.createOneBandedUShortImage(5, 5, sourceData);
        Resample.FlagMaxFunction function = new Resample.FlagMaxFunction(3, 3, 1, 1, null);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp formattedOp = FormatDescriptor.create((RenderedImage)image, (Integer)5, (RenderingHints)hints);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)formattedOp, (GeneralFilterFunction)function, (RenderingHints)hints);
        op = FormatDescriptor.create((RenderedImage)op, (Integer)1, null);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagMedianMinFilterFunction() {
        short[] sourceData = new short[]{0, 1, 2, 3, 3, 9, 5, 1, 2, 3, 9, 9, 6, 3, 2, 7, 7, 5, 7, 1, 6, 7, 5, 9, 5};
        short[] expectedData = new short[]{1, 1, 1, 3, 3, 1, 1, 3, 3, 3, 1, 5, 7, 3, 3, 7, 7, 7, 5, 1, 7, 7, 5, 5, 1};
        BufferedImage image = ResampleTest_FlagFilterFunctions.createOneBandedUShortImage(5, 5, sourceData);
        Resample.FlagMedianMinFunction function = new Resample.FlagMedianMinFunction(3, 3, 1, 1, null);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp formattedOp = FormatDescriptor.create((RenderedImage)image, (Integer)5, (RenderingHints)hints);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)formattedOp, (GeneralFilterFunction)function, (RenderingHints)hints);
        op = FormatDescriptor.create((RenderedImage)op, (Integer)1, null);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testFlagMedianMaxFilterFunction() {
        short[] sourceData = new short[]{0, 1, 2, 3, 3, 9, 5, 1, 2, 3, 9, 9, 6, 3, 2, 7, 7, 5, 7, 1, 6, 7, 5, 9, 5};
        short[] expectedData = new short[]{1, 1, 3, 3, 3, 9, 1, 3, 3, 3, 13, 5, 7, 3, 3, 7, 7, 7, 5, 3, 7, 7, 7, 5, 5};
        BufferedImage image = ResampleTest_FlagFilterFunctions.createOneBandedUShortImage(5, 5, sourceData);
        Resample.FlagMedianMaxFunction function = new Resample.FlagMedianMaxFunction(3, 3, 1, 1, null);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp formattedOp = FormatDescriptor.create((RenderedImage)image, (Integer)5, (RenderingHints)hints);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)formattedOp, (GeneralFilterFunction)function, (RenderingHints)hints);
        op = FormatDescriptor.create((RenderedImage)op, (Integer)1, null);
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    static BufferedImage createOneBandedUShortImage(int w, int h, short[] data) {
        BufferedImage image = new BufferedImage(w, h, 11);
        DataBufferUShort buffer = (DataBufferUShort)image.getRaster().getDataBuffer();
        System.arraycopy(data, 0, buffer.getData(), 0, w * h);
        return image;
    }
}

