/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.Resample;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ResampleTest_Aggregate {
    @Test
    public void testCreateAggregatedMultiLevelImage_First() throws Exception {
        Band sourceBand = this.createSourceBand();
        Band referenceBand = this.createReferenceBand();
        MultiLevelImage aggregatedMultiLevelImage = Resample.createAggregatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Resample.Type)Resample.Type.FIRST, (Resample.Type)Resample.Type.MEDIAN);
        TestCase.assertNotNull((Object)aggregatedMultiLevelImage);
        Assert.assertEquals((int)2, (int)aggregatedMultiLevelImage.getModel().getLevelCount());
        RenderedImage image0 = aggregatedMultiLevelImage.getImage(0);
        Assert.assertEquals((int)2, (int)image0.getWidth());
        Assert.assertEquals((int)2, (int)image0.getHeight());
        Raster imageData0 = image0.getData();
        Assert.assertEquals((double)5.0, (double)imageData0.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)7.0, (double)imageData0.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)13.0, (double)imageData0.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData0.getSampleDouble(1, 1, 0), (double)1.0E-8);
        RenderedImage image1 = aggregatedMultiLevelImage.getImage(1);
        Assert.assertEquals((int)1, (int)image1.getWidth());
        Assert.assertEquals((int)1, (int)image1.getHeight());
        Raster imageData1 = image1.getData();
        Assert.assertEquals((double)5.0, (double)imageData1.getSampleDouble(0, 0, 0), (double)1.0E-8);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Min() throws Exception {
        Band sourceBand = this.createSourceBand();
        Band referenceBand = this.createReferenceBand();
        MultiLevelImage aggregatedMultiLevelImage = Resample.createAggregatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Resample.Type)Resample.Type.MIN, (Resample.Type)Resample.Type.MEDIAN);
        TestCase.assertNotNull((Object)aggregatedMultiLevelImage);
        Assert.assertEquals((int)2, (int)aggregatedMultiLevelImage.getModel().getLevelCount());
        RenderedImage image0 = aggregatedMultiLevelImage.getImage(0);
        Assert.assertEquals((int)2, (int)image0.getWidth());
        Assert.assertEquals((int)2, (int)image0.getHeight());
        Raster imageData0 = image0.getData();
        Assert.assertEquals((double)5.0, (double)imageData0.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)7.0, (double)imageData0.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)13.0, (double)imageData0.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData0.getSampleDouble(1, 1, 0), (double)1.0E-8);
        RenderedImage image1 = aggregatedMultiLevelImage.getImage(1);
        Assert.assertEquals((int)1, (int)image1.getWidth());
        Assert.assertEquals((int)1, (int)image1.getHeight());
        Raster imageData1 = image1.getData();
        Assert.assertEquals((double)5.0, (double)imageData1.getSampleDouble(0, 0, 0), (double)1.0E-8);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Max() throws Exception {
        Band sourceBand = this.createSourceBand();
        Band referenceBand = this.createReferenceBand();
        MultiLevelImage aggregatedMultiLevelImage = Resample.createAggregatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Resample.Type)Resample.Type.MAX, (Resample.Type)Resample.Type.MEDIAN);
        TestCase.assertNotNull((Object)aggregatedMultiLevelImage);
        Assert.assertEquals((int)2, (int)aggregatedMultiLevelImage.getModel().getLevelCount());
        RenderedImage image0 = aggregatedMultiLevelImage.getImage(0);
        Assert.assertEquals((int)2, (int)image0.getWidth());
        Assert.assertEquals((int)2, (int)image0.getHeight());
        Raster imageData0 = image0.getData();
        Assert.assertEquals((double)10.0, (double)imageData0.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)11.0, (double)imageData0.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)14.0, (double)imageData0.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData0.getSampleDouble(1, 1, 0), (double)1.0E-8);
        RenderedImage image1 = aggregatedMultiLevelImage.getImage(1);
        Assert.assertEquals((int)1, (int)image1.getWidth());
        Assert.assertEquals((int)1, (int)image1.getHeight());
        Raster imageData1 = image1.getData();
        Assert.assertEquals((double)10.0, (double)imageData1.getSampleDouble(0, 0, 0), (double)1.0E-8);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Median() throws Exception {
        Band sourceBand = this.createSourceBand_Median();
        Band referenceBand = this.createReferenceBand();
        MultiLevelImage aggregatedMultiLevelImage = Resample.createAggregatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Resample.Type)Resample.Type.MEDIAN, (Resample.Type)Resample.Type.MEDIAN);
        TestCase.assertNotNull((Object)aggregatedMultiLevelImage);
        Assert.assertEquals((int)2, (int)aggregatedMultiLevelImage.getModel().getLevelCount());
        RenderedImage image0 = aggregatedMultiLevelImage.getImage(0);
        Assert.assertEquals((int)2, (int)image0.getWidth());
        Assert.assertEquals((int)2, (int)image0.getHeight());
        Raster imageData0 = image0.getData();
        Assert.assertEquals((double)4.0, (double)imageData0.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.5, (double)imageData0.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.5, (double)imageData0.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)7.0, (double)imageData0.getSampleDouble(1, 1, 0), (double)1.0E-8);
        RenderedImage image1 = aggregatedMultiLevelImage.getImage(1);
        Assert.assertEquals((int)1, (int)image1.getWidth());
        Assert.assertEquals((int)1, (int)image1.getHeight());
        Raster imageData1 = image1.getData();
        Assert.assertEquals((double)4.0, (double)imageData1.getSampleDouble(0, 0, 0), (double)1.0E-8);
    }

    @Test
    public void testCreateAggregatedMultiLevelImage_Mean() throws Exception {
        Band sourceBand = this.createSourceBand();
        Band referenceBand = this.createReferenceBand();
        MultiLevelImage aggregatedMultiLevelImage = Resample.createAggregatedMultiLevelImage((Band)sourceBand, (RasterDataNode)referenceBand, (Resample.Type)Resample.Type.MEAN, (Resample.Type)Resample.Type.MEDIAN);
        TestCase.assertNotNull((Object)aggregatedMultiLevelImage);
        Assert.assertEquals((int)2, (int)aggregatedMultiLevelImage.getModel().getLevelCount());
        RenderedImage image0 = aggregatedMultiLevelImage.getImage(0);
        Assert.assertEquals((int)2, (int)image0.getWidth());
        Assert.assertEquals((int)2, (int)image0.getHeight());
        Raster imageData0 = image0.getData();
        Assert.assertEquals((double)7.5, (double)imageData0.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)9.0, (double)imageData0.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)13.5, (double)imageData0.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.0, (double)imageData0.getSampleDouble(1, 1, 0), (double)1.0E-8);
        RenderedImage image1 = aggregatedMultiLevelImage.getImage(1);
        Assert.assertEquals((int)1, (int)image1.getWidth());
        Assert.assertEquals((int)1, (int)image1.getHeight());
        Raster imageData1 = image1.getData();
        Assert.assertEquals((double)7.5, (double)imageData1.getSampleDouble(0, 0, 0), (double)1.0E-8);
    }

    private Band createSourceBand_Median() {
        int sourceWidth = 4;
        int sourceHeight = 4;
        int sourceScaleX = 2;
        int sourceScaleY = 2;
        int sourceTranslateX = 2;
        int sourceTranslateY = 2;
        Product sourceProduct = new Product("dummy", "dummy", sourceWidth, sourceHeight);
        Band sourceBand = sourceProduct.addBand("sourceBand", "X + Y");
        sourceBand.setNoDataValue(-23.0);
        sourceBand.setImageToModelTransform(new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, sourceTranslateX, sourceTranslateY));
        return sourceBand;
    }

    private Band createSourceBand() {
        int sourceWidth = 4;
        int sourceHeight = 4;
        int sourceScaleX = 2;
        int sourceScaleY = 2;
        int sourceTranslateX = 2;
        int sourceTranslateY = 2;
        Product sourceProduct = new Product("dummy", "dummy", sourceWidth, sourceHeight);
        Band sourceBand = sourceProduct.addBand("sourceBand", "((X - 0.5) * " + sourceWidth + ") + (Y - 0.5)");
        sourceBand.setNoDataValue(-23.0);
        sourceBand.setImageToModelTransform(new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, sourceTranslateX, sourceTranslateY));
        return sourceBand;
    }

    private Band createReferenceBand() {
        final int referenceWidth = 2;
        final int referenceHeight = 2;
        int referenceScaleX = 4;
        int referenceScaleY = 4;
        int referenceTranslateX = 4;
        int referenceTranslateY = 4;
        int referenceLevelCount = 2;
        AffineTransform imageToModelTransform = new AffineTransform(referenceScaleX, 0.0f, 0.0f, referenceScaleY, referenceTranslateX, referenceTranslateY);
        Band referenceBand = new Band("referenceBand", 10, referenceWidth, referenceHeight);
        DefaultMultiLevelModel referenceModel = new DefaultMultiLevelModel(referenceLevelCount, imageToModelTransform, referenceWidth, referenceHeight);
        referenceBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource((MultiLevelModel)referenceModel){

            protected RenderedImage createImage(int level) {
                return new BufferedImage(referenceWidth / (1 + level), referenceHeight / (1 + level), 10);
            }
        }));
        return referenceBand;
    }
}

