/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.InterpolatedOpImage;
import org.esa.snap.core.gpf.common.resample.InterpolationType;
import org.esa.snap.core.image.ImageManager;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class InterpolatedOpImageTest {
    private Band referenceBand;

    @Before
    public void setUp() {
        final int referenceWidth = 3;
        final int referenceHeight = 3;
        this.referenceBand = new Band("referenceBand", 10, 3, 3);
        AffineTransform imageToModelTransform = new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f);
        DefaultMultiLevelModel referenceModel = new DefaultMultiLevelModel(imageToModelTransform, 3, 3);
        this.referenceBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource((MultiLevelModel)referenceModel){

            protected RenderedImage createImage(int level) {
                return new BufferedImage(referenceWidth / (1 + level), referenceHeight / (1 + level), 10);
            }
        }));
        Product product = new Product("product", "type", 9, 9);
        product.addBand(this.referenceBand);
    }

    @Test
    public void testInterpolate_Double_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(31);
    }

    @Test
    public void testInterpolate_Float_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(30);
    }

    @Test
    public void testInterpolate_Byte_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(10);
    }

    @Test
    public void testInterpolate_Short_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(11);
    }

    @Test
    public void testInterpolate_UShort_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(21);
    }

    @Test
    public void testInterpolate_Int_NearestNeighbour() throws NoninvertibleTransformException {
        this.testNearestNeighbour(12);
    }

    @Test
    public void testInterpolate_Double_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(31);
    }

    @Test
    public void testInterpolate_Float_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(30);
    }

    @Test
    public void testInterpolate_Byte_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(10);
    }

    @Test
    public void testInterpolate_Short_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(11);
    }

    @Test
    public void testInterpolate_UShort_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(21);
    }

    @Test
    public void testInterpolate_Int_Bilinear() throws NoninvertibleTransformException {
        this.testBilinear(12);
    }

    @Test
    public void testBilinear_FirstAndLastPixelValid() throws NoninvertibleTransformException {
        String expression = "(X%2 == 0.5) ^ (Y%2 == 0.5) ? 123 :(X + 0.5) + ((Y + 0.5) * 2)";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.11538457, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.5, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.5, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.88461542, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)6.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    public void testBilinear_MiddlePixelsValid() throws NoninvertibleTransformException {
        String expression = "(X%2 == 0.5) ^ (Y%2 == 0.5) ? (X + 0.5) + ((Y + 0.5) * 2) : 123";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)4.5, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.038461685180664, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.961538314819336, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.5, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)123.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    public void testBilinear_FirstPixelIsInvalid() throws NoninvertibleTransformException {
        String expression = "(X == 0.5) && (Y == 0.5) ? 123 : (X + 0.5) + ((Y + 0.5) * 2)";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)4.541666507720947, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.375, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.333333492279053, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.041666507720947, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.541666507720947, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.66666666, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.16666666, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.83333333, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)6.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    public void testBilinear_SecondPixelIsInvalid() throws NoninvertibleTransformException {
        String expression = "(X == 1.5) && (Y == 0.5) ? 123 : (X + 0.5) + ((Y + 0.5) * 2)";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.569444417953491, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.513888835906982, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.847222328186035, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.56944465637207, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.16666666, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.83333333, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)6.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    public void testBilinear_ThirdPixelIsInvalid() throws NoninvertibleTransformException {
        String expression = "(X == 0.5) && (Y == 1.5) ? 123 : (X + 0.5) + ((Y + 0.5) * 2)";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.430555582046509, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.152777671813965, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.333333492279053, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.486111164093018, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.430555820465088, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.666666507720947, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)6.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    public void testBilinear_FourthPixelIsInvalid() throws NoninvertibleTransformException {
        String expression = "(X == 1.5) && (Y == 1.5) ? 123 : (X + 0.5) + ((Y + 0.5) * 2)";
        Band sourceBand = this.createSourceBand(30, expression);
        sourceBand.getSourceImage().getData().createCompatibleWritableRaster();
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.4583332538604736, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)3.9583332538604736, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.625, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.458333492279053, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
        Assert.assertEquals((Object)123.0, (Object)targetData.getSampleDouble(2, 2, 0));
    }

    @Test
    @Ignore
    public void testInterpolate_Double_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(31);
    }

    @Test
    @Ignore
    public void testInterpolate_Float_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(30);
    }

    @Test
    @Ignore
    public void testInterpolate_Byte_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(10);
    }

    @Test
    @Ignore
    public void testInterpolate_Short_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(11);
    }

    @Test
    @Ignore
    public void testInterpolate_UShort_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(21);
    }

    @Test
    @Ignore
    public void testInterpolate_Int_CubicConvolution() throws NoninvertibleTransformException {
        this.testCubicConvolution(12);
    }

    private void testCubicConvolution(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Cubic_Convolution, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.0, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 2, 0), (double)1.0E-8);
    }

    private void testBilinear(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Bilinear, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        if (dataType != 30 && dataType != 31) {
            Assert.assertEquals((double)3.0, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
            Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 2, 0), (double)1.0E-6);
        } else {
            Assert.assertEquals((double)3.5, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.16666666, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.33333333, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-6);
            Assert.assertEquals((double)4.83333333, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.5, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.66666666, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.16666666, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-6);
            Assert.assertEquals((double)5.83333333, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-6);
            Assert.assertEquals((Object)6.0, (Object)targetData.getSampleDouble(2, 2, 0));
        }
    }

    private void testNearestNeighbour(int dataType) throws NoninvertibleTransformException {
        Band sourceBand = this.createSourceBand(dataType);
        int dataBufferType = sourceBand.getSourceImage().getSampleModel().getDataType();
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)this.referenceBand, (int)dataBufferType);
        InterpolatedOpImage image = new InterpolatedOpImage((RenderedImage)sourceBand.getSourceImage(), imageLayout, sourceBand.getNoDataValue(), dataBufferType, InterpolationType.Nearest, sourceBand.getImageToModelTransform(), this.referenceBand.getImageToModelTransform());
        TestCase.assertNotNull((Object)image);
        Assert.assertEquals((int)this.referenceBand.getRasterWidth(), (int)image.getWidth());
        Assert.assertEquals((int)this.referenceBand.getRasterHeight(), (int)image.getHeight());
        Assert.assertEquals((int)dataBufferType, (int)image.getSampleModel().getDataType());
        Raster targetData = image.getData();
        Assert.assertEquals((double)3.0, (double)targetData.getSampleDouble(0, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(1, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)targetData.getSampleDouble(2, 0, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 1, 0), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)targetData.getSampleDouble(0, 2, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(1, 2, 0), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)targetData.getSampleDouble(2, 2, 0), (double)1.0E-8);
    }

    private Band createSourceBand(int dataType) {
        return this.createSourceBand(dataType, "(X + 0.5) + ((Y + 0.5) * 2)");
    }

    private Band createSourceBand(int dataType, String expression) {
        int sourceWidth = 2;
        int sourceHeight = 2;
        int sourceScaleX = 3;
        int sourceScaleY = 3;
        boolean sourceTranslateX = true;
        boolean sourceTranslateY = true;
        AffineTransform imageToModelTransform = new AffineTransform(sourceScaleX, 0.0f, 0.0f, sourceScaleY, (float)sourceTranslateX, (float)sourceTranslateY);
        Product sourceProduct = new Product("dummy", "dummy", sourceWidth, sourceHeight);
        Band sourceBand = sourceProduct.addBand("sourceBand", expression, dataType);
        sourceBand.setNoDataValue(123.0);
        sourceBand.setImageToModelTransform(imageToModelTransform);
        return sourceBand;
    }
}

