/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.reproject;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.reproject.AbstractReprojectionOpTest;
import org.junit.Assert;
import org.junit.Test;

public class NoDataReprojectionOpTest
extends AbstractReprojectionOpTest {
    @Test
    public void testNoDataIsPreservedFloat() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        Band srcBand = this.sourceProduct.getBand("floatData");
        int xIndex = 23;
        int yIndex = 13;
        int dataValue = xIndex * yIndex;
        srcBand.setNoDataValue((double)dataValue);
        srcBand.setNoDataValueUsed(true);
        Product targetProduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetProduct.getBand("floatData"), new PixelPos((double)((float)xIndex + 0.5f), (double)((float)yIndex + 0.5f)), dataValue, 299.0);
    }

    @Test
    public void testNoDataIsPreservedFloat_withExpression() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        Band srcBand = this.sourceProduct.getBand("floatData");
        srcBand.setNoDataValue(299.0);
        srcBand.setNoDataValueUsed(true);
        srcBand.setValidPixelExpression("fneq(floatData,299)");
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), 299.0, 299.0);
    }

    @Test
    public void testNoDataIsReplaced_WithNaN() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        Band srcBand = this.sourceProduct.getBand("floatData");
        srcBand.setValidPixelExpression("fneq(floatData,299)");
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), Double.NaN, Double.NaN);
    }

    @Test
    public void testNoDataParameter_WithExpressionAndValue() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("noDataValue", 42.0);
        Band srcBand = this.sourceProduct.getBand("floatData");
        srcBand.setNoDataValue(299.0);
        srcBand.setNoDataValueUsed(true);
        srcBand.setValidPixelExpression("fneq(floatData,299)");
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), 42.0, 42.0);
    }

    @Test
    public void testNoDataParameter_WithExpression() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("noDataValue", 42.0);
        Band srcBand = this.sourceProduct.getBand("floatData");
        srcBand.setValidPixelExpression("fneq(floatData,299)");
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), 42.0, 42.0);
    }

    @Test
    public void testNoDataParameter_WithValue() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("noDataValue", 42.0);
        Band srcBand = this.sourceProduct.getBand("floatData");
        srcBand.setNoDataValue(299.0);
        srcBand.setNoDataValueUsed(true);
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), 42.0, 42.0);
    }

    @Test
    public void testNoDataParameter_Float() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("noDataValue", 42.0);
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("floatData"), new PixelPos(23.5, 13.5), 42.0, 299.0);
    }

    @Test
    public void testNoDataParameter_Int() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        this.parameterMap.put("noDataValue", 100.0);
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("intData"), new PixelPos(23.5, 13.5), 100.0, 299.0);
    }

    @Test
    public void testNoDataIfBandNoDataIsGiven_Int() throws IOException {
        this.parameterMap.put("crs", "EPSG:32633");
        Band srcBand = this.sourceProduct.getBand("intData");
        srcBand.setNoDataValue(299.0);
        srcBand.setNoDataValueUsed(true);
        Product targetPoduct = this.createReprojectedProduct();
        this.assertNoDataValue(targetPoduct.getBand("intData"), new PixelPos(23.5, 13.5), 299.0, 299.0);
    }

    @Test
    public void testNoDataIfExpressionIsGiven_Int() throws IOException {
        this.parameterMap.put("crs", "EPSG:4326");
        Band srcBand = this.sourceProduct.getBand("intData");
        srcBand.setValidPixelExpression("(X-0.5) != 4");
        Product targetPoduct = this.createReprojectedProduct();
        Band targetBand = targetPoduct.getBand("intData");
        this.assertNoDataValue(targetBand, new PixelPos(4.5, 0.5), 0.0, 0.0);
        this.assertNoDataValue(targetBand, new PixelPos(4.5, 1.5), 0.0, 0.0);
        this.assertNoDataValue(targetBand, new PixelPos(4.5, 18.5), 0.0, 0.0);
        this.assertNoDataValue(targetBand, new PixelPos(5.5, 18.5), 0.0, 90.0);
    }

    private void assertNoDataValue(Band targetBand, PixelPos sourcePixelPos, double noDataValue, double expectedValue) throws IOException {
        Assert.assertEquals((double)noDataValue, (double)targetBand.getNoDataValue(), (double)1.0E-6);
        Assert.assertTrue((boolean)targetBand.isNoDataValueUsed());
        Assert.assertNull((Object)targetBand.getValidPixelExpression());
        this.assertPixelValue(targetBand, sourcePixelPos.x, sourcePixelPos.y, expectedValue, 1.0E-6);
        boolean expectedValidState = !Double.isNaN(noDataValue) && noDataValue != expectedValue;
        this.assertPixelValidState(targetBand, sourcePixelPos.x, sourcePixelPos.y, expectedValidState);
        PixelPos upperLeft = new PixelPos(0.5, 0.5);
        this.assertTargetPixelValue(targetBand, upperLeft, noDataValue, 1.0E-6);
        this.assertTargetPixelValidState(targetBand, upperLeft, false);
    }
}

