/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.common.WriteOp;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WriteVirtualBandWithWriteOpTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingVirtualBand() throws Exception {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        ProductWriterPlugIn mockPlugin = (ProductWriterPlugIn)Mockito.mock(ProductWriterPlugIn.class);
        try {
            registry.addWriterPlugIn(mockPlugin);
            Mockito.when((Object)mockPlugin.getFormatNames()).thenReturn((Object)new String[]{"Dummy-Mock-Format"});
            Mockito.when((Object)mockPlugin.getOutputTypes()).thenReturn((Object)new Class[]{File.class});
            ProductWriter mockedWriter = (ProductWriter)Mockito.mock(ProductWriter.class);
            Mockito.when((Object)mockedWriter.shouldWrite((ProductNode)Mockito.any(Band.class))).thenReturn((Object)true);
            Mockito.when((Object)mockedWriter.getWriterPlugIn()).thenReturn((Object)mockPlugin);
            Mockito.when((Object)mockPlugin.createWriterInstance()).thenReturn((Object)mockedWriter);
            Mockito.when((Object)mockPlugin.getEncodeQualification((Product)Mockito.any(Product.class))).thenReturn((Object)EncodeQualification.FULL);
            Product productToWrite = new Product("TODO", "TBD", 10, 10);
            productToWrite.addBand((Band)new VirtualBand("virtband", 30, 10, 10, "3 * 4"));
            WriteOp writeOp = new WriteOp(productToWrite, new File("notUsed.nc"), "Dummy-Mock-Format");
            writeOp.writeProduct(ProgressMonitor.NULL);
            writeOp.dispose();
            ((ProductWriter)Mockito.verify((Object)mockedWriter, (VerificationMode)Mockito.times((int)10))).writeBandRasterData((Band)Mockito.argThat((Matcher)new IsBand("virtband")), Mockito.eq((int)0), Mockito.anyInt(), Mockito.eq((int)10), Mockito.anyInt(), (ProductData)Mockito.argThat((Matcher)new HasValidValue(12.0f, 3)), (ProgressMonitor)Mockito.any(ProgressMonitor.class));
        }
        finally {
            registry.removeWriterPlugIn(mockPlugin);
        }
    }

    private class HasValidValue
    extends ArgumentMatcher<ProductData> {
        private final float expectedValue;
        private final int atIndex;

        HasValidValue(float expectedValue, int atIndex) {
            this.expectedValue = expectedValue;
            this.atIndex = atIndex;
        }

        public boolean matches(Object argument) {
            float actualValue = ((ProductData)argument).getElemFloatAt(this.atIndex);
            return Float.compare(this.expectedValue, actualValue) == 0;
        }
    }

    private class IsBand
    extends ArgumentMatcher<Band> {
        private final String bandName;

        IsBand(String bandName) {
            this.bandName = bandName;
        }

        public boolean matches(Object argument) {
            return this.bandName.equals(((Band)argument).getName());
        }
    }
}

