/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.media.jai.JAI;
import javax.media.jai.TileScheduler;
import junit.framework.TestCase;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WriteOpTest {
    private static final int RASTER_WIDTH = 4;
    private static final int RASTER_HEIGHT = 40;
    private AlgoOp.Spi algoSpi = new AlgoOp.Spi();
    private WriteOp.Spi writeSpi = new WriteOp.Spi();
    private File outputFile;
    private int oldParallelism;

    @Before
    public void setUp() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.algoSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)this.writeSpi);
        this.outputFile = GlobalTestConfig.getBeamTestDataOutputFile((String)"WriteOpTest/writtenProduct.dim");
        this.outputFile.getParentFile().mkdirs();
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        this.oldParallelism = tileScheduler.getParallelism();
        tileScheduler.setParallelism(Runtime.getRuntime().availableProcessors());
    }

    @After
    public void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.algoSpi);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)this.writeSpi);
        File parentFile = this.outputFile.getParentFile();
        FileUtils.deleteTree((File)parentFile);
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        tileScheduler.setParallelism(this.oldParallelism);
    }

    @Test
    public void testWrite() throws Exception {
        String graphOpXml = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Algo</operator>\n    <parameters>\n    <width>4</width>\n    <height>40</height>\n    <preferredTileWidth>2</preferredTileWidth>\n    <preferredTileHeight>2</preferredTileHeight>\n    </parameters>\n  </node>\n  <node id=\"node2\">\n    <operator>Write</operator>\n    <sources>\n      <source refid=\"node1\"/>\n    </sources>\n    <parameters>\n       <file>" + this.outputFile.getAbsolutePath() + "</file>\n" + "       <deleteOutputOnFailure>false</deleteOutputOnFailure>\n" + "    </parameters>\n" + "  </node>\n" + "</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        GraphProcessor processor = new GraphProcessor();
        processor.executeGraph(graph, ProgressMonitor.NULL);
        Product productOnDisk = ProductIO.readProduct((File)this.outputFile);
        TestCase.assertNotNull((Object)productOnDisk);
        TestCase.assertEquals((String)"writtenProduct", (String)productOnDisk.getName());
        TestCase.assertEquals((int)3, (int)productOnDisk.getNumBands());
        TestCase.assertEquals((String)"OperatorBand", (String)productOnDisk.getBandAt(0).getName());
        TestCase.assertEquals((String)"ConstantBand", (String)productOnDisk.getBandAt(1).getName());
        TestCase.assertEquals((String)"VirtualBand", (String)productOnDisk.getBandAt(2).getName());
        Band operatorBand = productOnDisk.getBandAt(0);
        operatorBand.loadRasterData();
        PlacemarkGroup placemarkProductNodeGroup = productOnDisk.getPinGroup();
        productOnDisk.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingEmptyProduct() throws Exception {
        Product product = new Product("empty", "EMPTY", 0, 0);
        File testDir = Files.createTempDirectory("WriteOpTestDir", new FileAttribute[0]).toFile();
        try {
            File testOuptutFile = new File(testDir, "file.dim");
            WriteOp writeOp = new WriteOp(product, testOuptutFile, "BEAM-DIMAP");
            writeOp.writeProduct(ProgressMonitor.NULL);
            TestCase.assertFalse((boolean)testOuptutFile.isFile());
        }
        finally {
            testDir.deleteOnExit();
        }
    }

    @Test
    public void testWrite_UnexpectedTiling() throws Exception {
        String graphOpXml = "<graph id=\"myOneNodeGraph\">\n  <version>1.0</version>\n  <node id=\"node1\">\n    <operator>Algo</operator>\n    <parameters>\n    <width>2000</width>\n    <height>2000</height>\n    <preferredTileWidth>750</preferredTileWidth>\n    <preferredTileHeight>750</preferredTileHeight>\n    </parameters>\n  </node>\n  <node id=\"node2\">\n    <operator>Write</operator>\n    <sources>\n      <source refid=\"node1\"/>\n    </sources>\n    <parameters>\n       <file>" + this.outputFile.getAbsolutePath() + "</file>\n" + "       <deleteOutputOnFailure>false</deleteOutputOnFailure>\n" + "    </parameters>\n" + "  </node>\n" + "</graph>";
        StringReader reader = new StringReader(graphOpXml);
        Graph graph = GraphIO.read((Reader)reader);
        GraphProcessor processor = new GraphProcessor();
        processor.executeGraph(graph, ProgressMonitor.NULL);
        Product productOnDisk = ProductIO.readProduct((File)this.outputFile);
        TestCase.assertNotNull((Object)productOnDisk);
        TestCase.assertEquals((String)"writtenProduct", (String)productOnDisk.getName());
        TestCase.assertEquals((int)3, (int)productOnDisk.getNumBands());
        TestCase.assertEquals((String)"OperatorBand", (String)productOnDisk.getBandAt(0).getName());
        TestCase.assertEquals((String)"ConstantBand", (String)productOnDisk.getBandAt(1).getName());
        TestCase.assertEquals((String)"VirtualBand", (String)productOnDisk.getBandAt(2).getName());
        Band operatorBand = productOnDisk.getBandAt(0);
        operatorBand.loadRasterData();
        PlacemarkGroup placemarkProductNodeGroup = productOnDisk.getPinGroup();
        productOnDisk.dispose();
    }

    @OperatorMetadata(alias="Algo")
    public static class AlgoOp
    extends Operator {
        @Parameter
        private int width;
        @Parameter
        private int height;
        @Parameter
        private int preferredTileWidth;
        @Parameter
        private int preferredTileHeight;
        @TargetProduct
        private Product targetProduct;

        public void initialize() {
            this.targetProduct = new Product("name", "desc", this.width, this.height);
            this.targetProduct.addBand("OperatorBand", 10);
            this.targetProduct.addBand("ConstantBand", 10).setSourceImage((RenderedImage)new BufferedImage(this.width, this.height, 13));
            this.targetProduct.addBand((Band)new VirtualBand("VirtualBand", 30, this.width, this.height, "OperatorBand + ConstantBand"));
            this.targetProduct.setPreferredTileSize(this.preferredTileWidth, this.preferredTileHeight);
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) {
            for (Tile.Pos pos : targetTile) {
                targetTile.setSample(pos.x, pos.y, 12345);
            }
            int minX = targetTile.getMinX();
            int minY = targetTile.getMinY();
            Placemark placemark = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)(band.getName() + "-" + minX + "-" + minY), (String)"label", (String)"descr", (PixelPos)new PixelPos((double)minX, (double)minY), null, (GeoCoding)this.targetProduct.getSceneGeoCoding());
            this.targetProduct.getPinGroup().add(placemark);
            System.out.println("placemark = " + placemark.getName());
        }

        public static class Spi
        extends OperatorSpi {
            public Spi() {
                super(AlgoOp.class);
            }
        }
    }
}

