/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.gpf.graph.GraphException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class SubsetOpTest {
    @Test
    public void testConstructorUsage() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        String[] bandNames = new String[]{"radiance_1", "radiance_3"};
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(bandNames);
        Assert.assertSame((Object)sp, (Object)op.getSourceProduct());
        Assert.assertNotSame((Object)bandNames, (Object)op.getBandNames());
        Product tp = op.getTargetProduct();
        Assert.assertEquals((long)2L, (long)tp.getNumBands());
        Assert.assertNotNull((Object)tp.getBand("radiance_1"));
        Assert.assertNull((Object)tp.getBand("radiance_2"));
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
    }

    @Test
    public void testEmptyRegionFails() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setRegion(new Rectangle(0, 0, 0, 0));
        Product targetProduct = op.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((long)100L, (long)targetProduct.getSceneRasterWidth());
        Assert.assertEquals((long)100L, (long)targetProduct.getSceneRasterHeight());
    }

    @Test
    public void testNonGeoMatchingRegionFails() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        sp.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 100, 100, 10.0, 50.0, 0.1, 0.1));
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        Polygon subsetRegion = SubsetOpTest.createBBOX(-59.0, -35.0, 2.0, 2.0);
        op.setGeoRegion((Geometry)subsetRegion);
        Product targetProduct = op.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        Assert.assertEquals((long)0L, (long)targetProduct.getSceneRasterWidth());
        Assert.assertEquals((long)0L, (long)targetProduct.getSceneRasterHeight());
    }

    @Test
    public void testReferencedRastersAreIncluded() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        sp.getBand("radiance_1").setValidPixelExpression("radiance_2 > 0");
        String[] bandNames = new String[]{"radiance_1", "radiance_3"};
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(bandNames);
        Product tp = op.getTargetProduct();
        Assert.assertEquals((long)3L, (long)tp.getNumBands());
        Assert.assertNotNull((Object)tp.getBand("radiance_1"));
        Assert.assertEquals((Object)"radiance_2 > 0", (Object)tp.getBand("radiance_1").getValidPixelExpression());
        Assert.assertNotNull((Object)tp.getBand("radiance_2"));
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
    }

    @Test
    public void testInstantiationWithGPF() throws GraphException {
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
        GeometryFactory gf = new GeometryFactory();
        Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(-5.0, 5.0), new Coordinate(5.0, 5.0), new Coordinate(5.0, -5.0), new Coordinate(-5.0, -5.0), new Coordinate(-5.0, 5.0)}), null);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("geoRegion", polygon.toText());
        parameters.put("fullSwath", true);
        String expectedBandName = "radiance_3";
        parameters.put("sourceBands", new String[]{"radiance_3"});
        Product sp = this.createTestProduct(100, 100);
        Assert.assertNotNull((Object)sp.getSceneGeoCoding());
        Product tp = GPF.createProduct((String)"Subset", parameters, (Product)sp);
        Assert.assertNotNull((Object)tp);
        Assert.assertEquals((long)100L, (long)tp.getSceneRasterWidth());
        Assert.assertEquals((long)50L, (long)tp.getSceneRasterHeight());
        Assert.assertEquals((long)1L, (long)tp.getNumBands());
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
    }

    @Test
    public void testGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Product sp = this.createTestProduct(100, 100);
        Assert.assertNotNull((Object)sp.getSceneGeoCoding());
        Polygon roi = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(-5.0, 5.0), new Coordinate(5.0, 5.0), new Coordinate(5.0, -5.0), new Coordinate(-5.0, -5.0), new Coordinate(-5.0, 5.0)}), null);
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(new String[]{"radiance_1", "radiance_3"});
        op.setGeoRegion((Geometry)roi);
        Assert.assertEquals((Object)roi, (Object)op.getGeoRegion());
        Product tp = op.getTargetProduct();
        Assert.assertNotNull((Object)tp);
        Assert.assertEquals((Object)new Rectangle(25, 25, 50, 50), (Object)op.getRegion());
        Assert.assertEquals((long)50L, (long)tp.getSceneRasterWidth());
        Assert.assertEquals((long)50L, (long)tp.getSceneRasterHeight());
        Assert.assertNotNull((Object)tp.getBand("radiance_1"));
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
    }

    @Test
    public void testComputationOfProductGeometriesAndPixelRegions() throws TransformException, FactoryException {
        Product product = new Product("N", "T", 360, 180);
        AffineTransform at = AffineTransform.getTranslateInstance(-180.0, -90.0);
        CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, new Rectangle(360, 180), at);
        product.setSceneGeoCoding((GeoCoding)geoCoding);
        Geometry geometry = SubsetOp.computeProductGeometry((Product)product);
        Assert.assertTrue((boolean)(geometry instanceof Polygon));
        Assert.assertEquals((Object)"POLYGON ((-179.5 -89.5, -179.5 89.5, 179.5 89.5, 179.5 -89.5, -179.5 -89.5))", (Object)geometry.toString());
        Rectangle rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)geometry, (int)0);
        Assert.assertEquals((Object)new Rectangle(360, 180), (Object)rectangle);
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(product);
        op.setRegion(new Rectangle(130, 65, 100, 50));
        product = op.getTargetProduct();
        geometry = SubsetOp.computeProductGeometry((Product)product);
        Assert.assertTrue((boolean)(geometry instanceof Polygon));
        Assert.assertEquals((Object)"POLYGON ((-49.5 -24.5, -49.5 24.5, 49.5 24.5, 49.5 -24.5, -49.5 -24.5))", (Object)geometry.toString());
        rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)SubsetOpTest.createBBOX(0.0, 0.0, 10.0, 10.0), (int)0);
        Assert.assertEquals((Object)new Rectangle(50, 25, 10, 10), (Object)rectangle);
        rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)SubsetOpTest.createBBOX(0.0, 0.0, 10.0, 10.0), (int)1);
        Assert.assertEquals((Object)new Rectangle(49, 24, 12, 12), (Object)rectangle);
        rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)SubsetOpTest.createBBOX(45.5, 20.5, 100.0, 50.0), (int)0);
        Assert.assertEquals((Object)new Rectangle(95, 45, 5, 5), (Object)rectangle);
        rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)SubsetOpTest.createBBOX(-180.0, -90.0, 360.0, 180.0), (int)0);
        Assert.assertEquals((Object)new Rectangle(0, 0, 100, 50), (Object)rectangle);
        rectangle = SubsetOp.computePixelRegion((Product)product, (Geometry)SubsetOpTest.createBBOX(60.0, 0.0, 10.0, 10.0), (int)0);
        Assert.assertEquals((Object)true, (Object)rectangle.isEmpty());
    }

    @Test
    public void testAutoGrouping() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        sp.setAutoGrouping("radiance");
        String[] bandNames = new String[]{"radiance_1", "radiance_3"};
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(bandNames);
        Product tp = op.getTargetProduct();
        Assert.assertEquals((long)2L, (long)tp.getNumBands());
        Product.AutoGrouping autoGrouping = tp.getAutoGrouping();
        Assert.assertNotNull((Object)autoGrouping);
        Assert.assertEquals((long)1L, (long)autoGrouping.size());
        Assert.assertArrayEquals((Object[])new String[]{"radiance"}, (Object[])((Object[])autoGrouping.get(0)));
    }

    @Test
    public void testCopyMetadata() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        this.addMetadata(sp);
        String[] bandNames = new String[]{"radiance_1", "radiance_3"};
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(bandNames);
        op.setCopyMetadata(true);
        Assert.assertSame((Object)sp, (Object)op.getSourceProduct());
        Assert.assertNotSame((Object)bandNames, (Object)op.getBandNames());
        Product tp = op.getTargetProduct();
        Assert.assertEquals((long)2L, (long)tp.getNumBands());
        Assert.assertNotNull((Object)tp.getBand("radiance_1"));
        Assert.assertNull((Object)tp.getBand("radiance_2"));
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
        MetadataElement root = tp.getMetadataRoot();
        Assert.assertNotNull((Object)root);
        MetadataAttribute attribRoot = root.getAttribute("attribRoot");
        Assert.assertNotNull((Object)attribRoot);
        Assert.assertEquals((Object)"rootValue", (Object)attribRoot.getData().getElemString());
        Assert.assertTrue((boolean)root.containsElement("meta1"));
        MetadataAttribute attrib1 = root.getElement("meta1").getAttribute("attrib1");
        Assert.assertNotNull((Object)attrib1);
        Assert.assertEquals((Object)"value", (Object)attrib1.getData().getElemString());
        MetadataElement meta2 = root.getElement("meta2");
        Assert.assertNotNull((Object)meta2);
        MetadataElement meta2_1 = meta2.getElement("meta2_1");
        Assert.assertNotNull((Object)meta2_1);
        MetadataAttribute attrib2_1 = meta2_1.getAttribute("attrib2_1");
        Assert.assertEquals((Object)"meta2_1_value", (Object)attrib2_1.getData().getElemString());
    }

    @Test
    public void testAvoidCopyMetadata() throws Exception {
        Product sp = this.createTestProduct(100, 100);
        this.addMetadata(sp);
        String[] bandNames = new String[]{"radiance_1", "radiance_3"};
        SubsetOp op = new SubsetOp();
        op.setSourceProduct(sp);
        op.setBandNames(bandNames);
        op.setCopyMetadata(false);
        Assert.assertSame((Object)sp, (Object)op.getSourceProduct());
        Assert.assertNotSame((Object)bandNames, (Object)op.getBandNames());
        Product tp = op.getTargetProduct();
        Assert.assertEquals((long)2L, (long)tp.getNumBands());
        Assert.assertNotNull((Object)tp.getBand("radiance_1"));
        Assert.assertNull((Object)tp.getBand("radiance_2"));
        Assert.assertNotNull((Object)tp.getBand("radiance_3"));
        MetadataElement root = tp.getMetadataRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertFalse((boolean)root.containsElement("attribRoot"));
        Assert.assertFalse((boolean)root.containsElement("meta1"));
        Assert.assertFalse((boolean)root.containsElement("meta2"));
    }

    private static Polygon createBBOX(double x, double y, double w, double h) {
        GeometryFactory factory = new GeometryFactory();
        LinearRing ring = factory.createLinearRing(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + w, y), new Coordinate(x + w, y + h), new Coordinate(x, y + h), new Coordinate(x, y)});
        return factory.createPolygon(ring, null);
    }

    private void addMetadata(Product sp) {
        MetadataElement meta1 = new MetadataElement("meta1");
        meta1.addAttribute(new MetadataAttribute("attrib1", ProductData.createInstance((String)"value"), true));
        MetadataElement meta2 = new MetadataElement("meta2");
        MetadataElement meta2_1 = new MetadataElement("meta2_1");
        meta2_1.addAttribute(new MetadataAttribute("attrib2_1", ProductData.createInstance((String)"meta2_1_value"), true));
        meta2.addElement(meta2_1);
        MetadataElement metadataRoot = sp.getMetadataRoot();
        metadataRoot.addAttribute(new MetadataAttribute("attribRoot", ProductData.createInstance((String)"rootValue"), true));
        metadataRoot.addElement(meta1);
        metadataRoot.addElement(meta2);
    }

    private Product createTestProduct(int w, int h) {
        Product product = new Product("p", "t", w, h);
        Placemark[] gcps = new Placemark[]{Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)"p1", (String)"p1", (String)"", (PixelPos)new PixelPos(0.5, 0.5), (GeoPos)new GeoPos(10.0, -10.0), null), Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)"p2", (String)"p2", (String)"", (PixelPos)new PixelPos((double)((float)w - 0.5f), 0.5), (GeoPos)new GeoPos(10.0, 10.0), null), Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)"p3", (String)"p3", (String)"", (PixelPos)new PixelPos((double)((float)w - 0.5f), (double)((float)h - 0.5f)), (GeoPos)new GeoPos(-10.0, 10.0), null), Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)"p4", (String)"p4", (String)"", (PixelPos)new PixelPos(0.5, (double)((float)h - 0.5f)), (GeoPos)new GeoPos(-10.0, -10.0), null)};
        product.setSceneGeoCoding((GeoCoding)new GcpGeoCoding(GcpGeoCoding.Method.POLYNOMIAL1, gcps, w, h, Datum.WGS_84));
        Band band1 = product.addBand("radiance_1", 12);
        int[] intValues = new int[w * h];
        Arrays.fill(intValues, 1);
        band1.setData(ProductData.createInstance((int[])intValues));
        Band band2 = product.addBand("radiance_2", 30);
        float[] floatValues = new float[w * h];
        Arrays.fill(floatValues, 2.5f);
        band2.setData(ProductData.createInstance((float[])floatValues));
        Band band3 = product.addBand("radiance_3", 11);
        band3.setScalingFactor(0.5);
        short[] shortValues = new short[w * h];
        Arrays.fill(shortValues, (short)6);
        band3.setData(ProductData.createInstance((short[])shortValues));
        return product;
    }
}

