/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.common.MosaicOp;
import org.geotools.referencing.CRS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class MosaicOpTest {
    private static final int WIDTH = 10;
    private static final int HEIGHT = 10;
    private static Product product1;
    private static Product product2;
    private static Product product3;

    @BeforeClass
    public static void setup() throws FactoryException, TransformException {
        product1 = MosaicOpTest.createProduct("P1", 0, 0, 2.0f);
        product2 = MosaicOpTest.createProduct("P2", 4, -4, 3.0f);
        product3 = MosaicOpTest.createProduct("P3", -5, 5, 5.0f);
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.loadOperatorSpis();
    }

    @AfterClass
    public static void teardown() {
        product1.dispose();
        product2.dispose();
        product3.dispose();
    }

    @Test
    public void testMosaickingSimple() throws IOException {
        MosaicOp op = new MosaicOp();
        op.setParameterDefaultValues();
        op.setSourceProducts(new Product[]{product1, product2, product3});
        op.variables = new MosaicOp.Variable[]{new MosaicOp.Variable("b1", "b1")};
        op.westBound = -10.0;
        op.northBound = 10.0;
        op.eastBound = 10.0;
        op.southBound = -10.0;
        op.pixelSizeX = 1.0;
        op.pixelSizeY = 1.0;
        Product product = op.getTargetProduct();
        GeoPos[] geoPositions = new GeoPos[]{new GeoPos(8.0, -8.0), new GeoPos(4.0, -4.0), new GeoPos(-1.0, 1.0), new GeoPos(-4.0, 4.0), new GeoPos(-8.0, 8.0)};
        Band b1Band = product.getBand("b1");
        this.assertSampleValuesFloat(b1Band, geoPositions, new float[]{0.0f, 5.0f, 3.5f, 3.333333f, 2.5f});
        Band countBand = product.getBand("b1_count");
        this.assertSampleValuesInt(countBand, geoPositions, new int[]{0, 1, 2, 3, 2});
    }

    @Test
    public void testMosaickingWithConditions() {
        MosaicOp op = new MosaicOp();
        op.setParameterDefaultValues();
        op.setSourceProducts(new Product[]{product1, product2, product3});
        op.variables = new MosaicOp.Variable[]{new MosaicOp.Variable("b1", "b1")};
        op.conditions = new MosaicOp.Condition[]{new MosaicOp.Condition("b1_cond", "b1 != 3", true)};
        op.westBound = -10.0;
        op.northBound = 10.0;
        op.eastBound = 10.0;
        op.southBound = -10.0;
        op.pixelSizeX = 1.0;
        op.pixelSizeY = 1.0;
        Product product = op.getTargetProduct();
        GeoPos[] geoPositions = new GeoPos[]{new GeoPos(8.0, -8.0), new GeoPos(4.0, -4.0), new GeoPos(-1.0, 1.0), new GeoPos(-4.0, 4.0), new GeoPos(-8.0, 8.0)};
        Band b1Band = product.getBand("b1");
        this.assertSampleValuesFloat(b1Band, geoPositions, new float[]{0.0f, 5.0f, 3.5f, 3.5f, 2.0f});
        Band countBand = product.getBand("b1_count");
        this.assertSampleValuesInt(countBand, geoPositions, new int[]{0, 1, 2, 2, 1});
        Band condBand = product.getBand("b1_cond");
        this.assertSampleValuesInt(condBand, geoPositions, new int[]{0, 1, 2, 2, 1});
    }

    @Test
    public void testMosaickingWithInvalidSourceSamples() throws IOException {
        Product product1Copy = ProductSubsetBuilder.createProductSubset((Product)product1, null, (String)"P1", (String)"Descr");
        Band flagBand = product1Copy.addBand("flag", 12);
        BufferedImage flagImage = new BufferedImage(10, 10, 3);
        int[] flagData = new int[100];
        Arrays.fill(flagData, 1);
        Arrays.fill(flagData, 0, 30, 0);
        flagImage.getRaster().setDataElements(0, 0, 10, 10, flagData);
        flagBand.setSourceImage((RenderedImage)flagImage);
        product1Copy.getBand("b1").setValidPixelExpression("flag == 1");
        MosaicOp op = new MosaicOp();
        op.setParameterDefaultValues();
        op.setSourceProducts(new Product[]{product1Copy, product2, product3});
        op.variables = new MosaicOp.Variable[]{new MosaicOp.Variable("b1", "b1")};
        op.conditions = new MosaicOp.Condition[]{new MosaicOp.Condition("b1_cond", "b1 != 3", true)};
        op.westBound = -10.0;
        op.northBound = 10.0;
        op.eastBound = 10.0;
        op.southBound = -10.0;
        op.pixelSizeX = 1.0;
        op.pixelSizeY = 1.0;
        Product product = op.getTargetProduct();
        GeoPos[] geoPositions = new GeoPos[]{new GeoPos(8.0, -8.0), new GeoPos(4.0, -4.0), new GeoPos(-1.0, 1.0), new GeoPos(-4.0, 4.0), new GeoPos(-8.0, 8.0)};
        Band b1Band = product.getBand("b1");
        this.assertSampleValuesFloat(b1Band, geoPositions, new float[]{0.0f, 5.0f, 5.0f, 3.5f, 2.0f});
        Band countBand = product.getBand("b1_count");
        this.assertSampleValuesInt(countBand, geoPositions, new int[]{0, 1, 1, 2, 1});
        Band condBand = product.getBand("b1_cond");
        this.assertSampleValuesInt(condBand, geoPositions, new int[]{0, 1, 1, 2, 1});
    }

    @Test
    public void testMosaickingUpdate() throws IOException {
        MosaicOp mosaicOp = new MosaicOp();
        mosaicOp.setParameterDefaultValues();
        mosaicOp.setSourceProducts(new Product[]{product1, product2});
        mosaicOp.variables = new MosaicOp.Variable[]{new MosaicOp.Variable("b1", "b1")};
        mosaicOp.conditions = new MosaicOp.Condition[]{new MosaicOp.Condition("b1_cond", "b1 != 3", true)};
        mosaicOp.westBound = -10.0;
        mosaicOp.northBound = 10.0;
        mosaicOp.eastBound = 10.0;
        mosaicOp.southBound = -10.0;
        mosaicOp.pixelSizeX = 1.0;
        mosaicOp.pixelSizeY = 1.0;
        Product mosaicProduct = mosaicOp.getTargetProduct();
        MetadataElement mosaicMetadata = mosaicProduct.getMetadataRoot().getElement("Processing_Graph");
        Assert.assertNotNull((Object)mosaicMetadata);
        MetadataElement mosaicSourcesElement = this.getSourcesElement(mosaicOp, mosaicMetadata);
        Assert.assertEquals((long)2L, (long)mosaicSourcesElement.getNumAttributes());
        for (int i = 0; i < mosaicSourcesElement.getAttributes().length; ++i) {
            MetadataAttribute attribute = mosaicSourcesElement.getAttributes()[i];
            Assert.assertEquals((Object)("sourceProduct." + (1 + i)), (Object)attribute.getName());
        }
        GeoPos[] geoPositions = new GeoPos[]{new GeoPos(8.0, -8.0), new GeoPos(4.0, -4.0), new GeoPos(-1.0, 1.0), new GeoPos(-4.0, 4.0), new GeoPos(-8.0, 8.0)};
        Band b1Band = mosaicProduct.getBand("b1");
        this.assertSampleValuesFloat(b1Band, geoPositions, new float[]{0.0f, 0.0f, 2.0f, 2.0f, 2.0f});
        Band countBand = mosaicProduct.getBand("b1_count");
        this.assertSampleValuesInt(countBand, geoPositions, new int[]{0, 0, 1, 1, 1});
        Band condBand = mosaicProduct.getBand("b1_cond");
        this.assertSampleValuesInt(condBand, geoPositions, new int[]{0, 0, 1, 1, 1});
        MosaicOp mosaicUpdateOp = new MosaicOp();
        mosaicUpdateOp.setParameterDefaultValues();
        mosaicUpdateOp.setSourceProducts(new Product[]{product3});
        mosaicUpdateOp.updateProduct = mosaicOp.getTargetProduct();
        Product product = mosaicUpdateOp.getTargetProduct();
        MetadataElement updateMetadata = product.getMetadataRoot().getElement("Processing_Graph");
        Assert.assertNotNull((Object)updateMetadata);
        MetadataElement updateSourcesElement = this.getSourcesElement(mosaicUpdateOp, updateMetadata);
        Assert.assertEquals((long)3L, (long)updateSourcesElement.getNumAttributes());
        for (int i = 0; i < updateSourcesElement.getAttributes().length; ++i) {
            MetadataAttribute attribute = updateSourcesElement.getAttributes()[i];
            Assert.assertEquals((Object)("sourceProduct." + (1 + i)), (Object)attribute.getName());
        }
        b1Band = product.getBand("b1");
        this.assertSampleValuesFloat(b1Band, geoPositions, new float[]{0.0f, 5.0f, 3.5f, 3.5f, 2.0f});
        countBand = product.getBand("b1_count");
        this.assertSampleValuesInt(countBand, geoPositions, new int[]{0, 1, 2, 2, 1});
        condBand = product.getBand("b1_cond");
        this.assertSampleValuesInt(condBand, geoPositions, new int[]{0, 1, 2, 2, 1});
    }

    private MetadataElement getSourcesElement(MosaicOp mosaicUpdateOp, MetadataElement mosaicMetadata) {
        for (MetadataElement element : mosaicMetadata.getElements()) {
            if (!mosaicUpdateOp.getSpi().getOperatorAlias().equals(element.getAttributeString("operator"))) continue;
            return element.getElement("sources");
        }
        return null;
    }

    private void assertSampleValuesFloat(Band b1Band, GeoPos[] geoPositions, float[] expectedValues) {
        GeoCoding geoCoding = b1Band.getGeoCoding();
        Raster b1Raster = b1Band.getSourceImage().getData();
        for (int i = 0; i < geoPositions.length; ++i) {
            PixelPos pp = geoCoding.getPixelPos(geoPositions[i], null);
            float expectedValue = expectedValues[i];
            float actualValue = b1Raster.getSampleFloat((int)pp.x, (int)pp.y, 0);
            String message = String.format("At <%d>:", i);
            Assert.assertEquals((String)message, (double)expectedValue, (double)actualValue, (double)1.0E-6);
        }
    }

    private void assertSampleValuesInt(Band b1Band, GeoPos[] geoPositions, int[] expectedValues) {
        GeoCoding geoCoding = b1Band.getGeoCoding();
        Raster b1Raster = b1Band.getSourceImage().getData();
        for (int i = 0; i < geoPositions.length; ++i) {
            PixelPos pp = geoCoding.getPixelPos(geoPositions[i], null);
            int expectedValue = expectedValues[i];
            int actualValue = b1Raster.getSample((int)pp.x, (int)pp.y, 0);
            String message = String.format("At <%d>:", i);
            Assert.assertEquals((String)message, (long)expectedValue, (long)actualValue);
        }
    }

    private static Product createProduct(String name, int easting, int northing, float bandFillValue) throws FactoryException, TransformException {
        Product product = new Product(name, "T", 10, 10);
        product.addBand(MosaicOpTest.createBand(bandFillValue));
        AffineTransform transform = new AffineTransform();
        transform.translate(easting, northing);
        transform.scale(1.0, -1.0);
        transform.translate(-0.5, -0.5);
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding(CRS.decode((String)"EPSG:4326", (boolean)true), new Rectangle(0, 0, 10, 10), transform));
        return product;
    }

    private static Band createBand(float fillValue) {
        Band band = new Band("b1", 30, 10, 10);
        band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(fillValue)}, null));
        return band;
    }
}

