/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MosaicOpImageTest {
    private RenderedImage[] sourceImages;
    private PlanarImage[] alphaImages;

    @Before
    public void setup() {
        this.sourceImages = new RenderedImage[]{ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(2.0f)}, null), ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(3.0f)}, null), ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(5.0f)}, null), ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(7.0f)}, null)};
        this.alphaImages = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(1.0f)}, null)), PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(2.0f)}, null)), PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(3.0f)}, null)), PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(4.0f)}, null))};
    }

    @Test
    public void testAveraging() {
        RenderedOp mosaicImage = MosaicDescriptor.create((RenderedImage[])this.sourceImages, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_BLEND, (PlanarImage[])this.alphaImages, null, (double[][])null, null, null);
        Raster data = mosaicImage.getData();
        float sample = data.getSampleFloat(0, 0, 0);
        Assert.assertEquals((float)5.1f, (float)sample, (float)0.0f);
        sample = data.getSampleFloat(5, 5, 0);
        Assert.assertEquals((float)5.1f, (float)sample, (float)0.0f);
    }

    @Test
    public void testMosaicUpdate() {
        RenderedOp firstImage = MosaicDescriptor.create((RenderedImage[])Arrays.copyOf(this.sourceImages, 3), (MosaicType)MosaicDescriptor.MOSAIC_TYPE_BLEND, (PlanarImage[])Arrays.copyOf(this.alphaImages, 3), null, (double[][])null, null, null);
        PlanarImage[] alphaUpdateImages = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(6.0f)}, null)), PlanarImage.wrapRenderedImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])new Float[]{Float.valueOf(4.0f)}, null))};
        RenderedImage[] sourceUpdateImages = new RenderedImage[]{firstImage, this.sourceImages[3]};
        RenderedOp updatedImage = MosaicDescriptor.create((RenderedImage[])sourceUpdateImages, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_BLEND, (PlanarImage[])alphaUpdateImages, null, (double[][])null, null, null);
        Raster data = updatedImage.getData();
        float sample = data.getSampleFloat(0, 0, 0);
        Assert.assertEquals((float)5.1f, (float)sample, (float)0.0f);
        sample = data.getSampleFloat(5, 5, 0);
        Assert.assertEquals((float)5.1f, (float)sample, (float)0.0f);
    }
}

