/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.common.MergeOp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeOpTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testMergeOp_includeAll() throws Exception {
        Product productA = new Product("dummy1", "mergeOpTest", 10, 10);
        Product productB = new Product("dummy2", "mergeOpTest", 10, 10);
        productA.addBand("A", 30);
        productB.addBand("B", 30);
        MergeOp mergeOp = new MergeOp();
        mergeOp.setSourceProduct("masterProduct", productA);
        mergeOp.setSourceProduct("dummy2", productB);
        Product mergedProduct = mergeOp.getTargetProduct();
        Assert.assertNotNull((Object)mergedProduct);
        Assert.assertTrue((boolean)mergedProduct.containsBand("A"));
        Assert.assertTrue((boolean)mergedProduct.containsBand("B"));
        Assert.assertEquals((Object)"dummy1", (Object)mergedProduct.getName());
        Assert.assertSame((Object)productA, (Object)mergedProduct);
    }

    @Test
    public void testMergeOp_includeByPattern() throws Exception {
        Product productA = new Product("dummy1", "mergeOpTest", 10, 10);
        Product productB = new Product("dummy2", "mergeOpTest", 10, 10);
        productA.addBand("A", 30);
        productB.addBand("B", 30);
        productB.addBand("C", 30);
        MergeOp mergeOp = new MergeOp();
        mergeOp.setSourceProduct("masterProduct", productA);
        mergeOp.setSourceProduct("dummy2", productB);
        MergeOp.NodeDescriptor nodeDescriptor = new MergeOp.NodeDescriptor();
        nodeDescriptor.setNamePattern("B");
        nodeDescriptor.setProductId("dummy2");
        MergeOp.NodeDescriptor[] nodeDescriptors = new MergeOp.NodeDescriptor[]{nodeDescriptor};
        mergeOp.setParameter("includes", (Object)nodeDescriptors);
        Product mergedProduct = mergeOp.getTargetProduct();
        Assert.assertNotNull((Object)mergedProduct);
        Assert.assertTrue((boolean)mergedProduct.containsBand("A"));
        Assert.assertTrue((boolean)mergedProduct.containsBand("B"));
        Assert.assertTrue((!mergedProduct.containsBand("C") ? 1 : 0) != 0);
    }

    @Test
    public void testMergeOp_includeByNameAndRename() throws Exception {
        Product productA = new Product("dummy1", "mergeOpTest", 10, 10);
        Product productB = new Product("dummy2", "mergeOpTest", 10, 10);
        productA.addBand("A", 30);
        productB.addBand("B", 30);
        productB.addBand("C", 30);
        MergeOp mergeOp = new MergeOp();
        mergeOp.setSourceProduct("masterProduct", productA);
        mergeOp.setSourceProduct("dummy2", productB);
        MergeOp.NodeDescriptor nodeDescriptor = new MergeOp.NodeDescriptor();
        nodeDescriptor.setName("B");
        nodeDescriptor.setNewName("Beeh");
        nodeDescriptor.setProductId("dummy2");
        MergeOp.NodeDescriptor[] nodeDescriptors = new MergeOp.NodeDescriptor[]{nodeDescriptor};
        mergeOp.setParameter("includes", (Object)nodeDescriptors);
        Product mergedProduct = mergeOp.getTargetProduct();
        Assert.assertNotNull((Object)mergedProduct);
        Assert.assertTrue((boolean)mergedProduct.containsBand("A"));
        Assert.assertTrue((boolean)mergedProduct.containsBand("Beeh"));
        Assert.assertTrue((!mergedProduct.containsBand("B") ? 1 : 0) != 0);
        Assert.assertTrue((!mergedProduct.containsBand("C") ? 1 : 0) != 0);
    }

    @Test
    public void testValidateSourceProducts_Failing() throws Exception {
        MergeOp mergeOp = new MergeOp();
        Product productA = new Product("dummy1", "mergeOpTest", 10, 10);
        Product productB = new Product("dummy2", "mergeOpTest", 11, 11);
        mergeOp.setSourceProduct("masterProduct", productA);
        mergeOp.setSourceProduct("dummy2", productB);
        try {
            mergeOp.getTargetProduct();
            Assert.fail();
        }
        catch (OperatorException e) {
            String expectedErrorMessage = "Product .* is not compatible to master product";
            Assert.assertTrue((String)("expected: 'Product .* is not compatible to master product', actual: '" + e.getMessage() + "'"), (boolean)e.getMessage().replace(".", "").matches("Product .* is not compatible to master product"));
        }
    }
}

