/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.common.JaiOp;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public class JaiOpTest
extends TestCase {
    public void testNoSourceGiven() {
        JaiOp op = new JaiOp();
        try {
            op.getTargetProduct();
            JaiOpTest.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    public void testNoJaiOpGiven() {
        Product sourceProduct = this.createSourceProduct();
        JaiOp op = new JaiOp();
        op.setSourceProduct(sourceProduct);
        try {
            op.getTargetProduct();
            JaiOpTest.fail((String)"OperatorException expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    public void testGeometricOperation() {
        Product sourceProduct = this.createSourceProduct();
        Band sourceBand = sourceProduct.getBand("b1");
        this.setSourceImage(sourceBand);
        JaiOp op = new JaiOp();
        op.setOperationName("scale");
        op.setSourceProduct(sourceProduct);
        HashMap<String, Float> operationParameters = new HashMap<String, Float>(3);
        operationParameters.put("xScale", Float.valueOf(2.0f));
        operationParameters.put("yScale", Float.valueOf(2.0f));
        op.setOperationParameters(operationParameters);
        Product targetProduct = op.getTargetProduct();
        JaiOpTest.assertNotNull((Object)targetProduct);
        JaiOpTest.assertEquals((int)2, (int)targetProduct.getNumBands());
        JaiOpTest.assertEquals((int)8, (int)targetProduct.getSceneRasterWidth());
        JaiOpTest.assertEquals((int)8, (int)targetProduct.getSceneRasterHeight());
        Band targetBand = targetProduct.getBand("b1");
        JaiOpTest.assertNotNull((Object)targetBand);
        JaiOpTest.assertEquals((int)targetBand.getDataType(), (int)sourceBand.getDataType());
        JaiOpTest.assertEquals((int)8, (int)targetBand.getRasterWidth());
        JaiOpTest.assertEquals((int)8, (int)targetBand.getRasterHeight());
        MultiLevelImage targetImage = targetBand.getSourceImage();
        JaiOpTest.assertNotNull((Object)targetImage);
        JaiOpTest.assertEquals((int)8, (int)targetImage.getWidth());
        JaiOpTest.assertEquals((int)8, (int)targetImage.getHeight());
        Tile tile = op.getSourceTile((RasterDataNode)targetBand, new Rectangle(0, 0, 8, 8));
        JaiOpTest.assertEquals((int)123, (int)tile.getSampleInt(0, 0));
        JaiOpTest.assertEquals((int)123, (int)tile.getSampleInt(1, 1));
        JaiOpTest.assertEquals((int)234, (int)tile.getSampleInt(2, 2));
        JaiOpTest.assertEquals((int)234, (int)tile.getSampleInt(3, 3));
        JaiOpTest.assertEquals((int)345, (int)tile.getSampleInt(4, 4));
        JaiOpTest.assertEquals((int)345, (int)tile.getSampleInt(5, 5));
        JaiOpTest.assertEquals((int)456, (int)tile.getSampleInt(6, 6));
        JaiOpTest.assertEquals((int)456, (int)tile.getSampleInt(7, 7));
    }

    public void testSampleOperation() {
        Product sourceProduct = this.createSourceProduct();
        Band sourceBand = sourceProduct.getBand("b1");
        this.setSourceImage(sourceBand);
        JaiOp op = new JaiOp();
        op.setOperationName("rescale");
        op.setSourceProduct(sourceProduct);
        HashMap<String, double[]> operationParameters = new HashMap<String, double[]>(3);
        operationParameters.put("constants", new double[]{2.0});
        operationParameters.put("offsets", new double[]{1.0});
        op.setOperationParameters(operationParameters);
        Product targetProduct = op.getTargetProduct();
        JaiOpTest.assertNotNull((Object)targetProduct);
        JaiOpTest.assertEquals((int)2, (int)targetProduct.getNumBands());
        JaiOpTest.assertEquals((int)4, (int)targetProduct.getSceneRasterWidth());
        JaiOpTest.assertEquals((int)4, (int)targetProduct.getSceneRasterHeight());
        Band targetBand = targetProduct.getBand("b1");
        JaiOpTest.assertNotNull((Object)targetBand);
        JaiOpTest.assertEquals((int)targetBand.getDataType(), (int)sourceBand.getDataType());
        JaiOpTest.assertEquals((int)4, (int)targetBand.getRasterWidth());
        JaiOpTest.assertEquals((int)4, (int)targetBand.getRasterHeight());
        MultiLevelImage targetImage = targetBand.getSourceImage();
        JaiOpTest.assertNotNull((Object)targetImage);
        JaiOpTest.assertEquals((int)4, (int)targetImage.getWidth());
        JaiOpTest.assertEquals((int)4, (int)targetImage.getHeight());
        Tile tile = op.getSourceTile((RasterDataNode)targetBand, new Rectangle(0, 0, 4, 4));
        JaiOpTest.assertEquals((int)247, (int)tile.getSampleInt(0, 0));
        JaiOpTest.assertEquals((int)469, (int)tile.getSampleInt(1, 1));
        JaiOpTest.assertEquals((int)691, (int)tile.getSampleInt(2, 2));
        JaiOpTest.assertEquals((int)913, (int)tile.getSampleInt(3, 3));
    }

    private void setSourceImage(Band sourceBand) {
        TiledImage sourceImage = new TiledImage(0, 0, sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), 0, 0, (SampleModel)new SingleBandedSampleModel(3, sourceBand.getRasterWidth(), sourceBand.getRasterHeight()), null);
        sourceImage.setSample(0, 0, 0, 123);
        sourceImage.setSample(1, 1, 0, 234);
        sourceImage.setSample(2, 2, 0, 345);
        sourceImage.setSample(3, 3, 0, 456);
        sourceBand.setSourceImage((RenderedImage)sourceImage);
    }

    private Product createSourceProduct() {
        Product sourceProduct = new Product("sp", "spt", 4, 4);
        sourceProduct.addBand("b1", 12);
        sourceProduct.addTiePointGrid(new TiePointGrid("tpg1", 3, 3, 0.0, 0.0, 2.0, 2.0, new float[]{0.1f, 0.2f, 0.3f, 0.2f, 0.3f, 0.4f, 0.3f, 0.4f, 0.5f}));
        return sourceProduct;
    }

    public void testJaiOperationIntrospection() {
        BufferedImage sourceImage = new BufferedImage(16, 16, 6);
        ParameterBlockJAI params = new ParameterBlockJAI("scale");
        params.setParameter("xScale", 2.0f);
        params.setParameter("yScale", 3.0f);
        params.addSource((Object)sourceImage);
        RenderedOp op = JAI.create((String)"scale", (ParameterBlock)params);
        JaiOpTest.assertEquals((String)"scale", (String)op.getOperationName());
        ParameterBlock parameterBlock = op.getParameterBlock();
        JaiOpTest.assertNotNull((Object)parameterBlock);
        JaiOpTest.assertNotSame((Object)params, (Object)parameterBlock);
        JaiOpTest.assertTrue((boolean)(parameterBlock instanceof ParameterBlockJAI));
        ParameterBlockJAI parameterBlockJAI = (ParameterBlockJAI)op.getParameterBlock();
        OperationDescriptor operationDescriptor = parameterBlockJAI.getOperationDescriptor();
        JaiOpTest.assertNotNull((Object)operationDescriptor);
        JaiOpTest.assertEquals((String)"Scale", (String)operationDescriptor.getName());
        ParameterListDescriptor parameterListDescriptor = operationDescriptor.getParameterListDescriptor("rendered");
        JaiOpTest.assertNotNull((Object)parameterListDescriptor);
        JaiOpTest.assertEquals((int)5, (int)parameterListDescriptor.getNumParameters());
        String[] paramNames = parameterListDescriptor.getParamNames();
        JaiOpTest.assertNotNull((Object)paramNames);
        JaiOpTest.assertEquals((int)5, (int)paramNames.length);
        JaiOpTest.assertEquals((String)"xScale", (String)paramNames[0]);
        JaiOpTest.assertEquals((String)"yScale", (String)paramNames[1]);
        JaiOpTest.assertEquals((String)"xTrans", (String)paramNames[2]);
        JaiOpTest.assertEquals((String)"yTrans", (String)paramNames[3]);
        JaiOpTest.assertEquals((String)"interpolation", (String)paramNames[4]);
        Class[] paramClasses = parameterListDescriptor.getParamClasses();
        JaiOpTest.assertNotNull((Object)paramClasses);
        JaiOpTest.assertEquals((int)5, (int)paramClasses.length);
        JaiOpTest.assertEquals(Float.class, (Object)paramClasses[0]);
        JaiOpTest.assertEquals(Float.class, (Object)paramClasses[1]);
        JaiOpTest.assertEquals(Float.class, (Object)paramClasses[2]);
        JaiOpTest.assertEquals(Float.class, (Object)paramClasses[3]);
        JaiOpTest.assertEquals(Interpolation.class, (Object)paramClasses[4]);
        Object[] paramDefaults = parameterListDescriptor.getParamDefaults();
        JaiOpTest.assertNotNull((Object)paramDefaults);
        JaiOpTest.assertEquals((int)5, (int)paramDefaults.length);
        JaiOpTest.assertEquals((Object)Float.valueOf(1.0f), (Object)paramDefaults[0]);
        JaiOpTest.assertEquals((Object)Float.valueOf(1.0f), (Object)paramDefaults[1]);
        JaiOpTest.assertEquals((Object)Float.valueOf(0.0f), (Object)paramDefaults[2]);
        JaiOpTest.assertEquals((Object)Float.valueOf(0.0f), (Object)paramDefaults[3]);
        JaiOpTest.assertEquals((Object)Interpolation.getInstance((int)0), (Object)paramDefaults[4]);
    }

    public void testJaiOperationParameterChange() {
        BufferedImage sourceImage = new BufferedImage(16, 16, 6);
        ParameterBlockJAI params = new ParameterBlockJAI("scale");
        params.setParameter("xScale", 2.0f);
        params.setParameter("yScale", 3.0f);
        params.addSource((Object)sourceImage);
        RenderedOp renderedOp = JAI.create((String)"scale", (ParameterBlock)params);
        MockPCL mockPCL = new MockPCL();
        renderedOp.addPropertyChangeListener((PropertyChangeListener)mockPCL);
        PlanarImage rendering = renderedOp.getRendering();
        JaiOpTest.assertSame((Object)rendering, (Object)renderedOp.getRendering());
        JaiOpTest.assertTrue((boolean)(rendering instanceof OpImage));
        PlanarImage instance = renderedOp.createInstance();
        JaiOpTest.assertNotSame((Object)instance, (Object)renderedOp);
        JaiOpTest.assertNotSame((Object)instance, (Object)rendering);
        JaiOpTest.assertNotSame((Object)instance, (Object)renderedOp.createInstance());
        JaiOpTest.assertEquals((String)"", (String)mockPCL.trace);
        params = new ParameterBlockJAI("scale");
        params.setParameter("xScale", 0.5f);
        params.setParameter("yScale", 3.3f);
        params.addSource((Object)sourceImage);
        renderedOp.setParameterBlock((ParameterBlock)params);
        JaiOpTest.assertEquals((String)"parameters;rendering;", (String)mockPCL.trace);
        JaiOpTest.assertNotSame((Object)rendering, (Object)renderedOp.getRendering());
        JaiOpTest.assertSame((Object)renderedOp.getRendering(), (Object)renderedOp.getRendering());
    }

    public void testJaiOperationParameterChangeInDAG() {
        BufferedImage sourceImage = new BufferedImage(16, 16, 6);
        ParameterBlockJAI params = new ParameterBlockJAI("scale");
        params.setParameter("xScale", 2.0f);
        params.setParameter("yScale", 3.0f);
        params.addSource((Object)sourceImage);
        RenderedOp renderedOp1 = JAI.create((String)"scale", (ParameterBlock)params);
        params = new ParameterBlockJAI("rescale");
        params.setParameter("offsets", (Object)new double[]{0.5, 0.5, 0.5, 0.5});
        params.setParameter("constants", (Object)new double[]{1.5, 1.5, 1.5, 1.5});
        params.addSource((Object)renderedOp1);
        RenderedOp renderedOp2 = JAI.create((String)"rescale", (ParameterBlock)params);
        MockPCL mockPCL = new MockPCL();
        renderedOp2.addPropertyChangeListener((PropertyChangeListener)mockPCL);
        PlanarImage rendering = renderedOp2.getRendering();
        JaiOpTest.assertSame((Object)rendering, (Object)renderedOp2.getRendering());
        JaiOpTest.assertTrue((boolean)(rendering instanceof OpImage));
        params = new ParameterBlockJAI("scale");
        params.setParameter("xScale", 0.5f);
        params.setParameter("yScale", 3.3f);
        params.addSource((Object)sourceImage);
        renderedOp1.setParameterBlock((ParameterBlock)params);
        JaiOpTest.assertEquals((String)"rendering;", (String)mockPCL.trace);
        JaiOpTest.assertNotSame((Object)mockPCL.lastNewValue, (Object)mockPCL.lastOldValue);
        JaiOpTest.assertEquals((Object)rendering, (Object)mockPCL.lastOldValue);
        JaiOpTest.assertEquals((Object)renderedOp2.getRendering(), (Object)mockPCL.lastNewValue);
    }

    private static class MockPCL
    implements PropertyChangeListener {
        String trace = "";
        Object lastOldValue;
        Object lastNewValue;

        private MockPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.trace = this.trace + evt.getPropertyName() + ";";
            this.lastOldValue = evt.getOldValue();
            this.lastNewValue = evt.getNewValue();
        }
    }
}

