/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.annotations;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.gpf.annotations.TestPojo;

public class TestPojoTest
extends TestCase {
    private Class<? extends TestPojo> testPojoClass;

    public void setUp() {
        TestPojo testPojo = new TestPojo();
        this.testPojoClass = testPojo.getClass();
    }

    public void testTargetProductAnnotation() throws NoSuchFieldException {
        Field vapourField = this.testPojoClass.getDeclaredField("vapour");
        TargetProduct tpa = vapourField.getAnnotation(TargetProduct.class);
        TestPojoTest.assertNotNull((Object)tpa);
    }

    public void testSourceProductAnnotation() throws NoSuchFieldException {
        Field brrField = this.testPojoClass.getDeclaredField("brr");
        SourceProduct spa = brrField.getAnnotation(SourceProduct.class);
        TestPojoTest.assertNotNull((Object)spa);
        TestPojoTest.assertEquals((boolean)true, (boolean)spa.optional());
        TestPojoTest.assertEquals((String)"MERIS_BRR", (String)spa.type());
        TestPojoTest.assertEquals((int)2, (int)spa.bands().length);
        TestPojoTest.assertEquals((String)"radiance_2", (String)spa.bands()[0]);
        TestPojoTest.assertEquals((String)"radiance_5", (String)spa.bands()[1]);
    }

    public void testParameterAnnotation() throws NoSuchFieldException {
        Field percentage = this.testPojoClass.getDeclaredField("percentage");
        Parameter pa = percentage.getAnnotation(Parameter.class);
        TestPojoTest.assertNotNull((Object)pa);
        TestPojoTest.assertEquals((String)"(0, 100]", (String)pa.interval());
    }

    public void testTargetPropertyAnnotation() throws NoSuchFieldException {
        Field propertyField = this.testPojoClass.getDeclaredField("property");
        TargetProperty tpa = propertyField.getAnnotation(TargetProperty.class);
        TestPojoTest.assertNotNull((Object)tpa);
        TestPojoTest.assertEquals((String)"a test property", (String)tpa.description());
        TestPojoTest.assertEquals((String)"bert", (String)tpa.alias());
    }
}

