/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.annotations;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import java.util.Map;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.ParameterBlockConverter;
import org.junit.Assert;
import org.junit.Test;

public class ParameterBlockConverterTest {
    @Test
    public void testSimpleStruct() throws ConversionException, ValidationException {
        ParameterBlockConverter converter = new ParameterBlockConverter();
        String xml = converter.convertObjectToXml((Object)new SimpleStruct("LM", 0.23));
        Assert.assertEquals((Object)"<parameters>\n  <algorithm>LM</algorithm>\n  <threshold>0.23</threshold>\n</parameters>", (Object)xml);
        Map map = converter.convertXmlToMap(xml, SimpleStruct.class);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)"LM", map.get("algorithm"));
        Assert.assertEquals((double)0.23, (double)((Double)map.get("threshold")), (double)0.0);
    }

    public static class SimpleStruct {
        @Parameter
        String algorithm;
        @Parameter
        double threshold;

        public SimpleStruct(String algorithm, double threshold) {
            this.algorithm = algorithm;
            this.threshold = threshold;
        }
    }
}

