/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.junit.Assert;
import org.junit.Test;

public class OperatorTest {
    @Test
    public void testBasicOperatorStatesWithExecute() throws OperatorException, IOException {
        FooExecOp op = new FooExecOp();
        Assert.assertNotNull((Object)op.getSpi());
        Assert.assertFalse((boolean)op.initializeCalled);
        Assert.assertFalse((boolean)op.runCalled);
        op.execute(ProgressMonitor.NULL);
        Assert.assertTrue((boolean)op.initializeCalled);
        Assert.assertTrue((boolean)op.runCalled);
        Product product = op.getTargetProduct();
        Assert.assertNotNull((Object)product);
    }

    @Test
    public void testBasicOperatorStatesWithTile() throws OperatorException, IOException {
        FooTileOp op = new FooTileOp();
        Assert.assertNotNull((Object)op.getSpi());
        Assert.assertFalse((boolean)op.initializeCalled);
        Assert.assertFalse((boolean)op.runCalled);
        Assert.assertFalse((boolean)op.computeTileCalled);
        Product product = op.getTargetProduct();
        Assert.assertTrue((boolean)op.initializeCalled);
        Assert.assertFalse((boolean)op.runCalled);
        Assert.assertFalse((boolean)op.computeTileCalled);
        Assert.assertNotNull((Object)product);
        Assert.assertFalse((boolean)product.isModified());
        product.getBand("bar").readRasterDataFully(ProgressMonitor.NULL);
        Assert.assertTrue((boolean)op.initializeCalled);
        Assert.assertTrue((boolean)op.runCalled);
        Assert.assertTrue((boolean)op.computeTileCalled);
    }

    @Test
    public void testBasicOperatorStatesWithTileStack() throws OperatorException, IOException {
        FooTileStackOp op = new FooTileStackOp();
        Assert.assertNotNull((Object)op.getSpi());
        Assert.assertFalse((boolean)op.initializeCalled);
        Assert.assertFalse((boolean)op.runCalled);
        Assert.assertFalse((boolean)op.computeTileStackCalled);
        Product product = op.getTargetProduct();
        Assert.assertTrue((boolean)op.initializeCalled);
        Assert.assertFalse((boolean)op.runCalled);
        Assert.assertFalse((boolean)op.computeTileStackCalled);
        Assert.assertNotNull((Object)product);
        Assert.assertFalse((boolean)product.isModified());
        product.getBand("bar").readRasterDataFully(ProgressMonitor.NULL);
        Assert.assertTrue((boolean)op.initializeCalled);
        Assert.assertTrue((boolean)op.runCalled);
        Assert.assertTrue((boolean)op.computeTileStackCalled);
    }

    @Test
    public void testThatGetTargetProductMustNotBeCalledFromInitialize() {
        Operator op = new Operator(){

            public void initialize() throws OperatorException {
                this.getTargetProduct();
            }
        };
        try {
            op.getTargetProduct();
            Assert.fail((String)"RuntimeException expected: Operator shall not allow calling getTargetProduct() from within initialize().");
        }
        catch (OperatorException ignored) {
            Assert.fail((String)"RuntimeException expected: Operator shall not allow calling getTargetProduct() from within initialize().");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSourceProducts() throws IOException, OperatorException {
        Operator operator = new Operator(){

            public void initialize() throws OperatorException {
            }
        };
        Product sp1 = new Product("sp1", "t", 1, 1);
        Product sp2 = new Product("sp2", "t", 1, 1);
        Product sp3 = new Product("sp3", "t", 1, 1);
        operator.setSourceProduct(sp1);
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct());
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct"));
        operator.setSourceProduct("sp1", sp1);
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct());
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sp1"));
        Product[] products = operator.getSourceProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)1L, (long)products.length);
        Assert.assertSame((Object)sp1, (Object)products[0]);
        operator.setSourceProduct("sp2", sp2);
        products = operator.getSourceProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)2L, (long)products.length);
        Assert.assertSame((Object)sp1, (Object)products[0]);
        Assert.assertSame((Object)sp2, (Object)products[1]);
        operator.setSourceProducts(new Product[]{sp3, sp2, sp1});
        Assert.assertNull((Object)operator.getSourceProduct("sourceProduct"));
        Assert.assertNull((Object)operator.getSourceProduct("sp1"));
        Assert.assertNull((Object)operator.getSourceProduct("sp2"));
        products = operator.getSourceProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)3L, (long)products.length);
        Assert.assertSame((Object)sp3, (Object)products[0]);
        Assert.assertSame((Object)sp2, (Object)products[1]);
        Assert.assertSame((Object)sp1, (Object)products[2]);
        Assert.assertSame((Object)sp3, (Object)operator.getSourceProduct("sourceProduct.1"));
        Assert.assertSame((Object)sp3, (Object)operator.getSourceProduct("sourceProduct1"));
        Assert.assertSame((Object)sp2, (Object)operator.getSourceProduct("sourceProduct.2"));
        Assert.assertSame((Object)sp2, (Object)operator.getSourceProduct("sourceProduct2"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct.3"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct3"));
        Assert.assertEquals((Object)"sourceProduct.3", (Object)operator.getSourceProductId(sp1));
        Assert.assertEquals((Object)"sourceProduct.2", (Object)operator.getSourceProductId(sp2));
        Assert.assertEquals((Object)"sourceProduct.1", (Object)operator.getSourceProductId(sp3));
        operator.setSourceProducts(new Product[]{sp1, sp2, sp1});
        products = operator.getSourceProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)2L, (long)products.length);
        Assert.assertSame((Object)sp1, (Object)products[0]);
        Assert.assertSame((Object)sp2, (Object)products[1]);
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct.1"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct1"));
        Assert.assertSame((Object)sp2, (Object)operator.getSourceProduct("sourceProduct.2"));
        Assert.assertSame((Object)sp2, (Object)operator.getSourceProduct("sourceProduct2"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct.3"));
        Assert.assertSame((Object)sp1, (Object)operator.getSourceProduct("sourceProduct3"));
        Assert.assertEquals((Object)"sourceProduct.1", (Object)operator.getSourceProductId(sp1));
        Assert.assertEquals((Object)"sourceProduct.2", (Object)operator.getSourceProductId(sp2));
        Assert.assertNull((Object)operator.getSourceProductId(sp3));
    }

    private static Product createFooProduct() {
        Product product = new Product("foo", "grunt", 1, 1);
        product.addBand("bar", 31);
        return product;
    }

    @Test
    public void testThatProductManagerIsAvailableAndRemainsSame() throws OperatorException, IOException {
        FooExecOp op = new FooExecOp();
        ProductManager productManager = op.getProductManager();
        Assert.assertNotNull((Object)productManager);
        Assert.assertSame((Object)productManager, (Object)op.getProductManager());
        op.getTargetProduct();
        Assert.assertSame((Object)productManager, (Object)op.getProductManager());
        FooExecOp op2 = new FooExecOp();
        Assert.assertSame((Object)productManager, (Object)op2.getProductManager());
    }

    @Test
    public void testEnsureSceneGeoCoding() {
        FooExecOp op = new FooExecOp();
        Product source = new Product("sp1", "t", 36, 18);
        try {
            op.ensureSceneGeoCoding(new Product[]{source});
            Assert.fail((String)"No geo-coding exception expected");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"Source product 'sp1' must be geo-coded.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEnsureSingleSize_0_Products() {
        FooExecOp op = new FooExecOp();
        Assert.assertEquals(null, (Object)op.ensureSingleRasterSize(new Product[0]));
    }

    @Test
    public void testEnsureSingleSize_1_Product_S() {
        FooExecOp op = new FooExecOp();
        Product source = new Product("sp1", "t", 36, 18);
        source.addBand(new Band("b1", 10, 36, 18));
        source.addBand(new Band("b2", 10, 36, 18));
        Assert.assertEquals((Object)new Dimension(36, 18), (Object)op.ensureSingleRasterSize(new Product[]{source}));
    }

    @Test
    public void testEnsureSingleSize_1_Product_M() {
        FooExecOp op = new FooExecOp();
        Product source = new Product("sp1", "t", 36, 18);
        source.addBand(new Band("b1", 10, 36, 18));
        source.addBand(new Band("b2", 10, 18, 9));
        try {
            op.ensureSingleRasterSize(new Product[]{source});
            Assert.fail((String)"Multi-size exception expected");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"Source product 'sp1' contains rasters of different sizes and can not be processed.\nPlease consider resampling it so that all rasters have the same size.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEnsureSingleSize_N_Product_M() {
        FooExecOp op = new FooExecOp();
        Product source1 = new Product("sp1", "t", 36, 18);
        source1.addBand(new Band("b1", 10, 36, 18));
        source1.addBand(new Band("b2", 10, 36, 18));
        Product source2 = new Product("sp2", "t", 18, 9);
        source2.addBand(new Band("b1", 10, 18, 9));
        source2.addBand(new Band("b2", 10, 18, 9));
        try {
            op.ensureSingleRasterSize(new Product[]{source1, source2});
            Assert.fail((String)"Multi-size exception expected");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"All source products must have the same raster size of 36 x 18 pixels.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEnsureSingleSize_0_Rasters() {
        FooExecOp op = new FooExecOp();
        Assert.assertEquals(null, (Object)op.ensureSingleRasterSize(new RasterDataNode[0]));
    }

    @Test
    public void testEnsureSingleSize_N_Rasters() {
        FooExecOp op = new FooExecOp();
        Band b1 = new Band("b1", 10, 36, 18);
        Band b2 = new Band("b2", 10, 36, 18);
        Band b3 = new Band("b3", 10, 18, 9);
        Assert.assertEquals((Object)new Dimension(36, 18), (Object)op.ensureSingleRasterSize(new RasterDataNode[]{b1}));
        Assert.assertEquals((Object)new Dimension(36, 18), (Object)op.ensureSingleRasterSize(new RasterDataNode[]{b1, b2}));
        try {
            op.ensureSingleRasterSize(new RasterDataNode[]{b1, b2, b3});
            Assert.fail((String)"Multi-size exception expected");
        }
        catch (OperatorException e) {
            Assert.assertEquals((Object)"All source rasters must have the same size of 36 x 18 pixels.", (Object)e.getMessage());
        }
    }

    private static class FooTileStackOp
    extends Operator {
        private boolean initializeCalled;
        private boolean runCalled;
        private boolean computeTileStackCalled;
        @TargetProduct
        private Product targetProduct;

        private FooTileStackOp() {
        }

        public void initialize() throws OperatorException {
            this.initializeCalled = true;
            this.targetProduct = OperatorTest.createFooProduct();
            this.targetProduct.addBand("foo", 10);
        }

        public void doExecute(ProgressMonitor pm) {
            this.runCalled = true;
        }

        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
            this.computeTileStackCalled = true;
        }
    }

    private static class FooTileOp
    extends Operator {
        private boolean initializeCalled;
        private boolean runCalled;
        private boolean computeTileCalled;
        @TargetProduct
        private Product targetProduct;

        private FooTileOp() {
        }

        public void initialize() throws OperatorException {
            this.initializeCalled = true;
            this.targetProduct = OperatorTest.createFooProduct();
            this.targetProduct.addBand("foo", 10);
        }

        public void doExecute(ProgressMonitor pm) {
            this.runCalled = true;
        }

        public void computeTile(Band band, Tile tile, ProgressMonitor pm) throws OperatorException {
            this.computeTileCalled = true;
        }
    }

    private static class FooExecOp
    extends Operator {
        private boolean initializeCalled;
        private boolean runCalled;
        @TargetProduct
        private Product targetProduct;

        private FooExecOp() {
        }

        public void initialize() throws OperatorException {
            this.initializeCalled = true;
            this.targetProduct = OperatorTest.createFooProduct();
            this.targetProduct.addBand("foo", 10);
        }

        public void doExecute(ProgressMonitor pm) {
            this.runCalled = true;
        }
    }
}

