/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.TargetProperty;

public class OpWithTargetPropertyTest
extends TestCase {
    public void testTargetPropertyIsComputedDuringOpInitialisation() {
        PropertyOp op = new PropertyOp();
        Object targetProperty = op.getTargetProperty("theAnswer");
        OpWithTargetPropertyTest.assertNotNull((Object)targetProperty);
        OpWithTargetPropertyTest.assertEquals((Object)42, (Object)targetProperty);
    }

    public void testWrongPropertyOp() {
        IllegalPropertyOp op = new IllegalPropertyOp();
        try {
            op.getTargetProperty("theAnswer");
            OpWithTargetPropertyTest.fail((String)"duplicated property name error expected");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    public static class IllegalPropertyOp
    extends Operator {
        @TargetProperty
        int theAnswer;
        @TargetProperty(alias="theAnswer")
        double anotherAnswer;

        public void initialize() throws OperatorException {
            this.theAnswer = 42;
            this.setTargetProduct(new Product("A", "AT", 10, 10));
        }
    }

    public static class PropertyOp
    extends Operator {
        @TargetProperty
        int theAnswer;

        public void initialize() throws OperatorException {
            this.theAnswer = 42;
            this.setTargetProduct(new Product("A", "AT", 10, 10));
        }
    }
}

