/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

public class OpProductPassThroughTest
extends TestCase {
    public void testUpdateOnGpfBandOp() throws Exception {
        this.testOp(new GpfBandOp());
    }

    public void testUpdateOnJaiBandOp() throws Exception {
        this.testOp(new JaiBandOp());
    }

    private void testOp(Op op) {
        Product sourceProduct = new Product("test", "test", 10, 10);
        op.setSourceProduct(sourceProduct);
        op.bandName = "A";
        op.sampleValue = 0.5f;
        Product targetProduct = op.getTargetProduct();
        OpProductPassThroughTest.assertSame((Object)targetProduct, (Object)sourceProduct);
        OpProductPassThroughTest.assertNotNull((Object)targetProduct.getBand("A"));
        OpProductPassThroughTest.assertEquals((Object)Float.valueOf(0.5f), (Object)Float.valueOf(targetProduct.getBand("A").getSourceImage().getData().getSampleFloat(0, 0, 0)));
        op.sampleValue = -0.6f;
        op.update();
        Product targetProduct2 = op.getTargetProduct();
        OpProductPassThroughTest.assertSame((Object)targetProduct2, (Object)targetProduct);
        OpProductPassThroughTest.assertNotNull((Object)targetProduct2.getBand("A"));
        OpProductPassThroughTest.assertEquals((Object)Float.valueOf(-0.6f), (Object)Float.valueOf(targetProduct2.getBand("A").getSourceImage().getData().getSampleFloat(0, 0, 0)));
    }

    public static class GpfBandOp
    extends Op {
        public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            if (targetBand == this.band) {
                Arrays.fill(targetTile.getDataBufferFloat(), this.sampleValue);
            }
        }
    }

    public static class JaiBandOp
    extends Op {
        @Override
        public void initialize() throws OperatorException {
            super.initialize();
            this.band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(this.targetProduct.getSceneRasterWidth()), (Float)Float.valueOf(this.targetProduct.getSceneRasterHeight()), (Number[])new Float[]{Float.valueOf(this.sampleValue)}, null));
        }
    }

    public static class Op
    extends Operator {
        @SourceProduct
        Product sourceProduct;
        @TargetProduct
        Product targetProduct;
        @Parameter
        String bandName;
        @Parameter
        float sampleValue;
        Band band;

        public void initialize() throws OperatorException {
            this.targetProduct = this.sourceProduct;
            if (this.band == null) {
                this.band = this.targetProduct.addBand(this.bandName, 30);
            }
        }
    }
}

