/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.TargetProduct;

public class OpDirectInstantiationTest
extends TestCase {
    public void testDirectInstantiation() throws IOException, OperatorException {
        Product a = new Product("a", "T", 2, 2);
        a.addBand((Band)new VirtualBand("x", 31, 2, 2, "5.2"));
        Product b = new Product("b", "T", 2, 2);
        b.addBand((Band)new VirtualBand("x", 31, 2, 2, "4.8"));
        AddOp op1 = new AddOp(a, b);
        Product p1 = op1.getTargetProduct();
        MulConstOp op2 = new MulConstOp(p1, 2.5);
        Product product = op2.getTargetProduct();
        Band xBand = product.getBand("x");
        ProductData rasterData = xBand.createCompatibleRasterData();
        xBand.readRasterData(0, 0, 2, 2, rasterData, ProgressMonitor.NULL);
        OpDirectInstantiationTest.assertEquals((double)25.0, (double)rasterData.getElemDoubleAt(0), (double)1.0E-10);
        OpDirectInstantiationTest.assertEquals((double)25.0, (double)rasterData.getElemDoubleAt(1), (double)1.0E-10);
        OpDirectInstantiationTest.assertEquals((double)25.0, (double)rasterData.getElemDoubleAt(2), (double)1.0E-10);
        OpDirectInstantiationTest.assertEquals((double)25.0, (double)rasterData.getElemDoubleAt(3), (double)1.0E-10);
    }

    private static class AddOp
    extends Operator {
        private Product sourceProduct1;
        private Product sourceProduct2;
        @TargetProduct
        private Product targetProduct;

        public AddOp(Product sourceProduct1, Product sourceProduct2) {
            this.sourceProduct1 = sourceProduct1;
            this.sourceProduct2 = sourceProduct2;
        }

        public void initialize() throws OperatorException {
            Band[] bands;
            this.targetProduct = new Product(this.sourceProduct1.getName() + "_Add", this.sourceProduct1.getProductType(), this.sourceProduct1.getSceneRasterWidth(), this.sourceProduct1.getSceneRasterHeight());
            for (Band sourceBand : bands = this.sourceProduct1.getBands()) {
                this.targetProduct.addBand(sourceBand.getName(), sourceBand.getDataType());
            }
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            Band sourceBand1 = this.sourceProduct1.getBand(band.getName());
            Band sourceBand2 = this.sourceProduct2.getBand(band.getName());
            Tile sourceTile1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTile.getRectangle());
            Tile sourceTile2 = this.getSourceTile((RasterDataNode)sourceBand2, targetTile.getRectangle());
            for (int y = 0; y < targetTile.getHeight(); ++y) {
                for (int x = 0; x < targetTile.getWidth(); ++x) {
                    targetTile.setSample(x, y, sourceTile1.getSampleDouble(x, y) + sourceTile2.getSampleDouble(x, y));
                }
            }
        }
    }

    private static class MulConstOp
    extends Operator {
        private Product sourceProduct;
        @TargetProduct
        private Product targetProduct;
        @Parameter(defaultValue="100")
        private double factor;

        public MulConstOp(Product sourceProduct, double factor) {
            this.sourceProduct = sourceProduct;
            this.factor = factor;
        }

        public double getFactor() {
            return this.factor;
        }

        public void setFactor(double factor) {
            this.factor = factor;
        }

        public void initialize() throws OperatorException {
            Band[] bands;
            this.targetProduct = new Product(this.sourceProduct.getName() + "_MulConst", this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            for (Band sourceBand : bands = this.sourceProduct.getBands()) {
                this.targetProduct.addBand(sourceBand.getName(), sourceBand.getDataType());
            }
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            Band sourceBand = this.sourceProduct.getBand(band.getName());
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
            for (int y = 0; y < targetTile.getHeight(); ++y) {
                for (int x = 0; x < targetTile.getWidth(); ++x) {
                    targetTile.setSample(x, y, sourceTile.getSampleDouble(x, y) * this.factor);
                }
            }
        }
    }
}

