/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.SourceProduct;

public class OpDealingWithVirtualBandTest
extends TestCase {
    public void testUseVirtualBandInTargetProduct_SingleTile() throws IOException {
        this.testUseVirtualBandInTargetProduct(new UseVirtualBandInTargetProductOp_SingleTile(2, 3));
    }

    public void testUseVirtualBandInTargetProduct_TileStack() throws IOException {
        this.testUseVirtualBandInTargetProduct(new UseVirtualBandInTargetProductOp_TileStack(2, 3));
    }

    private void testUseVirtualBandInTargetProduct(Operator op) throws IOException {
        Product p = op.getTargetProduct();
        Band c = p.getBand("C");
        ProductData rc = c.createCompatibleRasterData();
        c.readRasterData(0, 0, 2, 3, rc, ProgressMonitor.NULL);
        this.assert_a_times_b_is_c(rc, 0, 0, 0);
        this.assert_a_times_b_is_c(rc, 1, 1, 0);
        this.assert_a_times_b_is_c(rc, 2, 0, 1);
        this.assert_a_times_b_is_c(rc, 3, 1, 1);
        this.assert_a_times_b_is_c(rc, 4, 0, 2);
        this.assert_a_times_b_is_c(rc, 5, 1, 2);
        AbcPullerOp op2 = new AbcPullerOp(op.getTargetProduct());
        Product p2 = op2.getTargetProduct();
        Band d = p2.getBand("D");
        ProductData rd = d.createCompatibleRasterData();
        d.readRasterData(0, 0, 2, 3, rd, ProgressMonitor.NULL);
        this.assert_a_plus_b_plus_c_is_d(rd, 0, 0, 0);
        this.assert_a_plus_b_plus_c_is_d(rd, 1, 1, 0);
        this.assert_a_plus_b_plus_c_is_d(rd, 2, 0, 1);
        this.assert_a_plus_b_plus_c_is_d(rd, 3, 1, 1);
        this.assert_a_plus_b_plus_c_is_d(rd, 4, 0, 2);
        this.assert_a_plus_b_plus_c_is_d(rd, 5, 1, 2);
    }

    private void assert_a_times_b_is_c(ProductData r, int i, int x, int y) {
        int a = 2 * x + 4 * y;
        int b = 3 * x + 5 * y;
        int c = a * b;
        OpDealingWithVirtualBandTest.assertEquals((String)("i=" + i), (int)c, (int)r.getElemIntAt(i));
    }

    private void assert_a_plus_b_plus_c_is_d(ProductData r, int i, int x, int y) {
        int a = 2 * x + 4 * y;
        int b = 3 * x + 5 * y;
        int c = a * b;
        int d = a + b + c;
        OpDealingWithVirtualBandTest.assertEquals((String)("i=" + i), (int)d, (int)r.getElemIntAt(i));
    }

    public static class AbcPullerOp
    extends Operator {
        @SourceProduct
        Product sourceProduct;

        public AbcPullerOp(Product sourceProduct) {
            this.sourceProduct = sourceProduct;
        }

        public void initialize() throws OperatorException {
            int w = this.sourceProduct.getSceneRasterWidth();
            int h = this.sourceProduct.getSceneRasterHeight();
            Product product = new Product("X", "Y", w, h);
            product.addBand(new Band("D", 12, w, h));
            this.setTargetProduct(product);
        }

        public void computeTile(Band targetBand, Tile tileD, ProgressMonitor pm) throws OperatorException {
            Tile tileA = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("A"), tileD.getRectangle());
            Tile tileB = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("B"), tileD.getRectangle());
            Tile tileC = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("C"), tileD.getRectangle());
            for (Tile.Pos p : tileD) {
                int a = tileA.getSampleInt(p.x, p.y);
                int b = tileB.getSampleInt(p.x, p.y);
                int c = tileC.getSampleInt(p.x, p.y);
                tileD.setSample(p.x, p.y, a + b + c);
            }
        }
    }

    public static class UseVirtualBandInTargetProductOp_TileStack
    extends UseVirtualBandInTargetProductOp {
        public UseVirtualBandInTargetProductOp_TileStack(int w, int h) {
            super(w, h);
        }

        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
            Tile tileA = targetTiles.get(this.getTargetProduct().getBand("A"));
            Tile tileB = targetTiles.get(this.getTargetProduct().getBand("B"));
            Tile tileC = targetTiles.get(this.getTargetProduct().getBand("C"));
            TestCase.assertNotNull((Object)tileA);
            TestCase.assertNotNull((Object)tileB);
            TestCase.assertNull((Object)tileC);
            for (Tile.Pos p : tileA) {
                int a = 2 * p.x + 4 * p.y;
                tileA.setSample(p.x, p.y, a);
            }
            for (Tile.Pos p : tileB) {
                int b = 3 * p.x + 5 * p.y;
                tileB.setSample(p.x, p.y, b);
            }
        }
    }

    public static class UseVirtualBandInTargetProductOp_SingleTile
    extends UseVirtualBandInTargetProductOp {
        public UseVirtualBandInTargetProductOp_SingleTile(int w, int h) {
            super(w, h);
        }

        public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            if (targetBand.getName().equals("A")) {
                for (Tile.Pos p : targetTile) {
                    int a = 2 * p.x + 4 * p.y;
                    targetTile.setSample(p.x, p.y, a);
                }
            } else if (targetBand.getName().equals("B")) {
                for (Tile.Pos p : targetTile) {
                    int b = 3 * p.x + 5 * p.y;
                    targetTile.setSample(p.x, p.y, b);
                }
            } else {
                TestCase.fail((String)(((Object)((Object)this)).getClass().getName() + ": computeTile() illegally called for band " + targetBand.getName()));
            }
        }
    }

    public static abstract class UseVirtualBandInTargetProductOp
    extends Operator {
        private final int w;
        private final int h;

        protected UseVirtualBandInTargetProductOp(int w, int h) {
            this.w = w;
            this.h = h;
        }

        public void initialize() throws OperatorException {
            Product product = new Product("X", "Y", this.w, this.h);
            product.addBand(new Band("A", 12, this.w, this.h));
            product.addBand(new Band("B", 12, this.w, this.h));
            product.addBand((Band)new VirtualBand("C", 12, this.w, this.h, "A*B"));
            this.setTargetProduct(product);
        }
    }
}

