/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import java.io.IOException;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

public class InheritedOperatorTest
extends TestCase {
    public void testBasicOperatorStates() throws OperatorException, IOException {
        Product sourceProduct = new Product("test", "test", 10, 10);
        DerivedOp op = new DerivedOp();
        op.setSourceProduct(sourceProduct);
        op.setParameter("canExplode", true);
        Product targetProduct = op.getTargetProduct();
        InheritedOperatorTest.assertSame((Object)targetProduct, (Object)sourceProduct);
        InheritedOperatorTest.assertEquals((boolean)true, (boolean)op.canExplode);
    }

    private static class DerivedOp
    extends BaseOp {
        private DerivedOp() {
        }

        @Override
        public void initialize() throws OperatorException {
            super.initialize();
        }
    }

    private static class BaseOp
    extends Operator {
        @SourceProduct
        Product sourceProduct;
        @TargetProduct
        Product targetProduct;
        @Parameter
        boolean canExplode;

        private BaseOp() {
        }

        public void initialize() throws OperatorException {
            this.targetProduct = this.sourceProduct;
        }
    }
}

