/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GPFFacadeTest {
    private static FooOpSpi foo = new FooOpSpi();
    private static FoosOpSpi foos = new FoosOpSpi();

    @BeforeClass
    public static void loadSpis() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)foo);
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)foos);
    }

    @AfterClass
    public static void unloadSpis() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)foo);
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)foos);
    }

    @Test
    public void testDefaultSettings() {
        GPF gpf = GPF.getDefaultInstance();
        Assert.assertNotNull((Object)gpf);
        Assert.assertSame((Object)gpf, (Object)GPF.getDefaultInstance());
    }

    @Test
    public void testAutoParameterConversion() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        FooOp fooOp = this.makeFooOp(parameters);
        Assert.assertEquals((long)0L, (long)fooOp.intParam);
        Assert.assertEquals((double)0.0, (double)fooOp.doubleParam, (double)1.0E-7);
        Assert.assertEquals(null, (Object)fooOp.floatArrayParam);
        Assert.assertEquals(null, (Object)fooOp.stringParam);
        Assert.assertEquals((Object)false, (Object)fooOp.booleanParam);
        parameters = new HashMap();
        parameters.put("intParam", 44);
        parameters.put("doubleParam", 0.441);
        parameters.put("floatArrayParam", new float[]{0.2f, 0.4f, 0.8f});
        parameters.put("stringParam", "Banana");
        parameters.put("booleanParam", true);
        fooOp = this.makeFooOp(parameters);
        Assert.assertEquals((long)44L, (long)fooOp.intParam);
        Assert.assertEquals((double)0.441, (double)fooOp.doubleParam, (double)1.0E-7);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{0.2f, 0.4f, 0.8f}, fooOp.floatArrayParam));
        Assert.assertEquals((Object)"Banana", (Object)fooOp.stringParam);
        Assert.assertEquals((Object)true, (Object)fooOp.booleanParam);
        parameters.put("intParam", "42");
        parameters.put("doubleParam", "0.421");
        parameters.put("floatArrayParam", "0.1, 0.2, 0.5");
        parameters.put("stringParam", "Mexico");
        parameters.put("booleanParam", "1");
        fooOp = this.makeFooOp(parameters);
        Assert.assertEquals((long)42L, (long)fooOp.intParam);
        Assert.assertEquals((double)0.421, (double)fooOp.doubleParam, (double)1.0E-7);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{0.1f, 0.2f, 0.5f}, fooOp.floatArrayParam));
        Assert.assertEquals((Object)"Mexico", (Object)fooOp.stringParam);
        Assert.assertEquals((Object)true, (Object)fooOp.booleanParam);
    }

    private FooOp makeFooOp(Map<String, Object> parameters) {
        Product p1 = new Product("A", "B", 16, 16);
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>();
        sourceProducts.put("sourceProduct", p1);
        FooOp fooOp = (FooOp)GPF.getDefaultInstance().createOperator("Foo", parameters, sourceProducts, null);
        fooOp.getTargetProduct();
        return fooOp;
    }

    @Test
    public void testOperatorApi() throws IOException, OperatorException, URISyntaxException {
        String filePath = GPFFacadeTest.class.getResource("test-product.dim").toURI().getPath();
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("file", new File(filePath));
        Product p1 = GPF.createProduct((String)"Read", parameters);
        Assert.assertNotNull((Object)p1);
        Assert.assertNotNull((Object)p1.getBand("forrest_abundance"));
        Assert.assertNotNull((Object)p1.getBand("ocean_abundance"));
        Assert.assertNotNull((Object)p1.getBand("cloud_abundance"));
        Assert.assertNotNull((Object)p1.getBand("cropland_abundance"));
        Assert.assertNotNull((Object)p1.getFileLocation());
        Assert.assertEquals((Object)"test-product.dim", (Object)p1.getFileLocation().getName());
        Product p2 = GPF.createProduct((String)"Foo", (Map)GPF.NO_PARAMS, (Product)p1);
        Assert.assertNotNull((Object)p2);
        Assert.assertNotNull((Object)p2.getBand("forrest_abundance"));
        Assert.assertNotNull((Object)p2.getBand("ocean_abundance"));
        Assert.assertNotNull((Object)p2.getBand("cloud_abundance"));
        Assert.assertNotNull((Object)p2.getBand("cropland_abundance"));
        Band band = p2.getBand("ocean_abundance");
        band.readRasterDataFully(ProgressMonitor.NULL);
        ProductData rasterData = band.getRasterData();
        for (int i = 0; i < rasterData.getNumElems(); ++i) {
            Assert.assertTrue((rasterData.getElemFloatAt(i) >= 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((rasterData.getElemFloatAt(i) <= 1.0f ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProductName() throws Exception {
        String filePath = GPFFacadeTest.class.getResource("test-product.dim").toURI().getPath();
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("file", new File(filePath));
        Product p1 = GPF.createProduct((String)"Read", parameters);
        Product p2 = GPF.createProduct((String)"Foo", (Map)GPF.NO_PARAMS, (Product[])new Product[]{p1});
        MetadataElement metadataElement = p2.getMetadataRoot().getElement("Processing_Graph");
        MetadataElement sourceElement = null;
        for (MetadataElement element : metadataElement.getElements()) {
            if (!element.getAttribute("operator").getData().getElemString().equals("Foo")) continue;
            sourceElement = element.getElement("sources");
            break;
        }
        Assert.assertNotNull(sourceElement);
        Assert.assertEquals((long)1L, (long)sourceElement.getNumAttributes());
        Assert.assertEquals((Object)"sourceProduct", (Object)sourceElement.getAttributeAt(0).getName());
        Assert.assertTrue((boolean)sourceElement.getAttributeAt(0).getData().getElemString().endsWith("test-product.dim"));
    }

    @Test
    public void testMultiProductsNames() throws Exception {
        String filePath = GPFFacadeTest.class.getResource("test-product.dim").toURI().getPath();
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("file", new File(filePath));
        Product p1 = GPF.createProduct((String)"Read", parameters);
        Product p2 = GPF.createProduct((String)"Foo", (Map)GPF.NO_PARAMS, (Product[])new Product[]{p1});
        Product p3 = GPF.createProduct((String)"Foos", (Map)GPF.NO_PARAMS, (Product[])new Product[]{p1, p2});
        MetadataElement metadataElement = p3.getMetadataRoot().getElement("Processing_Graph");
        MetadataElement sourceElement = null;
        for (MetadataElement element : metadataElement.getElements()) {
            if (!element.getAttribute("operator").getData().getElemString().equals("Foos")) continue;
            sourceElement = element.getElement("sources");
            break;
        }
        Assert.assertNotNull(sourceElement);
        Assert.assertEquals((long)2L, (long)sourceElement.getNumAttributes());
        Assert.assertEquals((Object)"sourceProduct.1", (Object)sourceElement.getAttributeAt(0).getName());
        Assert.assertEquals((Object)"sourceProduct.2", (Object)sourceElement.getAttributeAt(1).getName());
    }

    @Test
    public void testTileSizeRenderingHint() {
        RenderingHints renderingHints = new RenderingHints(null);
        try {
            renderingHints.put(GPF.KEY_TILE_SIZE, (Object)null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            renderingHints.put(GPF.KEY_TILE_SIZE, new Object());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            renderingHints.put(GPF.KEY_TILE_SIZE, new Dimension());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dimension tileSize = new Dimension(1, 1);
        renderingHints.put(GPF.KEY_TILE_SIZE, tileSize);
        Assert.assertSame((Object)tileSize, (Object)renderingHints.get(GPF.KEY_TILE_SIZE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteProduct() throws Exception {
        StackOp stackOp = new StackOp();
        Product source = new Product("name", "type", 1000, 1000);
        source.setPreferredTileSize(200, 200);
        stackOp.setSourceProduct(source);
        Product targetProduct = stackOp.getTargetProduct();
        File outputFile = GlobalTestConfig.getBeamTestDataOutputFile((String)"GPFFacadeTest/testWriteProduct.dim");
        try {
            outputFile.getParentFile().mkdirs();
            GPF.writeProduct((Product)targetProduct, (File)outputFile, (String)"BEAM-DIMAP", (boolean)false, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
        }
        finally {
            FileUtils.deleteTree((File)outputFile.getParentFile());
        }
        Assert.assertEquals((long)25L, (long)stackOp.computeTileStackCounter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteProductWithCacheClearing() throws Exception {
        StackOp stackOp = new StackOp();
        Product source = new Product("name", "type", 1000, 1000);
        source.setPreferredTileSize(200, 200);
        stackOp.setSourceProduct(source);
        Product targetProduct = stackOp.getTargetProduct();
        File outputFile = GlobalTestConfig.getBeamTestDataOutputFile((String)"GPFFacadeTest/testWriteProduct.dim");
        try {
            outputFile.getParentFile().mkdirs();
            GPF.writeProduct((Product)targetProduct, (File)outputFile, (String)"BEAM-DIMAP", (boolean)true, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
        }
        finally {
            FileUtils.deleteTree((File)outputFile.getParentFile());
        }
        Assert.assertEquals((long)25L, (long)stackOp.computeTileStackCounter.get());
    }

    private static class StackOp
    extends Operator {
        AtomicInteger computeTileStackCounter = new AtomicInteger(0);
        Dimension tileSize;

        private StackOp() {
        }

        public void initialize() throws OperatorException {
            Product sourceProduct = this.getSourceProduct();
            this.tileSize = sourceProduct.getPreferredTileSize();
            Product product = new Product("name", "type", sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight());
            product.addBand("A", 30);
            product.addBand("B", 30);
            this.setTargetProduct(product);
        }

        public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
            this.computeTileStackCounter.incrementAndGet();
            Arrays.fill(targetTiles.get(this.getTargetProduct().getBand("A")).getDataBufferFloat(), 5.0f);
            Arrays.fill(targetTiles.get(this.getTargetProduct().getBand("B")).getDataBufferFloat(), 7.0f);
        }

        private void logTileIndex(int x, int y) {
            int tileX = MathUtils.floorInt((double)((double)x / (double)this.tileSize.width));
            int tileY = MathUtils.floorInt((double)((double)y / (double)this.tileSize.height));
            System.out.println("tileY = " + tileY + "  tileX = " + tileX);
        }
    }

    public static class FoosOpSpi
    extends OperatorSpi {
        public FoosOpSpi() {
            super(FoosOp.class);
        }
    }

    @OperatorMetadata(alias="Foos")
    public static class FoosOp
    extends Operator {
        @TargetProduct
        Product targetProduct;
        @SourceProducts
        Product[] sourceProducts;

        public void initialize() throws OperatorException {
            String[] bandNames;
            this.targetProduct = new Product("X", "Y", this.sourceProducts[0].getSceneRasterWidth(), this.sourceProducts[0].getSceneRasterHeight());
            for (String s : bandNames = this.sourceProducts[0].getBandNames()) {
                this.targetProduct.addBand(s, 30);
            }
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            byte[] dataBufferByte = targetTile.getDataBufferByte();
            Arrays.fill(dataBufferByte, (byte)3);
        }
    }

    public static class FooOpSpi
    extends OperatorSpi {
        public FooOpSpi() {
            super(FooOp.class);
        }
    }

    @OperatorMetadata(alias="Foo")
    public static class FooOp
    extends Operator {
        @TargetProduct
        Product targetProduct;
        @SourceProduct
        Product sourceProduct;
        @Parameter
        int intParam;
        @Parameter
        double doubleParam;
        @Parameter
        String stringParam;
        @Parameter
        boolean booleanParam;
        @Parameter
        float[] floatArrayParam;

        public void initialize() throws OperatorException {
            String[] bandNames;
            this.targetProduct = new Product("X", "Y", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            for (String s : bandNames = this.sourceProduct.getBandNames()) {
                this.targetProduct.addBand(s, 30);
            }
        }

        public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
            Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(band.getName()), targetTile.getRectangle());
            ProductData rawTarget = targetTile.getRawSamples();
            ProductData rawSource = sourceTile.getRawSamples();
            int n = rawTarget.getNumElems();
            for (int i = 0; i < n; ++i) {
                float v = rawSource.getElemFloatAt(i);
                if (v < 0.0f) {
                    v = 0.0f;
                }
                if (v > 1.0f) {
                    v = 1.0f;
                }
                rawTarget.setElemFloatAt(i, v);
            }
            targetTile.setRawSamples(rawTarget);
        }
    }
}

