/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.pointop;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.pointop.PointOperator;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.WritableSample;

public abstract class SampleOperator
extends PointOperator {
    protected abstract void computeSample(int var1, int var2, Sample[] var3, WritableSample var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        Point location = new Point();
        Sample[] sourceSamples = this.createSourceSamples(targetRectangle, location);
        Sample sourceMaskSamples = this.createSourceMaskSamples(targetRectangle, location);
        WritableSample targetSample = this.createTargetSample(targetTile, location);
        int x1 = targetTile.getMinX();
        int y1 = targetTile.getMinY();
        int x2 = targetTile.getMaxX();
        int y2 = targetTile.getMaxY();
        try {
            pm.beginTask(this.getId(), targetTile.getHeight());
            if (sourceMaskSamples != null) {
                location.y = y1;
                while (location.y <= y2) {
                    location.x = x1;
                    while (location.x <= x2) {
                        if (sourceMaskSamples.getBoolean()) {
                            this.computeSample(location.x, location.y, sourceSamples, targetSample);
                        } else {
                            this.setInvalid(targetSample);
                        }
                        ++location.x;
                    }
                    pm.worked(1);
                    ++location.y;
                }
            } else {
                location.y = y1;
                while (location.y <= y2) {
                    location.x = x1;
                    while (location.x <= x2) {
                        this.computeSample(location.x, location.y, sourceSamples, targetSample);
                        ++location.x;
                    }
                    pm.worked(1);
                    ++location.y;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private void setInvalid(WritableSample targetSample) {
        targetSample.set(targetSample.getNode().getGeophysicalNoDataValue());
    }
}

