/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.esa.snap.SnapCoreActivator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.util.SystemUtils;

public class OperatorSpiRegistryImpl
implements OperatorSpiRegistry {
    private final ServiceRegistry<OperatorSpi> serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(OperatorSpi.class);
    private final Map<String, String> classNames = new HashMap<String, String>(20);
    private final Map<String, OperatorSpi> extraOperatorSpis;

    public OperatorSpiRegistryImpl() {
        this.serviceRegistry.addListener((ServiceRegistryListener)new ServiceRegistryListener<OperatorSpi>(){

            public void serviceAdded(ServiceRegistry<OperatorSpi> registry, OperatorSpi service) {
                OperatorSpiRegistryImpl.this.registerAlias(service);
            }

            public void serviceRemoved(ServiceRegistry<OperatorSpi> registry, OperatorSpi service) {
                OperatorSpiRegistryImpl.this.unregisterAlias(service);
            }
        });
        Set services = this.serviceRegistry.getServices();
        for (OperatorSpi operatorSpi : services) {
            this.registerAlias(operatorSpi);
        }
        this.extraOperatorSpis = new HashMap<String, OperatorSpi>();
    }

    @Override
    public void loadOperatorSpis() {
        if (!SnapCoreActivator.isStarted()) {
            SnapCoreActivator.loadServices(this.getServiceRegistry());
        }
    }

    @Override
    public Set<OperatorSpi> getOperatorSpis() {
        HashSet<OperatorSpi> operatorSpis = new HashSet<OperatorSpi>(this.serviceRegistry.getServices());
        operatorSpis.addAll(this.extraOperatorSpis.values());
        return operatorSpis;
    }

    @Override
    public ServiceRegistry<OperatorSpi> getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public OperatorSpi getOperatorSpi(String operatorName) {
        OperatorSpi service = (OperatorSpi)this.serviceRegistry.getService(operatorName);
        if (service != null) {
            return service;
        }
        service = this.extraOperatorSpis.get(operatorName);
        if (service != null) {
            return service;
        }
        String className = this.classNames.get(operatorName);
        if (className != null && (service = (OperatorSpi)this.serviceRegistry.getService(className)) != null) {
            return service;
        }
        return null;
    }

    @Override
    public boolean addOperatorSpi(OperatorSpi operatorSpi) {
        String spiClassName = operatorSpi.getClass().getName();
        if (this.serviceRegistry.getService(spiClassName) == operatorSpi) {
            return false;
        }
        this.registerAlias(operatorSpi);
        return this.serviceRegistry.addService((Object)operatorSpi);
    }

    @Override
    public boolean addOperatorSpi(String operatorName, OperatorSpi operatorSpi) {
        if (operatorName.equals(operatorSpi.getClass().getName())) {
            return this.addOperatorSpi(operatorSpi);
        }
        if (this.extraOperatorSpis.get(operatorName) == operatorSpi) {
            return false;
        }
        this.registerAlias(operatorSpi.getClass().getName(), operatorName);
        this.extraOperatorSpis.put(operatorName, operatorSpi);
        return true;
    }

    @Override
    public boolean removeOperatorSpi(OperatorSpi operatorSpi) {
        if (!this.serviceRegistry.removeService((Object)operatorSpi)) {
            Stream extraSpiStream = this.extraOperatorSpis.entrySet().stream();
            Optional<Map.Entry> spiEntry = extraSpiStream.filter(entry -> entry.getValue() == operatorSpi).findFirst();
            if (spiEntry.isPresent() && this.extraOperatorSpis.remove(spiEntry.get().getKey(), spiEntry.get().getValue())) {
                this.unregisterAlias((OperatorSpi)spiEntry.get().getValue());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getAliases() {
        return this.classNames.keySet();
    }

    @Override
    @Deprecated
    public void setAlias(String aliasName, String spiClassName) {
        this.registerAlias(spiClassName, aliasName);
    }

    private void registerAlias(String spiClassName, String aliasName) {
        Assert.notNull((Object)aliasName, (String)"aliasName");
        Assert.notNull((Object)spiClassName, (String)"spiClassName");
        if (this.classNames.get(aliasName) != null) {
            SystemUtils.LOG.severe(spiClassName + ':' + aliasName + " conflicts with " + this.classNames.get(aliasName) + ':' + aliasName);
        }
        this.classNames.put(aliasName, spiClassName);
    }

    private void registerAlias(OperatorSpi operatorSpi) {
        String operatorAlias = operatorSpi.getOperatorDescriptor().getAlias();
        if (operatorAlias != null) {
            this.registerAlias(operatorSpi.getClass().getName(), operatorAlias);
        }
    }

    private void unregisterAlias(OperatorSpi operatorSpi) {
        String spiClassName = operatorSpi.getClass().getName();
        for (String key : new HashSet<String>(this.classNames.keySet())) {
            if (!this.classNames.get(key).equals(spiClassName)) continue;
            this.classNames.remove(key);
        }
    }
}

