/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.HeaderSource;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.gpf.internal.OperatorConfiguration;
import org.esa.snap.core.util.SystemUtils;

public class GraphContext {
    private Graph graph;
    private Logger logger;
    private Map<Node, NodeContext> nodeContextMap;
    private List<NodeContext> outputNodeContextList;
    private ArrayDeque<NodeContext> initNodeContextDeque;

    public GraphContext(Graph graph) throws GraphException {
        this(graph, null);
    }

    public GraphContext(Graph graph, Operator graphOp) throws GraphException {
        if (graph.getNodeCount() == 0) {
            throw new GraphException("Empty graph.");
        }
        this.graph = graph;
        this.logger = SystemUtils.LOG;
        this.outputNodeContextList = new ArrayList<NodeContext>(graph.getNodeCount() / 2);
        this.nodeContextMap = new HashMap<Node, NodeContext>(graph.getNodeCount() * 2);
        for (Node node : graph.getNodes()) {
            this.nodeContextMap.put(node, new NodeContext(this, node));
        }
        this.initNodeContextDeque = new ArrayDeque(graph.getNodeCount());
        this.initNodeDependencies();
        this.initOutput(graphOp);
    }

    private static boolean isSourceNodeIdInHeader(String sourceNodeId, List<HeaderSource> headerSources) {
        for (HeaderSource headerSource : headerSources) {
            if (!sourceNodeId.equals(headerSource.getName())) continue;
            return true;
        }
        return false;
    }

    private void initNodeDependencies() throws GraphException {
        Graph graph = this.getGraph();
        for (Node node : graph.getNodes()) {
            for (NodeSource source : node.getSources()) {
                String sourceNodeId = source.getSourceNodeId();
                Node sourceNode = graph.getNode(sourceNodeId);
                if (sourceNode == null) {
                    boolean sourceDefinedInHeader;
                    Header header = graph.getHeader();
                    boolean bl = sourceDefinedInHeader = header != null && GraphContext.isSourceNodeIdInHeader(sourceNodeId, header.getSources());
                    if (!sourceDefinedInHeader) {
                        throw new GraphException(GraphContext.getMissingSourceMessage(node, source));
                    }
                }
                if (sourceNode == null) continue;
                this.getNodeContext(sourceNode).incrementReferenceCount();
                source.setSourceNode(sourceNode);
            }
        }
    }

    OperatorConfiguration createOperatorConfiguration(DomElement domElement, Map<String, Object> parameterContext) {
        DomElement[] children;
        if (domElement == null) {
            return null;
        }
        XppDomElement resolvedElement = new XppDomElement(domElement.getName());
        HashSet<OperatorConfiguration.Reference> references = new HashSet<OperatorConfiguration.Reference>(17);
        for (DomElement child : children = (DomElement[])domElement.getChildren()) {
            String reference = child.getAttribute("refid");
            if (reference != null) {
                String parameterName = child.getName();
                if (reference.contains(".")) {
                    String[] referenceParts = reference.split("\\.");
                    String referenceNodeId = referenceParts[0];
                    String propertyName = referenceParts[1];
                    Node node = this.getGraph().getNode(referenceNodeId);
                    NodeContext referredNodeContext = this.getNodeContext(node);
                    Operator operator = referredNodeContext.getOperator();
                    OperatorConfiguration.PropertyReference propertyReference = new OperatorConfiguration.PropertyReference(parameterName, propertyName, operator);
                    references.add(propertyReference);
                    continue;
                }
                OperatorConfiguration.ParameterReference parameterReference = new OperatorConfiguration.ParameterReference(parameterName, parameterContext.get(reference));
                references.add(parameterReference);
                continue;
            }
            resolvedElement.addChild(child);
        }
        return new OperatorConfiguration((DomElement)resolvedElement, references);
    }

    private void initOutput(Operator graphOp) throws GraphException {
        for (Node node : this.getGraph().getNodes()) {
            NodeContext nodeContext = this.getNodeContext(node);
            if (!nodeContext.isOutput()) continue;
            this.initNodeContext(nodeContext, graphOp);
            this.addOutputNodeContext(nodeContext);
        }
    }

    private void initNodeContext(NodeContext nodeContext, Operator graphOp) throws GraphException {
        if (nodeContext.isInitialized()) {
            return;
        }
        for (NodeSource source : nodeContext.getNode().getSources()) {
            NodeContext sourceNodeContext = this.getNodeContext(source.getSourceNode());
            Product sourceProduct = null;
            if (sourceNodeContext != null) {
                this.initNodeContext(sourceNodeContext, graphOp);
                sourceProduct = sourceNodeContext.getTargetProduct();
            } else if (graphOp != null) {
                sourceProduct = graphOp.getSourceProduct(source.getSourceNodeId());
            }
            if (sourceProduct == null) {
                throw new GraphException(GraphContext.getMissingSourceMessage(nodeContext.getNode(), source));
            }
            nodeContext.addSourceProduct(source.getName(), sourceProduct);
        }
        Node node = nodeContext.getNode();
        DomElement configuration = node.getConfiguration();
        OperatorConfiguration opConfiguration = this.createOperatorConfiguration(configuration, new HashMap<String, Object>());
        nodeContext.setOperatorConfiguration(opConfiguration);
        nodeContext.initTargetProduct();
        this.getInitNodeContextDeque().addFirst(nodeContext);
    }

    public void dispose() {
        Deque<NodeContext> initNodeContextDeque = this.getInitNodeContextDeque();
        while (!initNodeContextDeque.isEmpty()) {
            NodeContext nodeContext = initNodeContextDeque.pop();
            nodeContext.dispose();
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setPreferredTileSize(Dimension preferredTileSize) {
        JAI.setDefaultTileSize((Dimension)preferredTileSize);
    }

    public Product[] getOutputProducts() {
        Product[] products = new Product[this.outputNodeContextList.size()];
        for (int i = 0; i < products.length; ++i) {
            products[i] = this.outputNodeContextList.get(i).getTargetProduct();
        }
        return products;
    }

    public Deque<NodeContext> getInitNodeContextDeque() {
        return this.initNodeContextDeque;
    }

    public NodeContext getNodeContext(Node node) {
        return this.nodeContextMap.get(node);
    }

    NodeContext[] getOutputNodeContexts() {
        return this.outputNodeContextList.toArray(new NodeContext[this.outputNodeContextList.size()]);
    }

    void addOutputNodeContext(NodeContext nodeContext) {
        this.outputNodeContextList.add(nodeContext);
    }

    private static String getMissingSourceMessage(Node node, NodeSource source) {
        return MessageFormat.format("Missing source ''{0}'' in node ''{1}''", source.getSourceNodeId(), node.getId());
    }
}

