/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.doclet;

import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.esa.snap.core.gpf.doclet.ElementDesc;
import org.esa.snap.core.gpf.doclet.OperatorDesc;
import org.esa.snap.core.gpf.doclet.OperatorHandler;
import org.esa.snap.core.gpf.doclet.ParameterDesc;
import org.esa.snap.core.gpf.doclet.SourceProductDesc;
import org.esa.snap.core.gpf.doclet.SourceProductsDesc;

public class OperatorHandlerHtml
implements OperatorHandler {
    ArrayList<OperatorDesc> operatorDescs = new ArrayList();
    private File baseDir;

    @Override
    public void start(RootDoc root) throws IOException, URISyntaxException {
        URL location = OperatorHandlerHtml.class.getProtectionDomain().getCodeSource().getLocation();
        this.baseDir = new File(new File(location.toURI()), "org/esa/snap/core/gpf/docs/gpf");
        System.out.println("Output goes to " + this.baseDir);
        if (!this.baseDir.isDirectory() && !this.baseDir.mkdirs()) {
            throw new IOException("Failed to create base directory " + this.baseDir);
        }
    }

    @Override
    public void stop(RootDoc root) throws IOException {
        Collections.sort(this.operatorDescs, new Comparator<OperatorDesc>(){

            @Override
            public int compare(OperatorDesc od1, OperatorDesc od2) {
                return od1.getName().compareTo(od2.getName());
            }
        });
        File indexFile = new File(this.baseDir, "OperatorIndex.html");
        try (PrintWriter writer = new PrintWriter(new FileWriter(indexFile));){
            this.writeIndex(writer);
        }
    }

    @Override
    public void processOperator(OperatorDesc operatorDesc) throws IOException {
        File file = this.getOperatorPageFile(operatorDesc);
        if (file.exists()) {
            System.out.println("Warning: File exists and will be overwritten: " + file);
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            OperatorHandlerHtml.writeOperatorPage(operatorDesc, writer);
            this.operatorDescs.add(operatorDesc);
        }
    }

    private void writeIndex(PrintWriter writer) throws IOException {
        OperatorHandlerHtml.writeHeader("GPF Operator Index", writer);
        writer.println("<h1>GPF Operator Index</h1>");
        writer.println("<table>");
        for (OperatorDesc operatorDesc : this.operatorDescs) {
            writer.println("  <tr>");
            writer.println("    <td><b><code><a href=\"" + OperatorHandlerHtml.getOperatorPageName(operatorDesc) + "\">" + operatorDesc.getName() + "</a></code></b></td>");
            writer.println("    <td>" + operatorDesc.getShortDescription() + "</td>");
            writer.println("  </tr>");
        }
        writer.println("</table>");
        OperatorHandlerHtml.writeFooter(writer);
    }

    private static void writeOperatorPage(OperatorDesc operatorDesc, PrintWriter writer) {
        OperatorHandlerHtml.writeHeader(operatorDesc.getName() + " Operator", writer);
        writer.println("<h1>" + operatorDesc.getName() + " Operator Description</h1>");
        writer.println("<h2>Overview</h2>");
        writer.println("<table>");
        writer.println("  <tr><td><b>Name:</b></td><td><code>" + operatorDesc.getName() + "</code></td></tr>");
        writer.println("  <tr><td><b>Full name:</b></td><td><code>" + operatorDesc.getType().getName() + "</code></td></tr>");
        writer.println("  <tr><td><b>Purpose:</b></td><td>" + OperatorHandlerHtml.makeHtmlConform(operatorDesc.getShortDescription()) + "</td></tr>");
        writer.println("  <tr><td><b>Version:</b></td><td>" + operatorDesc.getVersion() + "</td></tr>");
        writer.println("</table>");
        writer.println("<h2>Description</h2>");
        String description = operatorDesc.getLongDescription();
        if (!description.isEmpty()) {
            writer.println(description);
        } else {
            writer.println("<i>No description available.</i>");
        }
        writer.println("<h2>Sources</h2>");
        SourceProductDesc[] sourceProducts = operatorDesc.getSourceProductList();
        SourceProductsDesc sourceProductsField = operatorDesc.getSourceProducts();
        if (sourceProducts.length > 0 || sourceProductsField != null) {
            writer.println("<table>");
            writer.println("<tr>");
            writer.println("  <th>Name</th>");
            writer.println("  <th>Description</th>");
            writer.println("</tr>");
            for (SourceProductDesc sourceProduct : sourceProducts) {
                writer.println("<tr>");
                writer.println("  <td><code>" + sourceProduct.getName() + "</code></td>");
                writer.println("  <td>" + OperatorHandlerHtml.getFullDescription(sourceProduct) + "</td>");
                writer.println("</tr>");
            }
            if (sourceProductsField != null) {
                writer.println("<tr>");
                writer.println("  <td><code>" + sourceProductsField.getName() + "</code></td>");
                writer.println("  <td>" + OperatorHandlerHtml.getFullDescription(sourceProductsField) + "</td>");
                writer.println("</tr>");
            }
            writer.println("</table>");
        } else {
            writer.println("<p><i>This operator does not have any sources.</i>");
        }
        writer.println("<h2>Parameters</h2>");
        ParameterDesc[] parameterDescs = operatorDesc.getParameters();
        if (parameterDescs.length > 0) {
            writer.println("<table>");
            writer.println("<tr>");
            writer.println("  <th>Name</th>");
            writer.println("  <th>Data Type</th>");
            writer.println("  <th>Default</th>");
            writer.println("  <th>Description</th>");
            writer.println("  <th>Constraints</th>");
            writer.println("</tr>");
            for (ParameterDesc parameterDesc : parameterDescs) {
                writer.println("<tr>");
                writer.println("  <td><code>" + parameterDesc.getName() + "</code></td>");
                writer.println("  <td><code>" + parameterDesc.getType().getSimpleName() + "</code></td>");
                writer.println("  <td><code>" + parameterDesc.getDefaultValue() + "</code></td>");
                writer.println("  <td>" + OperatorHandlerHtml.getFullDescription(parameterDesc) + "</td>");
                writer.println("  <td>" + parameterDesc.getConstraints() + "</td>");
                writer.println("</tr>");
            }
            writer.println("</table>");
        } else {
            writer.println("<p><i>This operator does not have any parameters.</i>");
        }
        OperatorHandlerHtml.writeFooter(writer);
    }

    private static String makeHtmlConform(String text) {
        return text.replace("\n", "<br/>");
    }

    private static void writeHeader(String title, PrintWriter writer) {
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        writer.println("<html>");
        writer.println("<head>\n    <title>" + title + "</title>\n" + "    <link rel=\"stylesheet\" href=\"../style.css\">\n" + "</head>");
        writer.println("<body>");
        writer.println("<table class=\"header\">\n    <tr class=\"header\">\n        <td class=\"header\">&nbsp;" + title + "</td>\n" + "        <td class=\"header\" align=\"right\">\n" + "           <a href=\"../general/BeamOverview.html\">" + "             <img src=\"images/snap_header.jpg\" border=\"0\"/></a>\n" + "        </td>\n" + "    </tr>\n" + "</table>");
    }

    private static void writeFooter(PrintWriter writer) {
        writer.println("<hr/>");
        writer.println("</body>");
        writer.println("</html>");
    }

    private static String getFullDescription(ElementDesc elementDesc) {
        String shortDescription = elementDesc.getShortDescription();
        String longDescription = elementDesc.getLongDescription();
        if (shortDescription.isEmpty()) {
            return longDescription;
        }
        if (longDescription.isEmpty()) {
            return shortDescription;
        }
        return shortDescription + "<br/>" + longDescription;
    }

    private File getOperatorPageFile(OperatorDesc operatorDesc) {
        return new File(this.baseDir, OperatorHandlerHtml.getOperatorPageName(operatorDesc));
    }

    private static String getOperatorPageName(OperatorDesc operatorDesc) {
        return operatorDesc.getType().getName().replace('.', '_') + ".html";
    }
}

