/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.doclet.OperatorDesc;
import org.esa.snap.core.gpf.doclet.OperatorHandler;
import org.esa.snap.core.gpf.doclet.OperatorHandlerConsole;
import org.esa.snap.core.gpf.doclet.OperatorHandlerHtml;

public class OperatorDoclet
extends Doclet {
    static String format;

    public static void main(String[] args) {
        if (args.length == 0) {
            format = "console";
        } else if (args.length == 1) {
            format = args[0];
        } else {
            System.out.println("Usage: OperatorDoclet [ console | html ]");
            System.exit(1);
        }
        Main.main((String[])new String[]{"-doclet", OperatorDoclet.class.getName(), "-sourcepath", "./beam-gpf/src/main/java;./beam-aatsr-sst/src/main/java;./beam-binning/src/main/java;./beam-cluster-analysis/src/main/java;./beam-collocation/src/main/java;./beam-flhmci/src/main/java;./beam-meris-radiometry/src/main/java;./beam-meris-smac/src/main/java;./beam-meris-cloud/src/main/java;./beam-pixel-extraction/src/main/java;./beam-statistics-op/src/main/java;./beam-temporal-percentile-op/src/main/java;./beam-ndvi/src/main/java;./beam-unmix/src/main/java", "-classpath", "./modules/beam-core-5.0.1;./modules/beam-gpf-5.0;./modules/beam-aatsr-sst-5.0;./modules/beam-binning-5.0.1;./modules/beam-cluster-analysis-5.0;./modules/beam-collocation-5.0;./modules/beam-flhmci-5.0;./modules/beam-meris-radiometry-5.0;./modules/beam-meris-smac-5.0;./modules/beam-meris-cloud-5.0;./modules/beam-pixel-extraction-5.0;./modules/beam-statistics-op-5.0;./modules/beam-temporal-percentile-op-5.0;./modules/beam-ndvi-5.0;./modules/beam-unmix-5.0", "org.esa.snap.core.gpf.common", "org.esa.snap.core.gpf.common.reproject", "org.esa.snap.s3tbx.meris", "org.esa.snap.aatsr.sst", "org.esa.snap.binning.operator", "org.esa.snap.cluster", "org.esa.snap.collocation", "org.esa.snap.processor.flh_mci", "org.esa.snap.meris.radiometry", "org.esa.snap.smac", "org.esa.snap.operator.cloud", "org.esa.snap.pixex", "org.esa.snap.statistics", "org.esa.snap.statistics.percentile.interpolated", "org.esa.snap.ndvi", "org.esa.snap.unmixing"});
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classDocs;
        OperatorHandler operatorHandler;
        if ("console".equalsIgnoreCase(format)) {
            operatorHandler = new OperatorHandlerConsole();
        } else if ("html".equalsIgnoreCase(format)) {
            operatorHandler = new OperatorHandlerHtml();
        } else {
            throw new RuntimeException("Illegal output format: " + format);
        }
        try {
            operatorHandler.start(root);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        operatorSpiRegistry.loadOperatorSpis();
        for (ClassDoc classDoc : classDocs = root.classes()) {
            if (!classDoc.subclassOf(root.classNamed(Operator.class.getName()))) continue;
            try {
                System.out.println("Processing " + classDoc.typeName() + "...");
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> type = contextClassLoader.loadClass(classDoc.qualifiedTypeName());
                OperatorSpi operatorSpi = operatorSpiRegistry.getOperatorSpi(OperatorSpi.getOperatorAlias(type));
                if (operatorSpi != null) {
                    OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
                    if (!operatorDescriptor.isInternal()) {
                        OperatorDesc operatorDesc = new OperatorDesc(type, classDoc, operatorDescriptor);
                        operatorHandler.processOperator(operatorDesc);
                        continue;
                    }
                    System.err.printf("Warning: Skipping %s because it is internal.%n", classDoc.typeName());
                    continue;
                }
                System.err.printf("No SPI found for operator class '%s'.%n", type.getName());
            }
            catch (Throwable e) {
                System.err.println("Error: " + classDoc.typeName() + ": " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        try {
            operatorHandler.stop(root);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return true;
    }

    public static int optionLength(String optionName) {
        if (optionName.equals("format")) {
            return 1;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter docErrorReporter) {
        for (int i = 0; i < options.length; ++i) {
            for (int j = 0; j < options[i].length; ++j) {
                docErrorReporter.printWarning("options[" + i + "][" + j + "] = " + options[i][j]);
            }
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }
}

