/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import java.util.ArrayList;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.support.ProductFlipperExt;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Flip", category="Raster", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="flips a product horizontal/vertical")
public final class FlipOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"Horizontal", "Vertical", "Horizontal and Vertical"}, defaultValue="Vertical", label="Flip")
    private String flipType = "Vertical";

    @Override
    public void initialize() throws OperatorException {
        if (this.sourceProduct.isMultiSizeProduct()) {
            throw this.createMultiSizeException(this.sourceProduct);
        }
        try {
            int flippingType = 3;
            if (this.flipType.equalsIgnoreCase("Horizontal")) {
                flippingType = 1;
            } else if (this.flipType.equalsIgnoreCase("Vertical")) {
                flippingType = 2;
            }
            this.sourceProduct = ProductFlipperExt.createFlippedProduct((Product)this.sourceProduct, (int)flippingType, (String)this.sourceProduct.getName(), (String)this.sourceProduct.getDescription());
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            this.addSelectedBands();
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        for (Band srcBand : sourceBands = FlipOp.getSourceBands(this.sourceProduct, this.sourceBandNames, false)) {
            Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
        }
    }

    public static Band[] getSourceBands(Product sourceProduct, String[] sourceBandNames, boolean includeVirtualBands) throws OperatorException {
        if (sourceBandNames == null || sourceBandNames.length == 0) {
            Band[] bands = sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (band instanceof VirtualBand && !includeVirtualBands) continue;
                bandNameList.add(band.getName());
            }
            sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        ArrayList<Band> sourceBandList = new ArrayList<Band>(sourceBandNames.length);
        for (String sourceBandName : sourceBandNames) {
            Band sourceBand = sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) continue;
            sourceBandList.add(sourceBand);
        }
        return sourceBandList.toArray(new Band[sourceBandList.size()]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FlipOp.class);
        }
    }
}

