/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.ProductNamespacePrefixProvider;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.support.BandDescriptorDomConverter;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.jexp.impl.SymbolFactory;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;

@OperatorMetadata(alias="BandMaths", category="Raster", version="1.1", copyright="(c) 2013 by Brockmann Consult", authors="Marco Zuehlke, Norman Fomferra, Marco Peters", description="Create a product with one or more bands using mathematical expressions.")
public class BandMathsOp
extends Operator {
    @TargetProduct
    private Product targetProduct;
    @SourceProducts(description="Any number of source products.")
    private Product[] sourceProducts;
    @Parameter(alias="targetBands", itemAlias="targetBand", domConverter=BandDescriptorDomConverter.class, description="List of descriptors defining the target bands.")
    private BandDescriptor[] targetBandDescriptors;
    @Parameter(alias="variables", itemAlias="variable", description="List of variables which can be used within the expressions.")
    private Variable[] variables;
    private Map<Band, BandDescriptor> descriptorMap;

    public BandDescriptor[] getTargetBandDescriptors() {
        return this.targetBandDescriptors;
    }

    public void setTargetBandDescriptors(BandDescriptor ... targetBandDescriptors) {
        this.targetBandDescriptors = targetBandDescriptors;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void setVariables(Variable ... variables) {
        this.variables = variables;
    }

    @Override
    public void initialize() throws OperatorException {
        if (this.targetBandDescriptors == null || this.targetBandDescriptors.length == 0) {
            throw new OperatorException("No target bands specified.");
        }
        if (this.sourceProducts == null || this.sourceProducts.length == 0) {
            throw new OperatorException("No source products given.");
        }
        int width = this.sourceProducts[0].getSceneRasterWidth();
        int height = this.sourceProducts[0].getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProducts[0].getName() + "BandMath", "BandMath", width, height);
        this.descriptorMap = new HashMap<Band, BandDescriptor>(this.targetBandDescriptors.length);
        for (BandDescriptor bandDescriptor : this.targetBandDescriptors) {
            Term targetTerm = this.createTerm(bandDescriptor.expression, true);
            if (!BandArithmetic.areRastersEqualInSize((Term)targetTerm)) {
                throw new OperatorException("Referenced rasters must all be the same size: " + bandDescriptor.expression);
            }
            RasterDataSymbol[] rasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term[])new Term[]{targetTerm});
            Dimension targetBandDimension = this.findTargetBandSize(rasterDataSymbols);
            Band targetBand = this.createBand(bandDescriptor, targetBandDimension);
            this.targetProduct.addBand(targetBand);
            if (rasterDataSymbols.length > 0) {
                ProductUtils.copyImageGeometry((RasterDataNode)rasterDataSymbols[0].getRaster(), (RasterDataNode)targetBand, (boolean)true);
            }
            this.descriptorMap.put(targetBand, bandDescriptor);
        }
        ProductUtils.copyMetadata((Product)this.sourceProducts[0], (Product)this.targetProduct);
        ProductUtils.copyTiePointGrids((Product)this.sourceProducts[0], (Product)this.targetProduct);
        BandMathsOp.copyFlagCodingsIfPossible(this.sourceProducts[0], this.targetProduct);
        BandMathsOp.copyIndexCodingsIfPossible(this.sourceProducts[0], this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProducts[0], (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProducts[0], (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProducts[0], (Product)this.targetProduct);
        this.targetProduct.setDescription(this.sourceProducts[0].getDescription());
        for (BandDescriptor bandDescriptor : this.sourceProducts) {
            if (bandDescriptor.getStartTime() == null || bandDescriptor.getEndTime() == null) continue;
            this.targetProduct.setStartTime(bandDescriptor.getStartTime());
            this.targetProduct.setEndTime(bandDescriptor.getEndTime());
            break;
        }
    }

    private static void copyFlagCodingsIfPossible(Product source, Product target) {
        int numCodings = source.getFlagCodingGroup().getNodeCount();
        for (int n = 0; n < numCodings; ++n) {
            FlagCoding sourceFlagCoding = (FlagCoding)source.getFlagCodingGroup().get(n);
            String sourceFlagCodingName = sourceFlagCoding.getName();
            if (!target.containsBand(sourceFlagCodingName) || !target.getBand(sourceFlagCodingName).hasIntPixels()) continue;
            ProductUtils.copyFlagCoding((FlagCoding)sourceFlagCoding, (Product)target);
            target.getBand(sourceFlagCodingName).setSampleCoding((SampleCoding)sourceFlagCoding);
        }
    }

    private static void copyIndexCodingsIfPossible(Product source, Product target) {
        int numCodings = source.getIndexCodingGroup().getNodeCount();
        for (int n = 0; n < numCodings; ++n) {
            IndexCoding sourceIndexCoding = (IndexCoding)source.getIndexCodingGroup().get(n);
            String sourceIndexCodingName = sourceIndexCoding.getName();
            if (!target.containsBand(sourceIndexCodingName) || !target.getBand(sourceIndexCodingName).hasIntPixels()) continue;
            ProductUtils.copyIndexCoding((IndexCoding)sourceIndexCoding, (Product)target);
            target.getBand(sourceIndexCodingName).setSampleCoding((SampleCoding)sourceIndexCoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        RasterDataSymbol[] refRasterDataSymbols;
        Rectangle rect = targetTile.getRectangle();
        Term term = this.createTerm(this.descriptorMap.get((Object)band).expression, false);
        for (RasterDataSymbol symbol : refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term[])new Term[]{term})) {
            this.fillSymbolWithData(symbol, rect);
        }
        RasterDataEvalEnv env = new RasterDataEvalEnv(rect.x, rect.y, rect.width, rect.height);
        pm.beginTask("Evaluating expression", rect.height);
        try {
            float fv = Float.NaN;
            if (band.isNoDataValueUsed()) {
                fv = (float)band.getNoDataValue();
            }
            int pixelIndex = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                if (pm.isCanceled()) {
                    break;
                }
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    env.setElemIndex(pixelIndex);
                    double v = term.evalD((EvalEnv)env);
                    if (Double.isNaN(v) || Double.isInfinite(v)) {
                        targetTile.setSample(x, y, fv);
                    } else {
                        targetTile.setSample(x, y, v);
                    }
                    ++pixelIndex;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private void fillSymbolWithData(RasterDataSymbol symbol, Rectangle rect) {
        Tile tile = this.getSourceTile(symbol.getRaster(), rect);
        if (tile.getRasterDataNode().isScalingApplied()) {
            ProductData dataBuffer = ProductData.createInstance((int)30, (int)(tile.getWidth() * tile.getHeight()));
            int dataBufferIndex = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    dataBuffer.setElemFloatAt(dataBufferIndex, tile.getSampleFloat(x, y));
                    ++dataBufferIndex;
                }
            }
            symbol.setData((Object)dataBuffer);
        } else {
            ProductData dataBuffer = tile.getRawSamples();
            symbol.setData((Object)dataBuffer);
        }
    }

    private Band createBand(BandDescriptor bandDescriptor, Dimension targetBandDimension) {
        if (StringUtils.isNullOrEmpty((String)bandDescriptor.name)) {
            throw new OperatorException("Missing band name.");
        }
        if (StringUtils.isNullOrEmpty((String)bandDescriptor.type)) {
            throw new OperatorException(String.format("Missing data type for band %s.", bandDescriptor.name));
        }
        Band targetBand = new Band(bandDescriptor.name, ProductData.getType((String)bandDescriptor.type.toLowerCase()), targetBandDimension.width, targetBandDimension.height);
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.description)) {
            targetBand.setDescription(bandDescriptor.description);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.validExpression)) {
            targetBand.setValidPixelExpression(bandDescriptor.validExpression);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)bandDescriptor.unit)) {
            targetBand.setUnit(bandDescriptor.unit);
        }
        if (bandDescriptor.noDataValue != null) {
            targetBand.setNoDataValue(bandDescriptor.noDataValue.doubleValue());
            targetBand.setNoDataValueUsed(true);
        }
        if (bandDescriptor.spectralBandIndex != null) {
            targetBand.setSpectralBandIndex(bandDescriptor.spectralBandIndex.intValue());
        }
        if (bandDescriptor.spectralWavelength != null) {
            targetBand.setSpectralWavelength(bandDescriptor.spectralWavelength.floatValue());
        }
        if (bandDescriptor.spectralBandwidth != null) {
            targetBand.setSpectralBandwidth(bandDescriptor.spectralBandwidth.floatValue());
        }
        if (bandDescriptor.scalingOffset != null) {
            targetBand.setScalingOffset(bandDescriptor.scalingOffset.doubleValue());
        }
        if (bandDescriptor.scalingFactor != null) {
            targetBand.setScalingFactor(bandDescriptor.scalingFactor.doubleValue());
        }
        return targetBand;
    }

    private Dimension findTargetBandSize(RasterDataSymbol[] rasterDataSymbols) {
        if (rasterDataSymbols.length > 0) {
            RasterDataSymbol referenceSourceRaster = rasterDataSymbols[0];
            return referenceSourceRaster.getRaster().getRasterSize();
        }
        return this.targetProduct.getSceneRasterSize();
    }

    private Term createTerm(String expression, boolean performTypeChecking) {
        Term term;
        Namespace namespace = this.createNamespace();
        try {
            ParserImpl parser = new ParserImpl(namespace, performTypeChecking);
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            String msg = MessageFormat.format("Could not parse expression: ''{0}''. {1}", expression, e.getMessage());
            throw new OperatorException(msg, e);
        }
        return term;
    }

    private Namespace createNamespace() {
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace((Product[])this.sourceProducts, (int)0, (ProductNamespacePrefixProvider)new SourceProductNamespacePrefixProvider());
        if (this.variables != null) {
            for (Variable variable : this.variables) {
                Symbol symbol;
                if (ProductData.isFloatingPointType((int)ProductData.getType((String)variable.type))) {
                    symbol = SymbolFactory.createConstant((String)variable.name, (double)Double.parseDouble(variable.value));
                    namespace.registerSymbol(symbol);
                    continue;
                }
                if (ProductData.isIntType((int)ProductData.getType((String)variable.type))) {
                    symbol = SymbolFactory.createConstant((String)variable.name, (double)Long.parseLong(variable.value));
                    namespace.registerSymbol(symbol);
                    continue;
                }
                if ("boolean".equals(variable.type)) {
                    symbol = SymbolFactory.createConstant((String)variable.name, (boolean)Boolean.parseBoolean(variable.value));
                    namespace.registerSymbol(symbol);
                    continue;
                }
                throw new OperatorException("Illegal type name in variable declaration: " + variable.type);
            }
        }
        return namespace;
    }

    private class SourceProductNamespacePrefixProvider
    implements ProductNamespacePrefixProvider {
        private SourceProductNamespacePrefixProvider() {
        }

        public String getPrefix(Product product) {
            return "$" + BandMathsOp.this.getSourceProductId(product) + ".";
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BandMathsOp.class);
        }
    }

    public static class Variable {
        public String name;
        public String type;
        public String value;
    }

    public static class BandDescriptor {
        public String name;
        public String type;
        public String expression;
        public String description;
        public String unit;
        public String validExpression;
        public Double noDataValue;
        public Integer spectralBandIndex;
        public Float spectralWavelength;
        public Float spectralBandwidth;
        public Double scalingOffset;
        public Double scalingFactor;
    }
}

