/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;
import org.esa.snap.core.gpf.internal.OperatorSpiRegistryImpl;
import org.esa.snap.core.util.Guardian;

public class GPF {
    public static final String DISABLE_TILE_CACHE_PROPERTY = "snap.gpf.disableTileCache";
    public static final String USE_FILE_TILE_CACHE_PROPERTY = "snap.gpf.useFileTileCache";
    public static final String TILE_COMPUTATION_OBSERVER_PROPERTY = "snap.gpf.tileComputationObserver";
    public static final String SOURCE_PRODUCT_FIELD_NAME = "sourceProduct";
    public static final String TARGET_PRODUCT_FIELD_NAME = "targetProduct";
    public static final RenderingHints.Key KEY_TILE_SIZE = new RenderingKey<Dimension>(1, Dimension.class, new RenderingKey.Validator<Dimension>(){

        @Override
        public boolean isValid(Dimension val) {
            return val.width > 0 && val.height > 0;
        }
    });
    public static final Map<String, Object> NO_PARAMS = Collections.unmodifiableMap(new TreeMap());
    public static final Map<String, Product> NO_SOURCES = Collections.unmodifiableMap(new TreeMap());
    private static GPF defaultInstance = new GPF();
    private OperatorSpiRegistry spiRegistry = new OperatorSpiRegistryImpl();

    protected GPF() {
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, NO_SOURCES);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, RenderingHints renderingHints) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, NO_SOURCES, renderingHints);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Product sourceProduct) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, sourceProduct, null);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Product sourceProduct, RenderingHints renderingHints) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, new Product[]{sourceProduct}, renderingHints);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Product ... sourceProducts) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, sourceProducts, null);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Product[] sourceProducts, RenderingHints renderingHints) throws OperatorException {
        Map<String, Product> sourceProductMap = NO_SOURCES;
        if (sourceProducts.length > 0) {
            SourceProductsDescriptor sourceProductsDescriptor;
            OperatorSpi operatorSpi = GPF.getDefaultInstance().spiRegistry.getOperatorSpi(operatorName);
            if (operatorSpi == null) {
                throw new OperatorException(String.format("Unknown operator '%s'. Note that operator aliases are case sensitive.", operatorName));
            }
            sourceProductMap = new HashMap<String, Product>(sourceProducts.length * 3);
            OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
            SourceProductDescriptor[] sourceProductDescriptors = operatorDescriptor.getSourceProductDescriptors();
            if (sourceProductDescriptors.length > 0) {
                sourceProductMap.put(SOURCE_PRODUCT_FIELD_NAME, sourceProducts[0]);
            }
            if ((sourceProductsDescriptor = operatorDescriptor.getSourceProductsDescriptor()) != null) {
                for (int i = 0; i < sourceProducts.length; ++i) {
                    Product sourceProduct = sourceProducts[i];
                    sourceProductMap.put("sourceProduct." + (i + 1), sourceProduct);
                    sourceProductMap.put(SOURCE_PRODUCT_FIELD_NAME + (i + 1), sourceProduct);
                }
            }
        }
        return defaultInstance.createProductNS(operatorName, parameters, sourceProductMap, renderingHints);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Map<String, Product> sourceProducts) throws OperatorException {
        return GPF.createProduct(operatorName, parameters, sourceProducts, null);
    }

    public static Product createProduct(String operatorName, Map<String, Object> parameters, Map<String, Product> sourceProducts, RenderingHints renderingHints) throws OperatorException {
        return defaultInstance.createProductNS(operatorName, parameters, sourceProducts, renderingHints);
    }

    public Product createProductNS(String operatorName, Map<String, Object> parameters, Map<String, Product> sourceProducts, RenderingHints renderingHints) {
        Operator operator = this.createOperator(operatorName, parameters, sourceProducts, renderingHints);
        return operator.getTargetProduct();
    }

    public Operator createOperator(String operatorName, Map<String, Object> parameters, Map<String, Product> sourceProducts, RenderingHints renderingHints) {
        OperatorSpi operatorSpi = this.spiRegistry.getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new OperatorException("No SPI found for operator '" + operatorName + "'");
        }
        return operatorSpi.createOperator(parameters, sourceProducts, renderingHints);
    }

    public OperatorSpiRegistry getOperatorSpiRegistry() {
        return this.spiRegistry;
    }

    public void setOperatorSpiRegistry(OperatorSpiRegistry spiRegistry) {
        Guardian.assertNotNull((String)"spiRegistry", (Object)spiRegistry);
        this.spiRegistry = spiRegistry;
    }

    public static GPF getDefaultInstance() {
        return defaultInstance;
    }

    public static void setDefaultInstance(GPF defaultInstance) {
        GPF.defaultInstance = defaultInstance;
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) {
        GPF.writeProduct(product, file, formatName, false, incremental, pm);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean clearCacheAfterRowWrite, boolean incremental, ProgressMonitor pm) {
        WriteOp writeOp = new WriteOp(product, file, formatName);
        writeOp.setDeleteOutputOnFailure(true);
        writeOp.setWriteEntireTileRows(true);
        writeOp.setClearCacheAfterRowWrite(clearCacheAfterRowWrite);
        writeOp.setIncremental(incremental);
        writeOp.writeProduct(pm);
    }

    static class RenderingKey<T>
    extends RenderingHints.Key {
        private final Class<T> objectClass;
        private final Validator<T> validator;

        RenderingKey(int privateKey, Class<T> objectClass, Validator<T> validator) {
            super(privateKey);
            this.objectClass = objectClass;
            this.validator = validator;
        }

        @Override
        public final boolean isCompatibleValue(Object val) {
            return val != null && this.objectClass.isAssignableFrom(val.getClass()) && this.validator.isValid(val);
        }

        static interface Validator<T> {
            public boolean isValid(T var1);
        }
    }
}

