/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard.reproject;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.OpImage;
import javax.media.jai.PixelAccessor;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.Warp;

class WarpFromSourceCoordinates
extends Warp {
    private final OpImage opImage;

    WarpFromSourceCoordinates(OpImage opImage) {
        this.opImage = opImage;
    }

    public float[] warpSparseRect(int xmin, int ymin, int width, int height, int periodX, int periodY, float[] destRect) {
        int yIDNew;
        if (periodX < 1) {
            throw new IllegalArgumentException(String.valueOf(periodX));
        }
        if (periodY < 1) {
            throw new IllegalArgumentException(String.valueOf(periodY));
        }
        int xmax = xmin + width;
        int ymax = ymin + height;
        int count = (width + (periodX - 1)) / periodX * ((height + (periodY - 1)) / periodY);
        if (destRect == null) {
            destRect = new float[2 * count];
        }
        Rectangle bounds = new Rectangle(xmin, ymin, width, height);
        int xIDNew = this.opImage.XToTileX(xmin);
        Raster tile = this.opImage.getTile(xIDNew, yIDNew = this.opImage.YToTileY(ymin));
        if (!tile.getBounds().contains(bounds)) {
            return destRect;
        }
        PixelAccessor accessor = new PixelAccessor((RenderedImage)this.opImage);
        UnpackedImageData srcImD = accessor.getPixels(tile, bounds, 4, false);
        float[] data = srcImD.getFloatData(0);
        int sxStart = srcImD.bandOffsets[0];
        int syStart = srcImD.bandOffsets[1];
        int pixelStride = srcImD.pixelStride;
        int lineStride = srcImD.lineStride;
        int index = 0;
        for (int y = ymin; y < ymax; y += periodY) {
            int sxPos = sxStart;
            int syPos = syStart;
            for (int x = xmin; x < xmax; x += periodX) {
                destRect[index++] = data[sxPos];
                destRect[index++] = data[syPos];
                sxPos += pixelStride;
                syPos += pixelStride;
            }
            sxStart += lineStride;
            syStart += lineStride;
        }
        return destRect;
    }
}

