/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="Read", category="Input-Output", version="1.1", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Reads a product from disk.")
public class ReadOp
extends Operator {
    @Parameter(description="The file from which the data product is read.", notNull=true, notEmpty=true)
    private File file;
    @TargetProduct
    private Product targetProduct;
    private transient ProductReader productReader;

    @Override
    public void initialize() throws OperatorException {
        try {
            ProductReader productReader = ProductIO.getProductReaderForInput((Object)this.file);
            if (productReader == null) {
                throw new OperatorException("No product reader found for file " + this.file);
            }
            this.targetProduct = productReader.readProductNodes((Object)this.file, null);
            this.productReader = productReader;
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData dataBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.productReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, dataBuffer, pm);
            targetTile.setRawSamples(dataBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ReadOp.class);
        }
    }
}

