/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="RRToFRS", internal=true)
public class RRToFRSOp
extends Operator {
    private GeoCoding rrGeoCoding;
    private GeoCoding frsGeoCoding;
    @SourceProduct(alias="frs")
    private Product frsProduct;
    @SourceProduct(alias="rr")
    private Product rrProduct;
    @TargetProduct
    private Product targetProduct;

    @Override
    public void initialize() throws OperatorException {
        Band[] srcBands;
        this.rrGeoCoding = this.rrProduct.getGeoCoding();
        this.frsGeoCoding = this.frsProduct.getGeoCoding();
        int width = this.frsProduct.getSceneRasterWidth();
        int height = this.frsProduct.getSceneRasterHeight();
        this.checkThatRRContainsFRSData(width, height);
        this.targetProduct = new Product("L1", "L1", width, height);
        for (Band sourceBand : srcBands = this.rrProduct.getBands()) {
            Band targetBand = this.targetProduct.addBand(sourceBand.getName(), sourceBand.getDataType());
            ProductUtils.copySpectralBandProperties((Band)sourceBand, (Band)targetBand);
            targetBand.setDescription(sourceBand.getDescription());
            targetBand.setUnit(sourceBand.getUnit());
            targetBand.setScalingFactor(sourceBand.getScalingFactor());
            targetBand.setScalingOffset(sourceBand.getScalingOffset());
            targetBand.setLog10Scaled(sourceBand.isLog10Scaled());
            targetBand.setNoDataValueUsed(sourceBand.isNoDataValueUsed());
            targetBand.setNoDataValue(sourceBand.getNoDataValue());
            if (sourceBand.getFlagCoding() == null) continue;
            FlagCoding srcFlagCoding = sourceBand.getFlagCoding();
            ProductUtils.copyFlagCoding((FlagCoding)srcFlagCoding, (Product)this.targetProduct);
            targetBand.setSampleCoding((SampleCoding)this.targetProduct.getFlagCodingGroup().get(srcFlagCoding.getName()));
        }
    }

    private void checkThatRRContainsFRSData(int width, int height) throws OperatorException {
        this.getRrPixelPos(0, 0);
        this.getRrPixelPos(0, height - 1);
        this.getRrPixelPos(width - 1, 0);
        this.getRrPixelPos(width - 1, height - 1);
    }

    private PixelPos getRrPixelPos(int x, int y) throws OperatorException {
        int yrr;
        PixelPos frsPixelPos = new PixelPos((float)x, (float)y);
        GeoPos geoPos = this.frsGeoCoding.getGeoPos(frsPixelPos, null);
        PixelPos rrPixelPos = this.rrGeoCoding.getPixelPos(geoPos, null);
        int xrr = Math.round(rrPixelPos.x);
        if (this.rrProduct.containsPixel((float)xrr, (float)(yrr = Math.round(rrPixelPos.y)))) {
            return rrPixelPos;
        }
        throw new OperatorException("RR product does not contain data for this coordinate: x=" + x + " y=" + y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle frsRectangle = targetTile.getRectangle();
        Band rrSrcBand = this.rrProduct.getBand(band.getName());
        pm.beginTask("compute", frsRectangle.height);
        PixelPos rrPixelPos = this.getRrPixelPos(frsRectangle.x, frsRectangle.y);
        int xStart = Math.round(rrPixelPos.x);
        int yStart = Math.round(rrPixelPos.y);
        Rectangle rrRectangle = new Rectangle(xStart, yStart, frsRectangle.width / 4, frsRectangle.height / 4);
        rrRectangle.grow(4, 4);
        Rectangle sceneRectangle = new Rectangle(rrSrcBand.getSceneRasterWidth(), rrSrcBand.getSceneRasterHeight());
        rrRectangle = rrRectangle.intersection(sceneRectangle);
        Tile srcTile = this.getSourceTile((RasterDataNode)rrSrcBand, rrRectangle);
        try {
            int rrY = yStart;
            int iy = 0;
            for (int y = frsRectangle.y; y < frsRectangle.y + frsRectangle.height; ++y) {
                int rrX = xStart;
                int ix = 0;
                for (int x = frsRectangle.x; x < frsRectangle.x + frsRectangle.width; ++x) {
                    double d = srcTile.getSampleDouble(rrX, rrY);
                    targetTile.setSample(x, y, d);
                    if (ix < 3) {
                        ++ix;
                        continue;
                    }
                    ix = 0;
                    ++rrX;
                }
                if (iy < 3) {
                    ++iy;
                } else {
                    iy = 0;
                    ++rrY;
                }
                this.checkForCancellation();
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RRToFRSOp.class);
        }
    }
}

