/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.main;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.graph.Graph;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.graph.GraphIO;
import org.esa.beam.framework.gpf.graph.GraphProcessingObserver;
import org.esa.beam.framework.gpf.graph.GraphProcessor;
import org.esa.beam.framework.gpf.main.CommandLineContext;
import org.esa.beam.util.logging.BeamLogManager;

class DefaultCommandLineContext
implements CommandLineContext {
    DefaultCommandLineContext() {
    }

    @Override
    public Product readProduct(String productFilepath) throws IOException {
        File input = new File(productFilepath);
        ProductReader productReader = ProductIO.getProductReaderForInput((Object)input);
        if (productReader == null) {
            throw new OperatorException("No product reader found for '" + productFilepath + "'");
        }
        Product product = productReader.readProductNodes((Object)input, null);
        if (product.getProductReader() == null) {
            product.setProductReader(productReader);
        }
        return product;
    }

    @Override
    public void writeProduct(Product targetProduct, String filePath, String formatName, boolean clearCacheAfterRowWrite) throws IOException {
        GPF.writeProduct(targetProduct, new File(filePath), formatName, clearCacheAfterRowWrite, false, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graph readGraph(String filePath, Map<String, String> templateVariables) throws GraphException, IOException {
        Graph graph;
        try (Reader fileReader = this.createReader(filePath);){
            graph = GraphIO.read(fileReader, templateVariables);
        }
        return graph;
    }

    @Override
    public void executeGraph(Graph graph, GraphProcessingObserver observer) throws GraphException {
        GraphProcessor processor = new GraphProcessor();
        if (observer != null) {
            processor.addObserver(observer);
        }
        processor.executeGraph(graph, ProgressMonitor.NULL);
    }

    @Override
    public void print(String m) {
        System.out.print(m);
    }

    @Override
    public Logger getLogger() {
        return BeamLogManager.getSystemLogger();
    }

    public Reader createReader(String textFilePath) throws FileNotFoundException {
        return new FileReader(textFilePath);
    }

    public Writer createWriter(String fileName) throws IOException {
        return new FileWriter(fileName);
    }

    public String[] list(String path) throws IOException {
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            return directory.list();
        }
        return null;
    }

    @Override
    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public boolean isFile(String path) {
        return new File(path).isFile();
    }
}

