/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.doclet;

import com.sun.javadoc.FieldDoc;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.doclet.FieldDesc;
import org.esa.beam.util.StringUtils;

public class ParameterDesc
extends FieldDesc {
    private final Parameter annotation;

    ParameterDesc(Field field, FieldDoc fieldDoc, Parameter annotation) {
        super(field, fieldDoc);
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        if (StringUtils.isNotNullAndNotEmpty((String)this.annotation.alias())) {
            return this.annotation.alias();
        }
        return super.getName();
    }

    @Override
    public String getShortDescription() {
        return this.annotation.description();
    }

    public String getDefaultValue() {
        return this.annotation.defaultValue();
    }

    public String getConstraints() {
        String format = this.annotation.format();
        boolean notNull = this.annotation.notNull();
        boolean notEmpty = this.annotation.notEmpty();
        Object[] valueSet = this.annotation.valueSet();
        String interval = this.annotation.interval();
        String pattern = this.annotation.pattern();
        StringBuilder sb = new StringBuilder(64);
        if (notNull) {
            ParameterDesc.appendItem(sb, "not null");
        }
        if (notEmpty) {
            ParameterDesc.appendItem(sb, "non empty");
        }
        if (StringUtils.isNotNullAndNotEmpty((String)format)) {
            ParameterDesc.appendItem(sb, "format: " + format);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)pattern)) {
            ParameterDesc.appendItem(sb, "pattern: " + pattern);
        }
        if (valueSet != null && valueSet.length > 0) {
            ParameterDesc.appendItem(sb, "value set: " + Arrays.toString(valueSet));
        }
        if (StringUtils.isNotNullAndNotEmpty((String)interval)) {
            ParameterDesc.appendItem(sb, "interval: " + interval);
        }
        return sb.toString();
    }

    private static void appendItem(StringBuilder sb, String str) {
        sb.append(sb.length() > 0 ? "; " : "");
        sb.append(str);
    }
}

