/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.descriptor;

import com.bc.ceres.core.Assert;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.descriptor.AnnotationOperatorDescriptorBody;
import org.esa.beam.framework.gpf.descriptor.OperatorDescriptor;
import org.esa.beam.framework.gpf.descriptor.ParameterDescriptor;
import org.esa.beam.framework.gpf.descriptor.SourceProductDescriptor;
import org.esa.beam.framework.gpf.descriptor.SourceProductsDescriptor;
import org.esa.beam.framework.gpf.descriptor.TargetProductDescriptor;
import org.esa.beam.framework.gpf.descriptor.TargetPropertyDescriptor;

public class AnnotationOperatorDescriptor
implements OperatorDescriptor {
    private OperatorMetadata annotation;
    private AnnotationOperatorDescriptorBody body;

    public AnnotationOperatorDescriptor(Class<? extends Operator> operatorType, OperatorMetadata annotation) {
        Assert.notNull(operatorType, (String)"operatorType");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.body = new AnnotationOperatorDescriptorBody(operatorType);
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.body.getOperatorClass().getName();
    }

    public OperatorMetadata getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getLabel() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public String getAlias() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.alias());
    }

    @Override
    public String getVersion() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.version());
    }

    @Override
    public String getAuthors() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.authors());
    }

    @Override
    public String getCopyright() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.copyright());
    }

    @Override
    public String getDescription() {
        return AnnotationOperatorDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    @Override
    public boolean isInternal() {
        return this.annotation.internal();
    }

    @Override
    public boolean isAutoWriteDisabled() {
        return this.annotation.autoWriteDisabled();
    }

    @Override
    public Class<? extends Operator> getOperatorClass() {
        return this.body.getOperatorClass();
    }

    @Override
    public SourceProductDescriptor[] getSourceProductDescriptors() {
        return this.body.getSourceProductDescriptors();
    }

    @Override
    public SourceProductsDescriptor getSourceProductsDescriptor() {
        return this.body.getSourceProductsDescriptor();
    }

    @Override
    public TargetProductDescriptor getTargetProductDescriptor() {
        return this.body.getTargetProductDescriptor();
    }

    @Override
    public TargetPropertyDescriptor[] getTargetPropertyDescriptors() {
        return this.body.getTargetPropertyDescriptors();
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        return this.body.getParameterDescriptors();
    }

    private static String getNonEmptyStringOrNull(String label) {
        return label == null || label.isEmpty() ? null : label;
    }
}

