/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.resample;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.AppContext;

class ResamplingDialog
extends SingleTargetProductDialog {
    private final String operatorName;
    private final OperatorDescriptor operatorDescriptor;
    private final String REFERENCE_BAND_TOOLTIP_TEXT = "<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>";
    private final String TARGET_WIDTH_AND_HEIGHT_TOOLTIP_TEXT = "<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>";
    private final String TARGET_RESOLUTION_TOOLTIP_TEXT = "<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>";
    private static final String REFERENCE_BAND_NAME_PROPERTY_NAME = "referenceBandName";
    private static final String TARGET_WIDTH_PROPERTY_NAME = "targetWidth";
    private static final String TARGET_HEIGHT_PROPERTY_NAME = "targetHeight";
    private static final String TARGET_RESOLUTION_PROPERTY_NAME = "targetResolution";
    private static final int REFERENCE_BAND_NAME_PANEL_INDEX = 0;
    private static final int TARGET_WIDTH_AND_HEIGHT_PANEL_INDEX = 1;
    private static final int TARGET_RESOLUTION_PANEL_INDEX = 2;
    private DefaultIOParametersPanel ioParametersPanel;
    private final OperatorParameterSupport parameterSupport;
    private final BindingContext bindingContext;
    private JTabbedPane form;
    private String targetProductNameSuffix = "_resampled";
    private ProductChangedHandler productChangedHandler;
    private Product targetProduct;
    private JRadioButton referenceBandButton;
    private JRadioButton widthAndHeightButton;
    private JRadioButton resolutionButton;
    private ReferenceBandNameBoxPanel referenceBandNameBoxPanel;
    private TargetWidthAndHeightPanel targetWidthAndHeightPanel;
    private TargetResolutionPanel targetResolutionPanel;

    ResamplingDialog(AppContext appContext, Product product, boolean modal) {
        super(appContext, "Resampling", 24, "resampleAction");
        this.operatorName = "Resample";
        this.getTargetProductSelector().getModel().setSaveToFileSelected(false);
        this.getJDialog().setModal(modal);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(this.operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("No SPI found for operator name '" + this.operatorName + "'");
        }
        this.operatorDescriptor = operatorSpi.getOperatorDescriptor();
        this.ioParametersPanel = new DefaultIOParametersPanel(this.getAppContext(), this.operatorDescriptor, this.getTargetProductSelector(), true);
        this.targetProduct = null;
        this.parameterSupport = new OperatorParameterSupport(this.operatorDescriptor, null, null, (ParameterUpdater)new ResamplingParameterUpdater());
        ArrayList<SourceProductSelector> sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertySet);
        Property referenceBandNameProperty = this.bindingContext.getPropertySet().getProperty(REFERENCE_BAND_NAME_PROPERTY_NAME);
        referenceBandNameProperty.getDescriptor().addAttributeChangeListener(evt -> {
            Object[] valueSetItems;
            if (evt.getPropertyName().equals("valueSet") && (valueSetItems = ((ValueSet)evt.getNewValue()).getItems()).length > 0) {
                try {
                    referenceBandNameProperty.setValue((Object)valueSetItems[0].toString());
                }
                catch (ValidationException validationException) {
                    // empty catch block
                }
            }
        });
        ValueRange valueRange = new ValueRange(0.0, 2.147483647E9);
        this.bindingContext.getPropertySet().getProperty(TARGET_WIDTH_PROPERTY_NAME).getDescriptor().setValueRange(valueRange);
        this.bindingContext.getPropertySet().getProperty(TARGET_HEIGHT_PROPERTY_NAME).getDescriptor().setValueRange(valueRange);
        this.bindingContext.getPropertySet().getProperty(TARGET_RESOLUTION_PROPERTY_NAME).getDescriptor().setValueRange(valueRange);
        this.productChangedHandler = new ProductChangedHandler();
        sourceProductSelectorList.get(0).setSelectedProduct(product);
        sourceProductSelectorList.get(0).addSelectionChangeListener((SelectionChangeListener)this.productChangedHandler);
    }

    public int show() {
        if (this.form == null) {
            this.initForm();
            if (this.getJDialog().getJMenuBar() == null) {
                OperatorMenu operatorMenu = this.createDefaultMenuBar();
                this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
            }
        }
        this.ioParametersPanel.initSourceProductSelectors();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.productChangedHandler.releaseProduct();
        this.ioParametersPanel.releaseSourceProductSelectors();
        super.hide();
    }

    @Override
    protected void onApply() {
        super.onApply();
        if (this.targetProduct != null && this.getJDialog().isModal()) {
            this.close();
        }
    }

    @Override
    protected Product createTargetProduct() throws Exception {
        HashMap<String, Product> sourceProducts = this.ioParametersPanel.createSourceProductsMap();
        this.targetProduct = GPF.createProduct((String)this.operatorName, this.parameterSupport.getParameterMap(), sourceProducts);
        return this.targetProduct;
    }

    Product getTargetProduct() {
        return this.targetProduct;
    }

    private void initForm() {
        this.form = new JTabbedPane();
        this.form.add("I/O Parameters", this.ioParametersPanel);
        this.form.add("Resampling Parameters", new JScrollPane(this.createParametersPanel()));
        this.reactToSourceProductChange(this.ioParametersPanel.getSourceProductSelectorList().get(0).getSelectedProduct());
    }

    private JPanel createParametersPanel() {
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        PropertySet propertySet = this.bindingContext.getPropertySet();
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTablePadding(4, 4);
        TableLayout defineTargetResolutionPanelLayout = new TableLayout(2);
        defineTargetResolutionPanelLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        defineTargetResolutionPanelLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        defineTargetResolutionPanelLayout.setColumnWeightX(1, Double.valueOf(1.0));
        defineTargetResolutionPanelLayout.setTablePadding(4, 5);
        JPanel defineTargetSizePanel = new JPanel((LayoutManager)defineTargetResolutionPanelLayout);
        defineTargetSizePanel.setBorder(BorderFactory.createTitledBorder("Define size of resampled product"));
        ButtonGroup targetSizeButtonGroup = new ButtonGroup();
        this.referenceBandButton = new JRadioButton("By reference band from source product:");
        this.referenceBandButton.setToolTipText("<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>");
        this.widthAndHeightButton = new JRadioButton("By target width and height:");
        this.widthAndHeightButton.setToolTipText("<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>");
        this.resolutionButton = new JRadioButton("By pixel resolution (in m):");
        this.resolutionButton.setToolTipText("<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>");
        targetSizeButtonGroup.add(this.referenceBandButton);
        targetSizeButtonGroup.add(this.widthAndHeightButton);
        targetSizeButtonGroup.add(this.resolutionButton);
        defineTargetSizePanel.add(this.referenceBandButton);
        this.referenceBandNameBoxPanel = new ReferenceBandNameBoxPanel();
        defineTargetSizePanel.add(this.referenceBandNameBoxPanel);
        defineTargetSizePanel.add(this.widthAndHeightButton);
        this.targetWidthAndHeightPanel = new TargetWidthAndHeightPanel();
        defineTargetSizePanel.add(this.targetWidthAndHeightPanel);
        defineTargetSizePanel.add(this.resolutionButton);
        this.targetResolutionPanel = new TargetResolutionPanel();
        defineTargetSizePanel.add(this.targetResolutionPanel);
        this.referenceBandButton.addActionListener(e -> {
            if (this.referenceBandButton.isSelected()) {
                this.enablePanel(0);
            }
        });
        this.widthAndHeightButton.addActionListener(e -> {
            if (this.widthAndHeightButton.isSelected()) {
                this.enablePanel(1);
            }
        });
        this.resolutionButton.addActionListener(e -> {
            if (this.resolutionButton.isSelected()) {
                this.enablePanel(2);
            }
        });
        this.referenceBandButton.setSelected(true);
        JPanel upsamplingMethodPanel = this.createPropertyPanel(propertySet, "upsamplingMethod", registry);
        JPanel downsamplingMethodPanel = this.createPropertyPanel(propertySet, "downsamplingMethod", registry);
        JPanel flagDownsamplingMethodPanel = this.createPropertyPanel(propertySet, "flagDownsamplingMethod", registry);
        JPanel resampleOnPyramidLevelsPanel = this.createPropertyPanel(propertySet, "resampleOnPyramidLevels", registry);
        JPanel parametersPanel = new JPanel((LayoutManager)tableLayout);
        parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        parametersPanel.add(defineTargetSizePanel);
        parametersPanel.add(upsamplingMethodPanel);
        parametersPanel.add(downsamplingMethodPanel);
        parametersPanel.add(flagDownsamplingMethodPanel);
        parametersPanel.add(resampleOnPyramidLevelsPanel);
        parametersPanel.add(tableLayout.createVerticalSpacer());
        return parametersPanel;
    }

    private void enablePanel(int panelIndex) {
        this.referenceBandNameBoxPanel.setEnabled(panelIndex == 0);
        this.targetWidthAndHeightPanel.setEnabled(panelIndex == 1);
        this.targetResolutionPanel.setEnabled(panelIndex == 2);
    }

    private JPanel createPropertyPanel(PropertySet propertySet, String propertyName, PropertyEditorRegistry registry) {
        PropertyDescriptor descriptor = propertySet.getProperty(propertyName).getDescriptor();
        PropertyEditor propertyEditor = registry.findPropertyEditor(descriptor);
        JComponent[] components = propertyEditor.createComponents(descriptor, this.bindingContext);
        JPanel propertyPanel = new JPanel(new GridLayout(1, components.length));
        for (int i = components.length - 1; i >= 0; --i) {
            propertyPanel.add(components[i]);
        }
        return propertyPanel;
    }

    private OperatorMenu createDefaultMenuBar() {
        return new OperatorMenu(this.getJDialog(), this.operatorDescriptor, this.parameterSupport, this.getAppContext(), this.getHelpID());
    }

    private void reactToSourceProductChange(Product product) {
        this.referenceBandNameBoxPanel.reactToSourceProductChange(product);
        this.targetWidthAndHeightPanel.reactToSourceProductChange(product);
        this.targetResolutionPanel.reactToSourceProductChange(product);
        if (product != null) {
            this.referenceBandButton.setEnabled(product.getBandNames().length > 0);
            ProductNodeGroup productBands = product.getBandGroup();
            ProductNodeGroup productTiePointGrids = product.getTiePointGridGroup();
            double xOffset = Double.NaN;
            double yOffset = Double.NaN;
            if (productBands.getNodeCount() > 0) {
                xOffset = ((Band)productBands.get(0)).getImageToModelTransform().getTranslateX();
                yOffset = ((Band)productBands.get(0)).getImageToModelTransform().getTranslateY();
            } else if (productTiePointGrids.getNodeCount() > 0) {
                xOffset = ((TiePointGrid)productTiePointGrids.get(0)).getImageToModelTransform().getTranslateX();
                yOffset = ((TiePointGrid)productTiePointGrids.get(0)).getImageToModelTransform().getTranslateY();
            }
            boolean allowToSetWidthAndHeight = true;
            if (!Double.isNaN(xOffset) && !Double.isNaN(yOffset)) {
                allowToSetWidthAndHeight = this.allOffsetsAreEqual(productBands, xOffset, yOffset) && this.allOffsetsAreEqual(productTiePointGrids, xOffset, yOffset);
            }
            this.widthAndHeightButton.setEnabled(allowToSetWidthAndHeight);
            GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
            this.resolutionButton.setEnabled(sceneGeoCoding != null && sceneGeoCoding instanceof CrsGeoCoding);
        }
        if (this.referenceBandButton.isEnabled()) {
            this.referenceBandButton.setSelected(true);
            this.referenceBandNameBoxPanel.setEnabled(true);
        } else if (this.widthAndHeightButton.isEnabled()) {
            this.widthAndHeightButton.setSelected(true);
        } else if (this.resolutionButton.isEnabled()) {
            this.resolutionButton.setSelected(true);
        }
    }

    private RasterDataNode getAnyRasterDataNode(Product product) {
        RasterDataNode node = null;
        if (product != null) {
            ProductNodeGroup bandGroup = product.getBandGroup();
            if (bandGroup.getNodeCount() == 0) {
                ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
                if (tiePointGridGroup.getNodeCount() > 0) {
                    node = (RasterDataNode)tiePointGridGroup.get(0);
                }
            } else {
                node = (RasterDataNode)bandGroup.get(0);
            }
        }
        return node;
    }

    private boolean allOffsetsAreEqual(ProductNodeGroup productNodeGroup, double xOffset, double yOffset) {
        for (int i = 0; i < productNodeGroup.getNodeCount(); ++i) {
            double nodeXOffset = ((RasterDataNode)productNodeGroup.get(i)).getImageToModelTransform().getTranslateX();
            double nodeYOffset = ((RasterDataNode)productNodeGroup.get(i)).getImageToModelTransform().getTranslateY();
            if (!(Math.abs(nodeXOffset - xOffset) > 1.0E-8) && !(Math.abs(nodeYOffset - yOffset) > 1.0E-8)) continue;
            return false;
        }
        return true;
    }

    private class ResamplingParameterUpdater
    implements ParameterUpdater {
        private ResamplingParameterUpdater() {
        }

        @Override
        public void handleParameterSaveRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
        }

        @Override
        public void handleParameterLoadRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
            ResamplingDialog.this.referenceBandNameBoxPanel.handleParameterLoadRequest(parameterMap);
            ResamplingDialog.this.targetWidthAndHeightPanel.handleParameterLoadRequest(parameterMap);
            ResamplingDialog.this.targetResolutionPanel.handleParameterLoadRequest(parameterMap);
        }
    }

    private class ProductChangedHandler
    extends AbstractSelectionChangeListener
    implements ProductNodeListener {
        private Product currentProduct;

        private ProductChangedHandler() {
        }

        public void releaseProduct() {
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                this.currentProduct = null;
            }
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Product selectedProduct;
            Selection selection = event.getSelection();
            if (selection != null && (selectedProduct = (Product)selection.getSelectedValue()) != this.currentProduct) {
                if (this.currentProduct != null) {
                    this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                }
                this.currentProduct = selectedProduct;
                if (this.currentProduct != null) {
                    this.currentProduct.addProductNodeListener((ProductNodeListener)this);
                }
                if (ResamplingDialog.this.getTargetProductSelector() != null) {
                    this.updateTargetProductName();
                }
                ResamplingDialog.this.reactToSourceProductChange(this.currentProduct);
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        private void updateTargetProductName() {
            String productName = "";
            if (this.currentProduct != null) {
                productName = this.currentProduct.getName();
            }
            TargetProductSelectorModel targetProductSelectorModel = ResamplingDialog.this.getTargetProductSelector().getModel();
            targetProductSelectorModel.setProductName(productName + ResamplingDialog.this.targetProductNameSuffix);
        }

        private void handleProductNodeEvent() {
            ResamplingDialog.this.reactToSourceProductChange(this.currentProduct);
        }
    }

    private class ReferenceBandNameBoxPanel
    extends JPanel {
        private JComboBox<String> referenceBandNameBox;
        private JLabel referenceBandTargetWidthLabel;
        private JLabel referenceBandTargetHeightLabel;
        private final JLabel referenceBandTargetHeightNameLabel;
        private final JLabel referenceBandTargetWidthNameLabel;

        ReferenceBandNameBoxPanel() {
            this.setToolTipText("<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>");
            this.referenceBandNameBox = new JComboBox();
            this.referenceBandNameBox.addActionListener(e -> this.updateReferenceBandTargetWidthAndHeight());
            GridLayout referenceBandNameBoxPanelLayout = new GridLayout(3, 1);
            referenceBandNameBoxPanelLayout.setVgap(2);
            this.setLayout(referenceBandNameBoxPanelLayout);
            this.add(this.referenceBandNameBox);
            JPanel referenceBandNameTargetWidthPanel = new JPanel(new GridLayout(1, 2));
            this.referenceBandTargetWidthNameLabel = new JLabel("Resulting target width: ");
            referenceBandNameTargetWidthPanel.add(this.referenceBandTargetWidthNameLabel);
            this.referenceBandTargetWidthLabel = new JLabel();
            referenceBandNameTargetWidthPanel.add(this.referenceBandTargetWidthLabel);
            JPanel referenceBandNameTargetHeightPanel = new JPanel(new GridLayout(1, 2));
            this.referenceBandTargetHeightNameLabel = new JLabel("Resulting target height: ");
            referenceBandNameTargetHeightPanel.add(this.referenceBandTargetHeightNameLabel);
            this.referenceBandTargetHeightLabel = new JLabel();
            referenceBandNameTargetHeightPanel.add(this.referenceBandTargetHeightLabel);
            this.add(referenceBandNameTargetWidthPanel);
            this.add(referenceBandNameTargetHeightPanel);
            this.referenceBandNameBox.addActionListener(e -> this.updateReferenceBandName());
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.referenceBandNameBox.setEnabled(enabled);
            this.referenceBandTargetWidthLabel.setEnabled(enabled);
            this.referenceBandTargetHeightLabel.setEnabled(enabled);
            this.referenceBandTargetWidthNameLabel.setEnabled(enabled);
            this.referenceBandTargetHeightNameLabel.setEnabled(enabled);
            if (enabled) {
                this.updateReferenceBandName();
            }
        }

        private void updateReferenceBandTargetWidthAndHeight() {
            if (this.referenceBandNameBox.getSelectedItem() != null) {
                String bandName = this.referenceBandNameBox.getSelectedItem().toString();
                Band band = ResamplingDialog.this.ioParametersPanel.getSourceProductSelectorList().get(0).getSelectedProduct().getBand(bandName);
                this.referenceBandTargetWidthLabel.setText("" + band.getRasterWidth());
                this.referenceBandTargetHeightLabel.setText("" + band.getRasterHeight());
            }
        }

        private void updateReferenceBandName() {
            if (this.referenceBandNameBox.getSelectedItem() != null) {
                ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME, (Object)this.referenceBandNameBox.getSelectedItem().toString());
            } else {
                ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME, null);
            }
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_WIDTH_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_HEIGHT_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_RESOLUTION_PROPERTY_NAME, null);
        }

        private void reactToSourceProductChange(Product product) {
            this.referenceBandNameBox.removeAllItems();
            Object[] bandNames = new String[]{};
            if (product != null) {
                bandNames = product.getBandNames();
            }
            ResamplingDialog.this.bindingContext.getPropertySet().getProperty(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME).getDescriptor().setValueSet(new ValueSet(bandNames));
            this.referenceBandNameBox.setModel(new DefaultComboBoxModel<Object>(bandNames));
            this.updateReferenceBandTargetWidthAndHeight();
        }

        private void handleParameterLoadRequest(Map<String, Object> parameterMap) {
            if (parameterMap.containsKey(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME)) {
                this.referenceBandNameBox.setSelectedItem(parameterMap.get(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME));
                ResamplingDialog.this.referenceBandButton.setSelected(true);
                ResamplingDialog.this.enablePanel(0);
            }
        }
    }

    private class TargetWidthAndHeightPanel
    extends JPanel {
        private JSpinner widthSpinner;
        private JSpinner heightSpinner;
        private double targetWidthHeightRatio;
        private final JLabel targetWidthNameLabel;
        private final JLabel targetHeightNameLabel;
        private final JLabel widthHeightRatioNameLabel;
        private JLabel widthHeightRatioLabel;
        private boolean updatingTargetWidthAndHeight;

        TargetWidthAndHeightPanel() {
            this.setToolTipText("<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>");
            this.updatingTargetWidthAndHeight = false;
            this.targetWidthHeightRatio = 1.0;
            GridLayout layout = new GridLayout(3, 2);
            layout.setVgap(2);
            this.setLayout(layout);
            this.targetWidthNameLabel = new JLabel("Target width:");
            this.targetWidthNameLabel.setEnabled(false);
            this.add(this.targetWidthNameLabel);
            this.widthSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));
            this.widthSpinner.setEnabled(false);
            this.add(this.widthSpinner);
            this.targetHeightNameLabel = new JLabel("Target height:");
            this.targetHeightNameLabel.setEnabled(false);
            this.add(this.targetHeightNameLabel);
            this.heightSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));
            this.heightSpinner.setEnabled(false);
            this.add(this.heightSpinner);
            this.widthHeightRatioNameLabel = new JLabel("Width / height ratio: ");
            this.widthHeightRatioNameLabel.setEnabled(false);
            this.add(this.widthHeightRatioNameLabel);
            this.widthHeightRatioLabel = new JLabel();
            this.widthHeightRatioLabel.setEnabled(false);
            this.add(this.widthHeightRatioLabel);
            this.widthSpinner.addChangeListener(e -> this.updateTargetWidth());
            this.heightSpinner.addChangeListener(e -> this.updateTargetHeight());
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.widthSpinner.setEnabled(enabled);
            this.heightSpinner.setEnabled(enabled);
            this.widthHeightRatioLabel.setEnabled(enabled);
            this.targetWidthNameLabel.setEnabled(enabled);
            this.targetHeightNameLabel.setEnabled(enabled);
            this.widthHeightRatioNameLabel.setEnabled(enabled);
            if (enabled) {
                this.updateTargetWidthAndHeight();
            }
        }

        private void updateTargetWidth() {
            if (!this.updatingTargetWidthAndHeight) {
                this.updatingTargetWidthAndHeight = true;
                int targetWidth = Integer.parseInt(this.widthSpinner.getValue().toString());
                int targetHeight = (int)((double)targetWidth / this.targetWidthHeightRatio);
                this.heightSpinner.setValue(targetHeight);
                this.updateTargetWidthAndHeight();
                this.updatingTargetWidthAndHeight = false;
            }
        }

        private void updateTargetHeight() {
            if (!this.updatingTargetWidthAndHeight) {
                this.updatingTargetWidthAndHeight = true;
                int targetHeight = Integer.parseInt(this.heightSpinner.getValue().toString());
                int targetWidth = (int)((double)targetHeight * this.targetWidthHeightRatio);
                this.widthSpinner.setValue(targetWidth);
                this.updateTargetWidthAndHeight();
                this.updatingTargetWidthAndHeight = false;
            }
        }

        private void updateTargetWidthAndHeight() {
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_WIDTH_PROPERTY_NAME, (Object)Integer.parseInt(this.widthSpinner.getValue().toString()));
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_HEIGHT_PROPERTY_NAME, (Object)Integer.parseInt(this.heightSpinner.getValue().toString()));
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_RESOLUTION_PROPERTY_NAME, null);
        }

        private void reactToSourceProductChange(Product product) {
            if (product != null) {
                this.targetWidthHeightRatio = (double)product.getSceneRasterWidth() / (double)product.getSceneRasterHeight();
                this.widthSpinner.setValue(product.getSceneRasterWidth());
                this.heightSpinner.setValue(product.getSceneRasterHeight());
            } else {
                this.targetWidthHeightRatio = 1.0;
                this.widthSpinner.setValue(0);
                this.heightSpinner.setValue(0);
            }
            this.widthHeightRatioLabel.setText(String.format("%.5f", this.targetWidthHeightRatio));
        }

        private void handleParameterLoadRequest(Map<String, Object> parameterMap) {
            if (parameterMap.containsKey(ResamplingDialog.TARGET_WIDTH_PROPERTY_NAME) && parameterMap.containsKey(ResamplingDialog.TARGET_HEIGHT_PROPERTY_NAME)) {
                this.widthSpinner.setValue(parameterMap.get(ResamplingDialog.TARGET_WIDTH_PROPERTY_NAME));
                this.heightSpinner.setValue(parameterMap.get(ResamplingDialog.TARGET_HEIGHT_PROPERTY_NAME));
                ResamplingDialog.this.widthAndHeightButton.setSelected(true);
                ResamplingDialog.this.enablePanel(1);
            }
        }
    }

    private class TargetResolutionPanel
    extends JPanel {
        private JSpinner resolutionSpinner;
        private JLabel targetResolutionTargetWidthLabel;
        private JLabel targetResolutionTargetHeightLabel;
        private final JLabel targetResolutionTargetWidthNameLabel;
        private final JLabel targetResolutionNameTargetHeightLabel;

        TargetResolutionPanel() {
            this.setToolTipText("<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>");
            this.resolutionSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.resolutionSpinner.setEnabled(false);
            this.resolutionSpinner.addChangeListener(e -> this.updateTargetResolution());
            GridLayout layout = new GridLayout(3, 1);
            layout.setVgap(2);
            this.setLayout(layout);
            JPanel targetResolutionTargetWidthPanel = new JPanel(new GridLayout(1, 2));
            this.targetResolutionTargetWidthNameLabel = new JLabel("Resulting target width: ");
            this.targetResolutionTargetWidthNameLabel.setEnabled(false);
            targetResolutionTargetWidthPanel.add(this.targetResolutionTargetWidthNameLabel);
            this.targetResolutionTargetWidthLabel = new JLabel();
            this.targetResolutionTargetWidthLabel.setEnabled(false);
            targetResolutionTargetWidthPanel.add(this.targetResolutionTargetWidthLabel);
            JPanel targetResolutionTargetHeightPanel = new JPanel(new GridLayout(1, 2));
            this.targetResolutionNameTargetHeightLabel = new JLabel("Resulting target height: ");
            this.targetResolutionNameTargetHeightLabel.setEnabled(false);
            targetResolutionTargetHeightPanel.add(this.targetResolutionNameTargetHeightLabel);
            this.targetResolutionTargetHeightLabel = new JLabel();
            this.targetResolutionTargetHeightLabel.setEnabled(false);
            targetResolutionTargetHeightPanel.add(this.targetResolutionTargetHeightLabel);
            this.add(this.resolutionSpinner);
            this.add(targetResolutionTargetWidthPanel);
            this.add(targetResolutionTargetHeightPanel);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resolutionSpinner.setEnabled(enabled);
            this.targetResolutionTargetWidthLabel.setEnabled(enabled);
            this.targetResolutionTargetHeightLabel.setEnabled(enabled);
            this.targetResolutionTargetWidthNameLabel.setEnabled(enabled);
            this.targetResolutionNameTargetHeightLabel.setEnabled(enabled);
            if (enabled) {
                this.updateTargetResolution();
            }
        }

        private void updateTargetResolution() {
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.REFERENCE_BAND_NAME_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_WIDTH_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_HEIGHT_PROPERTY_NAME, null);
            ResamplingDialog.this.bindingContext.getPropertySet().setValue(ResamplingDialog.TARGET_RESOLUTION_PROPERTY_NAME, (Object)Integer.parseInt(this.resolutionSpinner.getValue().toString()));
            this.updateTargetResolutionTargetWidthAndHeight();
        }

        private void updateTargetResolutionTargetWidthAndHeight() {
            Product selectedProduct = ResamplingDialog.this.ioParametersPanel.getSourceProductSelectorList().get(0).getSelectedProduct();
            RasterDataNode node = ResamplingDialog.this.getAnyRasterDataNode(selectedProduct);
            int targetWidth = 0;
            int targetHeight = 0;
            if (node != null) {
                int resolution = Integer.parseInt(this.resolutionSpinner.getValue().toString());
                double nodeResolution = node.getImageToModelTransform().getScaleX();
                targetWidth = (int)((double)node.getRasterWidth() * (nodeResolution / (double)resolution));
                targetHeight = (int)((double)node.getRasterHeight() * (nodeResolution / (double)resolution));
            }
            this.targetResolutionTargetWidthLabel.setText("" + targetWidth);
            this.targetResolutionTargetHeightLabel.setText("" + targetHeight);
        }

        private void reactToSourceProductChange(Product product) {
            if (product != null) {
                this.resolutionSpinner.setValue(this.determineResolutionFromProduct(product));
            } else {
                this.resolutionSpinner.setValue(0);
            }
        }

        private void handleParameterLoadRequest(Map<String, Object> parameterMap) {
            if (parameterMap.containsKey(ResamplingDialog.TARGET_RESOLUTION_PROPERTY_NAME)) {
                this.resolutionSpinner.setValue(parameterMap.get(ResamplingDialog.TARGET_RESOLUTION_PROPERTY_NAME));
                ResamplingDialog.this.resolutionButton.setSelected(true);
                ResamplingDialog.this.enablePanel(2);
            }
        }

        private int determineResolutionFromProduct(Product product) {
            RasterDataNode node = ResamplingDialog.this.getAnyRasterDataNode(product);
            if (node != null) {
                return (int)node.getImageToModelTransform().getScaleX();
            }
            return 1;
        }
    }
}

