/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.common.MosaicOp;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.gpf.ui.mosaic.MosaicFormModel;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.io.FileArrayEditor;

class MosaicIOPanel
extends JPanel {
    private static final String INPUT_PRODUCT_DIR_KEY = "gpf.mosaic.input.product.dir";
    private final AppContext appContext;
    private final MosaicFormModel mosaicModel;
    private final PropertySet propertySet;
    private final TargetProductSelector targetProductSelector;
    private final SourceProductSelector updateProductSelector;
    private FileArrayEditor sourceFileEditor;

    MosaicIOPanel(AppContext appContext, MosaicFormModel mosaicModel, TargetProductSelector selector) {
        this.appContext = appContext;
        this.mosaicModel = mosaicModel;
        this.propertySet = mosaicModel.getPropertySet();
        FileArrayEditorContext context = new FileArrayEditorContext(appContext);
        this.sourceFileEditor = new FileArrayEditor(context, "Source products"){

            protected JFileChooser createFileChooserDialog() {
                JFileChooser fileChooser = super.createFileChooserDialog();
                fileChooser.setDialogTitle("Mosaic - Open Source Product(s)");
                return fileChooser;
            }
        };
        this.targetProductSelector = selector;
        this.updateProductSelector = new SourceProductSelector(appContext);
        this.updateProductSelector.setProductFilter(new UpdateProductFilter());
        this.init();
        this.propertySet.addPropertyChangeListener("updateMode", evt -> {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.propertySet.setValue("updateProduct", (Object)this.updateProductSelector.getSelectedProduct());
            } else {
                this.updateProductSelector.setSelectedProduct(null);
            }
        });
        this.propertySet.addPropertyChangeListener("updateProduct", (PropertyChangeListener)new TargetProductSelectorUpdater());
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTablePadding(3, 3);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setRowWeightY(0, Double.valueOf(1.0));
        this.add(this.createSourceProductsPanel());
        this.add(this.createTargetProductPanel());
        this.updateProductSelector.addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                Product product = (Product)event.getSelection().getSelectedValue();
                try {
                    if (product != null) {
                        Map map = MosaicOp.getOperatorParameters((Product)product);
                        Stream entrySetStream = map.entrySet().stream();
                        Stream<Map.Entry> filteredStream = entrySetStream.filter(entry -> MosaicIOPanel.this.propertySet.getProperty((String)entry.getKey()) != null);
                        filteredStream.forEach(entry -> MosaicIOPanel.this.propertySet.setValue((String)entry.getKey(), entry.getValue()));
                    }
                    MosaicIOPanel.this.propertySet.setValue("updateProduct", (Object)product);
                }
                catch (OperatorException e) {
                    MosaicIOPanel.this.appContext.handleError("Selected product cannot be used for update mode.", (Throwable)e);
                }
            }
        });
    }

    private JPanel createSourceProductsPanel() {
        FileArrayEditor.FileArrayEditorListener listener = files -> {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    MosaicIOPanel.this.mosaicModel.setSourceProducts(files);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (Exception e) {
                        String msg = String.format("Cannot display source products.\n%s", e.getMessage());
                        MosaicIOPanel.this.appContext.handleError(msg, (Throwable)e);
                    }
                }
            };
            worker.execute();
        };
        this.sourceFileEditor.setListener(listener);
        JButton addFileButton = this.sourceFileEditor.createAddFileButton();
        JButton removeFileButton = this.sourceFileEditor.createRemoveFileButton();
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        JPanel sourceProductPanel = new JPanel((LayoutManager)tableLayout);
        sourceProductPanel.setBorder(BorderFactory.createTitledBorder("Source Products"));
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(addFileButton);
        buttonPanel.add(removeFileButton);
        tableLayout.setRowPadding(0, new Insets(1, 4, 1, 4));
        sourceProductPanel.add(buttonPanel);
        JComponent fileArrayComponent = this.sourceFileEditor.createFileArrayComponent();
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        sourceProductPanel.add(fileArrayComponent);
        return sourceProductPanel;
    }

    private JPanel createTargetProductPanel() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setTablePadding(3, 3);
        JPanel targetProductPanel = new JPanel((LayoutManager)tableLayout);
        targetProductPanel.setBorder(BorderFactory.createTitledBorder("Target Product"));
        JCheckBox updateTargetCheckBox = new JCheckBox("Update target product", false);
        BindingContext context = new BindingContext(this.propertySet);
        context.bind("updateMode", updateTargetCheckBox);
        targetProductPanel.add(updateTargetCheckBox);
        CardLayout cards = new CardLayout(0, 3);
        JPanel subPanel = new JPanel(cards);
        JPanel newProductSelectorPanel = MosaicIOPanel.createTargetProductSelectorPanel(this.targetProductSelector);
        JPanel updateProductSelectorPanel = this.createUpdateProductSelectorPanel(this.updateProductSelector);
        String newProductKey = "NEW_PRODUCT";
        String updateProductKey = "UPDATE_PRODUCT";
        subPanel.add((Component)newProductSelectorPanel, "NEW_PRODUCT");
        subPanel.add((Component)updateProductSelectorPanel, "UPDATE_PRODUCT");
        updateTargetCheckBox.addActionListener(e -> {
            if (updateTargetCheckBox.isSelected()) {
                this.prepareHideTargetProductSelector();
                this.prepareShowUpdateProductSelector();
                cards.show(subPanel, "UPDATE_PRODUCT");
            } else {
                this.prepareShowTargetProductSelector();
                this.prepareHideUpdateProductSelector();
                cards.show(subPanel, "NEW_PRODUCT");
            }
        });
        cards.show(subPanel, "NEW_PRODUCT");
        targetProductPanel.add(subPanel);
        targetProductPanel.add(this.targetProductSelector.getOpenInAppCheckBox());
        return targetProductPanel;
    }

    private JPanel createUpdateProductSelectorPanel(SourceProductSelector selector) {
        JPanel subPanel = new JPanel(new BorderLayout(3, 3));
        subPanel.add(selector.getProductNameComboBox(), "Center");
        subPanel.add((Component)selector.getProductFileChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setRowFill(0, TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.add(selector.getProductNameLabel());
        panel.add(subPanel);
        panel.add(tableLayout.createVerticalSpacer());
        return panel;
    }

    private static JPanel createTargetProductSelectorPanel(TargetProductSelector selector) {
        JPanel subPanel1 = new JPanel(new BorderLayout(3, 3));
        subPanel1.add((Component)selector.getProductNameLabel(), "North");
        subPanel1.add((Component)selector.getProductNameTextField(), "Center");
        JPanel subPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        subPanel2.add(selector.getSaveToFileCheckBox());
        subPanel2.add(selector.getFormatNameComboBox());
        JPanel subPanel3 = new JPanel(new BorderLayout(3, 3));
        subPanel3.add((Component)selector.getProductDirLabel(), "North");
        subPanel3.add((Component)selector.getProductDirTextField(), "Center");
        subPanel3.add((Component)selector.getProductDirChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(1, 0, new Insets(3, 0, 3, 3));
        tableLayout.setCellPadding(2, 0, new Insets(0, 21, 3, 3));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.add(subPanel1);
        panel.add(subPanel2);
        panel.add(subPanel3);
        return panel;
    }

    void prepareShow() {
        this.prepareShowTargetProductSelector();
        if (this.mosaicModel.isUpdateMode()) {
            this.prepareShowUpdateProductSelector();
        }
    }

    private void prepareShowUpdateProductSelector() {
        this.updateProductSelector.initProducts();
    }

    private void prepareShowTargetProductSelector() {
        try {
            List files = this.sourceFileEditor.getFiles();
            this.mosaicModel.setSourceProducts(files.toArray(new File[files.size()]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void prepareHide() {
        this.prepareHideUpdateProductSelector();
        this.prepareHideTargetProductSelector();
    }

    private void prepareHideUpdateProductSelector() {
        this.updateProductSelector.releaseProducts();
    }

    private void prepareHideTargetProductSelector() {
        try {
            this.mosaicModel.setSourceProducts(new File[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class UpdateProductFilter
    implements ProductFilter {
        public boolean accept(Product product) {
            ProductReader productReader = product.getProductReader();
            if (productReader != null) {
                String formatName = productReader.getReaderPlugIn().getFormatNames()[0];
                ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
                Iterator writerIterator = ioPlugInManager.getWriterPlugIns(formatName);
                if (writerIterator.hasNext()) {
                    try {
                        MosaicOp.getOperatorParameters((Product)product);
                    }
                    catch (OperatorException e) {
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class TargetProductSelectorUpdater
    implements PropertyChangeListener {
        private TargetProductSelectorUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Product product = (Product)evt.getNewValue();
            TargetProductSelectorModel selectorModel = MosaicIOPanel.this.targetProductSelector.getModel();
            if (product != null) {
                String formatName = product.getProductReader().getReaderPlugIn().getFormatNames()[0];
                ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
                Iterator writerIterator = ioPlugInManager.getWriterPlugIns(formatName);
                if (writerIterator.hasNext()) {
                    selectorModel.setFormatName(formatName);
                } else {
                    String errMsg = "Cannot write to update product.";
                    String iseMsg = String.format("No product writer found for format '%s'", formatName);
                    MosaicIOPanel.this.appContext.handleError("Cannot write to update product.", (Throwable)new IllegalStateException(iseMsg));
                }
                File fileLocation = product.getFileLocation();
                String fileName = FileUtils.getFilenameWithoutExtension((File)fileLocation);
                File fileDir = fileLocation.getParentFile();
                selectorModel.setProductName(fileName);
                selectorModel.setProductDir(fileDir);
            } else {
                selectorModel.setFormatName("BEAM-DIMAP");
                selectorModel.setProductName("mosaic");
                String homeDirPath = SystemUtils.getUserHomeDir().getPath();
                PropertyMap prefs = MosaicIOPanel.this.appContext.getPreferences();
                String saveDir = prefs.getPropertyString("last_product_save_dir", homeDirPath);
                selectorModel.setProductDir(new File(saveDir));
            }
        }
    }

    private static class FileArrayEditorContext
    implements FileArrayEditor.EditorParent {
        private final AppContext applicationContext;

        private FileArrayEditorContext(AppContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public File getUserInputDir() {
            return this.getInputProductDir();
        }

        public void setUserInputDir(File newDir) {
            this.setInputProductDir(newDir);
        }

        private void setInputProductDir(File currentDirectory) {
            this.applicationContext.getPreferences().setPropertyString(MosaicIOPanel.INPUT_PRODUCT_DIR_KEY, currentDirectory.getAbsolutePath());
        }

        private File getInputProductDir() {
            String path = this.applicationContext.getPreferences().getPropertyString(MosaicIOPanel.INPUT_PRODUCT_DIR_KEY);
            File inputProductDir = path != null ? new File(path) : null;
            return inputProductDir;
        }
    }
}

