/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.swing.binding.ComponentAdapter;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

abstract class AbstractTableAdapter
extends ComponentAdapter
implements TableModelListener {
    private final JTable table;

    protected AbstractTableAdapter(JTable table) {
        this.table = table;
    }

    JTable getTable() {
        return this.table;
    }

    public final JComponent[] getComponents() {
        return new JComponent[]{this.table};
    }

    public final void bindComponents() {
        this.table.setModel(this.createTableModel(0));
        this.adjustTableModel();
        this.table.getModel().addTableModelListener(this);
    }

    public final void unbindComponents() {
        this.table.getModel().removeTableModelListener(this);
    }

    public final void adjustComponents() {
        this.adjustTableModel();
    }

    @Override
    public abstract void tableChanged(TableModelEvent var1);

    protected abstract DefaultTableModel createTableModel(int var1);

    private void adjustTableModel() {
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        Object value = this.getBinding().getPropertyValue();
        if (value instanceof Object[]) {
            int i;
            Object[] items = (Object[])value;
            for (i = tableModel.getRowCount(); i < items.length; ++i) {
                tableModel.addRow((Object[])null);
            }
            for (i = items.length; i < tableModel.getRowCount(); ++i) {
                tableModel.removeRow(i);
            }
            for (i = 0; i < items.length; ++i) {
                Object item = items[i];
                Field[] fields = item.getClass().getDeclaredFields();
                for (int k = 0; k < fields.length; ++k) {
                    Field field = fields[k];
                    boolean accessible = field.isAccessible();
                    if (!accessible) {
                        field.setAccessible(true);
                    }
                    try {
                        tableModel.setValueAt(field.get(item), i, k);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    if (accessible) continue;
                    field.setAccessible(false);
                }
            }
        }
    }
}

