/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.FileChooserFactory;

public class TargetProductSelector {
    private JLabel productNameLabel;
    private JTextField productNameTextField;
    private JCheckBox saveToFileCheckBox;
    private JLabel productDirLabel;
    private JTextField productDirTextField;
    private JButton productDirChooserButton;
    private JComboBox<String> formatNameComboBox;
    private JCheckBox openInAppCheckBox;
    private TargetProductSelectorModel model;
    private final boolean alwaysWriteOutput;

    public TargetProductSelector() {
        this(new TargetProductSelectorModel(), false);
    }

    public TargetProductSelector(TargetProductSelectorModel model) {
        this(model, false);
    }

    public TargetProductSelector(TargetProductSelectorModel model, boolean alwaysWriteOutput) {
        this.model = model;
        this.alwaysWriteOutput = alwaysWriteOutput;
        this.initComponents();
        this.bindComponents();
        this.updateUIState();
    }

    private void initComponents() {
        this.productNameLabel = new JLabel("Name: ");
        this.productNameTextField = new JTextField(25);
        this.productDirLabel = new JLabel("Directory:");
        this.productDirTextField = new JTextField(25);
        this.productDirChooserButton = new JButton(new ProductDirChooserAction());
        Dimension size = new Dimension(26, 16);
        this.productDirChooserButton.setPreferredSize(size);
        this.productDirChooserButton.setMinimumSize(size);
        if (!this.alwaysWriteOutput) {
            this.saveToFileCheckBox = new JCheckBox("Save as:");
            this.formatNameComboBox = new JComboBox<String>(this.model.getFormatNames());
            this.openInAppCheckBox = new JCheckBox("Open in application");
        }
    }

    private void bindComponents() {
        BindingContext bc = new BindingContext((PropertySet)this.model.getValueContainer());
        bc.bind("productName", this.productNameTextField);
        bc.bind("productDir", this.productDirTextField);
        if (!this.alwaysWriteOutput) {
            bc.bind("saveToFileSelected", this.saveToFileCheckBox);
            bc.bind("openInAppSelected", this.openInAppCheckBox);
            bc.bind("formatName", this.formatNameComboBox);
        }
        this.model.getValueContainer().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("productDir")) {
                    TargetProductSelector.this.productDirTextField.setToolTipText(TargetProductSelector.this.model.getProductDir().getPath());
                } else {
                    TargetProductSelector.this.updateUIState();
                }
            }
        });
    }

    public TargetProductSelectorModel getModel() {
        return this.model;
    }

    public JLabel getProductNameLabel() {
        return this.productNameLabel;
    }

    public JTextField getProductNameTextField() {
        return this.productNameTextField;
    }

    public JCheckBox getSaveToFileCheckBox() {
        return this.saveToFileCheckBox;
    }

    public JLabel getProductDirLabel() {
        return this.productDirLabel;
    }

    public JTextField getProductDirTextField() {
        return this.productDirTextField;
    }

    public JButton getProductDirChooserButton() {
        return this.productDirChooserButton;
    }

    public JComboBox<String> getFormatNameComboBox() {
        return this.formatNameComboBox;
    }

    public JCheckBox getOpenInAppCheckBox() {
        return this.openInAppCheckBox;
    }

    public JPanel createDefaultPanel() {
        JPanel subPanel1 = new JPanel(new BorderLayout(3, 3));
        subPanel1.add((Component)this.getProductNameLabel(), "North");
        subPanel1.add((Component)this.getProductNameTextField(), "Center");
        JPanel subPanel2 = null;
        if (!this.alwaysWriteOutput) {
            subPanel2 = new JPanel(new FlowLayout(3, 0, 0));
            subPanel2.add(this.getSaveToFileCheckBox());
            subPanel2.add(this.getFormatNameComboBox());
        }
        JPanel subPanel3 = new JPanel(new BorderLayout(3, 3));
        subPanel3.add((Component)this.getProductDirLabel(), "North");
        subPanel3.add((Component)this.getProductDirTextField(), "Center");
        subPanel3.add((Component)this.getProductDirChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(1, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(2, 0, new Insets(0, 24, 3, 3));
        tableLayout.setCellPadding(3, 0, new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.setBorder(BorderFactory.createTitledBorder("Target Product"));
        panel.add(subPanel1);
        if (!this.alwaysWriteOutput) {
            panel.add(subPanel2);
        }
        panel.add(subPanel3);
        if (!this.alwaysWriteOutput) {
            panel.add(this.getOpenInAppCheckBox());
        }
        return panel;
    }

    private void updateUIState() {
        if (this.model.isSaveToFileSelected()) {
            if (!this.alwaysWriteOutput) {
                this.openInAppCheckBox.setEnabled(this.model.canReadOutputFormat());
                this.formatNameComboBox.setEnabled(true);
            }
            this.productDirLabel.setEnabled(true);
            this.productDirTextField.setEnabled(true);
            this.productDirChooserButton.setEnabled(true);
        } else {
            if (!this.alwaysWriteOutput) {
                this.openInAppCheckBox.setEnabled(true);
                this.formatNameComboBox.setEnabled(false);
            }
            this.productDirLabel.setEnabled(false);
            this.productDirTextField.setEnabled(false);
            this.productDirChooserButton.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        this.productNameLabel.setEnabled(enabled);
        if (this.alwaysWriteOutput) {
            this.saveToFileCheckBox.setEnabled(enabled);
            this.formatNameComboBox.setEnabled(enabled);
            this.openInAppCheckBox.setEnabled(enabled);
        }
        this.productNameTextField.setEnabled(enabled);
        this.productDirLabel.setEnabled(enabled);
        this.productDirTextField.setEnabled(enabled);
        this.productDirChooserButton.setEnabled(enabled);
    }

    private class ProductDirChooserAction
    extends AbstractAction {
        private static final String APPROVE_BUTTON_TEXT = "Select";

        public ProductDirChooserAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Window windowAncestor = null;
            if (event.getSource() instanceof JComponent) {
                JComponent eventSource = (JComponent)event.getSource();
                windowAncestor = SwingUtilities.getWindowAncestor(eventSource);
            }
            JFileChooser chooser = FileChooserFactory.getInstance().createDirChooser(TargetProductSelector.this.model.getProductDir());
            chooser.setDialogTitle("Select Target Directory");
            if (chooser.showDialog(windowAncestor, APPROVE_BUTTON_TEXT) == 0) {
                File selectedDir = chooser.getSelectedFile();
                if (selectedDir != null) {
                    TargetProductSelector.this.model.setProductDir(selectedDir);
                } else {
                    TargetProductSelector.this.model.setProductDir(new File("."));
                }
            }
        }
    }
}

