/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.gpf.ui.mosaic.MosaicFormModel;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.BoundsInputPanel;
import org.esa.snap.ui.RegionSelectableWorldMapPane;
import org.esa.snap.ui.WorldMapPaneDataModel;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class MosaicMapProjectionPanel
extends JPanel {
    private final AppContext appContext;
    private final MosaicFormModel mosaicModel;
    private CrsSelectionPanel crsSelectionPanel;
    private BoundsInputPanel boundsInputPanel;
    private final BindingContext bindingCtx;
    private String[] demValueSet;

    MosaicMapProjectionPanel(AppContext appContext, MosaicFormModel mosaicModel) {
        this.appContext = appContext;
        this.mosaicModel = mosaicModel;
        this.bindingCtx = new BindingContext(mosaicModel.getPropertySet());
        this.init();
        this.createUI();
        this.updateForCrsChanged();
        this.bindingCtx.adjustComponents();
    }

    private void init() {
        ElevationModelDescriptor[] descriptors = ElevationModelRegistry.getInstance().getAllDescriptors();
        this.demValueSet = new String[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            this.demValueSet[i] = descriptors[i].getName();
        }
        if (this.demValueSet.length > 0) {
            this.mosaicModel.getPropertySet().setValue("elevationModelName", (Object)this.demValueSet[0]);
        }
        this.bindingCtx.addPropertyChangeListener("updateMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean updateMode = (Boolean)evt.getNewValue();
                Boolean enabled1 = updateMode == false;
                MosaicMapProjectionPanel.this.crsSelectionPanel.setEnabled(enabled1.booleanValue());
            }
        });
    }

    private void createUI() {
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setRowWeightY(2, Double.valueOf(1.0));
        layout.setTablePadding(3, 3);
        this.setLayout((LayoutManager)layout);
        CustomCrsForm customCrsUI = new CustomCrsForm(this.appContext);
        PredefinedCrsForm predefinedCrsUI = new PredefinedCrsForm(this.appContext);
        this.crsSelectionPanel = new CrsSelectionPanel(new CrsForm[]{customCrsUI, predefinedCrsUI});
        this.crsSelectionPanel.addPropertyChangeListener("crs", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MosaicMapProjectionPanel.this.updateForCrsChanged();
            }
        });
        this.add((Component)this.crsSelectionPanel);
        this.add(this.createOrthorectifyPanel());
        this.add(this.createMosaicBoundsPanel());
    }

    private void updateForCrsChanged() {
        float lon = (float)this.mosaicModel.getTargetEnvelope().getMedian(0);
        float lat = (float)this.mosaicModel.getTargetEnvelope().getMedian(1);
        try {
            CoordinateReferenceSystem crs = this.crsSelectionPanel.getCrs(new GeoPos((double)lat, (double)lon));
            if (crs != null) {
                this.updatePixelUnit(crs);
                this.mosaicModel.setTargetCRS(crs.toWKT());
            } else {
                this.mosaicModel.setTargetCRS(null);
            }
        }
        catch (FactoryException ignored) {
            this.mosaicModel.setTargetCRS(null);
        }
    }

    private void updatePixelUnit(CoordinateReferenceSystem crs) {
        this.boundsInputPanel.updatePixelUnit(crs);
    }

    private JPanel createMosaicBoundsPanel() {
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setRowWeightY(1, Double.valueOf(1.0));
        layout.setRowAnchor(2, TableLayout.Anchor.EAST);
        layout.setRowFill(2, TableLayout.Fill.NONE);
        layout.setTablePadding(3, 3);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Mosaic Bounds"));
        WorldMapPaneDataModel worldMapModel = this.mosaicModel.getWorldMapModel();
        this.setMapBoundary(worldMapModel);
        JPanel worldMapPanel = new RegionSelectableWorldMapPane(worldMapModel, this.bindingCtx).createUI();
        this.bindingCtx.addPropertyChangeListener((PropertyChangeListener)new MapBoundsChangeListener());
        worldMapPanel.setMinimumSize(new Dimension(250, 125));
        worldMapPanel.setBorder(BorderFactory.createEtchedBorder());
        JCheckBox showSourceProductsCheckBox = new JCheckBox("Display source products");
        this.bindingCtx.bind("showSourceProducts", showSourceProductsCheckBox);
        this.boundsInputPanel = new BoundsInputPanel(this.bindingCtx, "updateMode");
        panel.add(this.boundsInputPanel.createBoundsInputPanel(true));
        panel.add(worldMapPanel);
        panel.add(showSourceProductsCheckBox);
        return panel;
    }

    private JPanel createOrthorectifyPanel() {
        TableLayout layout = new TableLayout(2);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setTablePadding(3, 3);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Orthorectification"));
        JCheckBox orthoCheckBox = new JCheckBox("Orthorectify input products");
        this.bindingCtx.bind("orthorectify", orthoCheckBox);
        this.bindingCtx.bindEnabledState("orthorectify", false, "updateMode", (Object)true);
        final JComboBox<String> demComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(this.demValueSet));
        this.bindingCtx.bind("elevationModelName", demComboBox);
        this.bindingCtx.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("orthorectify".equals(evt.getPropertyName()) || "updateMode".equals(evt.getPropertyName())) {
                    PropertySet propertySet = MosaicMapProjectionPanel.this.bindingCtx.getPropertySet();
                    boolean updateMode = Boolean.TRUE.equals(propertySet.getValue("updateMode"));
                    boolean orthorectify = Boolean.TRUE.equals(propertySet.getValue("orthorectify"));
                    demComboBox.setEnabled(orthorectify && !updateMode);
                }
            }
        });
        layout.setCellColspan(0, 0, Integer.valueOf(2));
        panel.add(orthoCheckBox);
        layout.setCellWeightX(1, 0, Double.valueOf(0.0));
        panel.add(new JLabel("Elevation model:"));
        layout.setCellWeightX(1, 1, Double.valueOf(1.0));
        panel.add(demComboBox);
        return panel;
    }

    private void setMapBoundary(WorldMapPaneDataModel worldMapModel) {
        Product boundaryProduct;
        try {
            boundaryProduct = this.mosaicModel.getBoundaryProduct();
        }
        catch (Throwable ignored) {
            boundaryProduct = null;
        }
        worldMapModel.setSelectedProduct(boundaryProduct);
    }

    public void prepareShow() {
        this.crsSelectionPanel.prepareShow();
    }

    public void prepareHide() {
        this.crsSelectionPanel.prepareHide();
    }

    private class MapBoundsChangeListener
    implements PropertyChangeListener {
        private final List<String> knownProperties = Arrays.asList("westBound", "northBound", "eastBound", "southBound", "crs");

        private MapBoundsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.knownProperties.contains(evt.getPropertyName())) {
                MosaicMapProjectionPanel.this.setMapBoundary(MosaicMapProjectionPanel.this.mosaicModel.getWorldMapModel());
            }
        }
    }
}

